---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 98
  claims_with_evidence: 95
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：next-src-server-route-matcher-providers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：95 / 98、根拠なし：3
- 優先レビュー（高）
  1. **C-56（DevAppPageRouteMatcherProvider.transform の不変条件違反テスト）**：キャッシュ不整合状態を外部から再現するのが困難
  2. **C-95（BatchedFileReader.load の空ディレクトリリスト処理）**：スケジュール内部の早期リターン条件の直接テストは実装依存
  3. **C-98（BatchedFileReader.schedule のprocess.nextTick動作）**：privateメソッドの内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/route-matcher-providers/route-matcher-provider.ts` - RouteMatcherProviderインターフェース定義
- E-02: `packages/next/src/server/route-matcher-providers/manifest-route-matcher-provider.ts` - ManifestRouteMatcherProvider抽象クラス
- E-03: `packages/next/src/server/route-matcher-providers/app-page-route-matcher-provider.ts` - AppPageRouteMatcherProvider実装
- E-04: `packages/next/src/server/route-matcher-providers/app-route-route-matcher-provider.ts` - AppRouteRouteMatcherProvider実装
- E-05: `packages/next/src/server/route-matcher-providers/pages-route-matcher-provider.ts` - PagesRouteMatcherProvider実装
- E-06: `packages/next/src/server/route-matcher-providers/pages-api-route-matcher-provider.ts` - PagesAPIRouteMatcherProvider実装
- E-07: `packages/next/src/server/route-matcher-providers/helpers/cached-route-matcher-provider.ts` - CachedRouteMatcherProvider実装
- E-08: `packages/next/src/server/route-matcher-providers/helpers/manifest-loaders/manifest-loader.ts` - ManifestLoaderインターフェース
- E-09: `packages/next/src/server/route-matcher-providers/helpers/manifest-loaders/node-manifest-loader.ts` - NodeManifestLoader実装
- E-10: `packages/next/src/server/route-matcher-providers/helpers/manifest-loaders/server-manifest-loader.ts` - ServerManifestLoader実装
- E-11: `packages/next/src/server/route-matcher-providers/dev/file-cache-route-matcher-provider.ts` - FileCacheRouteMatcherProvider実装
- E-12: `packages/next/src/server/route-matcher-providers/dev/dev-app-page-route-matcher-provider.ts` - DevAppPageRouteMatcherProvider実装
- E-13: `packages/next/src/server/route-matcher-providers/dev/dev-app-route-route-matcher-provider.ts` - DevAppRouteRouteMatcherProvider実装
- E-14: `packages/next/src/server/route-matcher-providers/dev/dev-pages-route-matcher-provider.ts` - DevPagesRouteMatcherProvider実装
- E-15: `packages/next/src/server/route-matcher-providers/dev/dev-pages-api-route-matcher-provider.ts` - DevPagesAPIRouteMatcherProvider実装
- E-16: `packages/next/src/server/route-matcher-providers/dev/helpers/file-reader/file-reader.ts` - FileReaderインターフェース
- E-17: `packages/next/src/server/route-matcher-providers/dev/helpers/file-reader/default-file-reader.ts` - DefaultFileReader実装
- E-18: `packages/next/src/server/route-matcher-providers/dev/helpers/file-reader/batched-file-reader.ts` - BatchedFileReader実装
- E-19: `packages/next/src/server/route-matcher-providers/app-page-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-20: `packages/next/src/server/route-matcher-providers/app-route-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-21: `packages/next/src/server/route-matcher-providers/pages-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-22: `packages/next/src/server/route-matcher-providers/pages-api-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-23: `packages/next/src/server/route-matcher-providers/dev/dev-app-page-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-24: `packages/next/src/server/route-matcher-providers/dev/dev-app-route-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-25: `packages/next/src/server/route-matcher-providers/dev/dev-pages-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-26: `packages/next/src/server/route-matcher-providers/dev/dev-pages-api-route-matcher-provider.test.ts` - 既存テスト（参考）
- E-27: `packages/next/src/server/route-matcher-providers/dev/helpers/file-reader/batched-file-reader.test.ts` - 既存テスト（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CachedRouteMatcherProvider.matchers: loaderがデータを返す場合にtransformが呼ばれること | E-07 (L24-38) | ○ |
| C-02 | CachedRouteMatcherProvider.matchers: 同一データでキャッシュが返却されること | E-07 (L29) | ○ |
| C-03 | CachedRouteMatcherProvider.matchers: データ変更時にtransformが再呼び出しされること | E-07 (L29-33) | ○ |
| C-04 | CachedRouteMatcherProvider.matchers: nullデータで空配列が返却されること | E-07 (L27) | ○ |
| C-05 | CachedRouteMatcherProvider.matchers: 初回呼び出し時のキャッシュスキップ | E-07 (L29) | ○ |
| C-06 | ManifestRouteMatcherProvider.constructor: manifestNameとmanifestLoaderの設定 | E-02 (L11-16) | ○ |
| C-07 | ManifestRouteMatcherProvider.constructor: loadがmanifestLoader.loadを呼ぶこと | E-02 (L13) | ○ |
| C-08 | ManifestRouteMatcherProvider.constructor: compareが===で比較すること | E-02 (L14) | ○ |
| C-09 | ManifestRouteMatcherProvider.constructor: 異なる参照でfalseを返すこと | E-02 (L14) | ○ |
| C-10 | AppPageRouteMatcherProvider.constructor: 初期化の確認 | E-03 (L16-20) | ○ |
| C-11 | AppPageRouteMatcherProvider.transform: appページルートのフィルタリング | E-03 (L26) | ○ |
| C-12 | AppPageRouteMatcherProvider.transform: parallel routesの集約 | E-03 (L30-35) | ○ |
| C-13 | AppPageRouteMatcherProvider.transform: matcher属性の設定 | E-03 (L46-55) | ○ |
| C-14 | AppPageRouteMatcherProvider.transform: 空manifestで空配列 | E-03 (L26) | ○ |
| C-15 | AppPageRouteMatcherProvider.transform: 1件のみのmanifest | E-03 (L26-55) | ○ |
| C-16 | AppRouteRouteMatcherProvider.constructor: 初期化の確認 | E-04 (L15-19) | ○ |
| C-17 | AppRouteRouteMatcherProvider.transform: appルートのフィルタリング | E-04 (L25) | ○ |
| C-18 | AppRouteRouteMatcherProvider.transform: matcher属性の設定 | E-04 (L34-42) | ○ |
| C-19 | AppRouteRouteMatcherProvider.transform: 空manifestで空配列 | E-04 (L25) | ○ |
| C-20 | AppRouteRouteMatcherProvider.transform: ルートなしmanifestで空配列 | E-04 (L25) | ○ |
| C-21 | PagesRouteMatcherProvider.constructor: 初期化の確認 | E-05 (L19-27) | ○ |
| C-22 | PagesRouteMatcherProvider.transform: APIルートの除外 | E-05 (L35) | ○ |
| C-23 | PagesRouteMatcherProvider.transform: BLOCKED_PAGESの除外 | E-05 (L38-46) | ○ |
| C-24 | PagesRouteMatcherProvider.transform: i18nProvider時にPagesLocaleRouteMatcher生成 | E-05 (L50-65) | ○ |
| C-25 | PagesRouteMatcherProvider.transform: i18nProviderなし時にPagesRouteMatcher生成 | E-05 (L66-76) | ○ |
| C-26 | PagesRouteMatcherProvider.transform: matcher属性の設定 | E-05 (L54-75) | ○ |
| C-27 | PagesRouteMatcherProvider.transform: 空manifestで空配列 | E-05 (L34) | ○ |
| C-28 | PagesRouteMatcherProvider.transform: i18n環境でのブロックページ除外 | E-05 (L39-43) | ○ |
| C-29 | PagesAPIRouteMatcherProvider.constructor: 初期化の確認 | E-06 (L19-27) | ○ |
| C-30 | PagesAPIRouteMatcherProvider.transform: APIルートのフィルタリング | E-06 (L33-35) | ○ |
| C-31 | PagesAPIRouteMatcherProvider.transform: i18nProvider時にPagesAPILocaleRouteMatcher生成 | E-06 (L40-55) | ○ |
| C-32 | PagesAPIRouteMatcherProvider.transform: i18nProviderなし時にPagesAPIRouteMatcher生成 | E-06 (L56-66) | ○ |
| C-33 | PagesAPIRouteMatcherProvider.transform: matcher属性の設定 | E-06 (L44-65) | ○ |
| C-34 | PagesAPIRouteMatcherProvider.transform: APIルートなしで空配列 | E-06 (L33) | ○ |
| C-35 | NodeManifestLoader.constructor: distDirの設定 | E-09 (L6) | ○ |
| C-36 | NodeManifestLoader.require: モジュールの正常require | E-09 (L8-14) | ○ |
| C-37 | NodeManifestLoader.require: モジュール不在時にnull返却 | E-09 (L11-12) | ○ |
| C-38 | NodeManifestLoader.load: パス構築の確認 | E-09 (L16-19) | ○ |
| C-39 | NodeManifestLoader.load: ファイル不在時にnull返却 | E-09 (L16-19, L11-12) | ○ |
| C-40 | ServerManifestLoader.constructor: getterの設定 | E-10 (L3) | ○ |
| C-41 | ServerManifestLoader.load: getter委譲の確認 | E-10 (L5-8) | ○ |
| C-42 | ServerManifestLoader.load: null返却の処理 | E-10 (L5-8) | ○ |
| C-43 | FileCacheRouteMatcherProvider.constructor: dir/readerの設定 | E-11 (L11-25) | ○ |
| C-44 | FileCacheRouteMatcherProvider.compare: 同一配列でtrue | E-11 (L14-23) | ○ |
| C-45 | FileCacheRouteMatcherProvider.compare: 長さ不一致でfalse | E-11 (L15) | ○ |
| C-46 | FileCacheRouteMatcherProvider.compare: 内容不一致でfalse | E-11 (L18-19) | ○ |
| C-47 | FileCacheRouteMatcherProvider.compare: 空配列でtrue | E-11 (L14-23) | ○ |
| C-48 | DevAppPageRouteMatcherProvider.constructor: 初期化の確認 | E-12 (L14-30) | ○ |
| C-49 | DevAppPageRouteMatcherProvider.constructor: 正規表現の生成 | E-12 (L26-28) | ○ |
| C-50 | DevAppPageRouteMatcherProvider.transform: pageファイルのフィルタリング | E-12 (L45) | ○ |
| C-51 | DevAppPageRouteMatcherProvider.transform: _セグメントの除外 | E-12 (L50) | ○ |
| C-52 | DevAppPageRouteMatcherProvider.transform: Turbopackでの%5F変換 | E-12 (L56-58) | ○ |
| C-53 | DevAppPageRouteMatcherProvider.transform: parallel routesの集約 | E-12 (L69-70) | ○ |
| C-54 | DevAppPageRouteMatcherProvider.transform: normalizeCatchAllRoutesの呼び出し | E-12 (L73) | ○ |
| C-55 | DevAppPageRouteMatcherProvider.transform: 空ファイルリストで空配列 | E-12 (L43-45) | ○ |
| C-56 | DevAppPageRouteMatcherProvider.transform: キャッシュ不整合時のエラー | E-12 (L84-86) | △ |
| C-57 | DevAppRouteRouteMatcherProvider.constructor: 初期化の確認 | E-13 (L25-36) | ○ |
| C-58 | DevAppRouteRouteMatcherProvider.transform: ルートファイルのフィルタリング | E-13 (L51) | ○ |
| C-59 | DevAppRouteRouteMatcherProvider.transform: 静的メタデータの除外 | E-13 (L44-46) | ○ |
| C-60 | DevAppRouteRouteMatcherProvider.transform: _セグメントの除外 | E-13 (L54) | ○ |
| C-61 | DevAppRouteRouteMatcherProvider.transform: Turbopackでの%5F変換 | E-13 (L60-62) | ○ |
| C-62 | DevAppRouteRouteMatcherProvider.transform: 動的メタデータルートのmatcher生成 | E-13 (L73-121) | ○ |
| C-63 | DevAppRouteRouteMatcherProvider.transform: 通常ルートのmatcher生成 | E-13 (L122-133) | ○ |
| C-64 | DevAppRouteRouteMatcherProvider.transform: 空ファイルリストで空配列 | E-13 (L42) | ○ |
| C-65 | DevPagesRouteMatcherProvider.constructor: 初期化の確認 | E-14 (L16-29) | ○ |
| C-66 | DevPagesRouteMatcherProvider.test: 拡張子マッチング | E-14 (L33) | ○ |
| C-67 | DevPagesRouteMatcherProvider.test: /api/配下の除外 | E-14 (L40) | ○ |
| C-68 | DevPagesRouteMatcherProvider.test: api.{ext}ファイルの除外 | E-14 (L42-48) | ○ |
| C-69 | DevPagesRouteMatcherProvider.test: 無効拡張子の除外 | E-14 (L33) | ○ |
| C-70 | DevPagesRouteMatcherProvider.transform: localeNormalizer時にPagesLocaleRouteMatcher | E-14 (L65-75) | ○ |
| C-71 | DevPagesRouteMatcherProvider.transform: localeNormalizerなし時にPagesRouteMatcher | E-14 (L76-85) | ○ |
| C-72 | DevPagesRouteMatcherProvider.transform: matcher属性の設定 | E-14 (L61-85) | ○ |
| C-73 | DevPagesRouteMatcherProvider.transform: 空ファイルリストで空配列 | E-14 (L57-59) | ○ |
| C-74 | DevPagesAPIRouteMatcherProvider.constructor: 初期化の確認 | E-15 (L16-29) | ○ |
| C-75 | DevPagesAPIRouteMatcherProvider.test: /api/配下のマッチ | E-15 (L40) | ○ |
| C-76 | DevPagesAPIRouteMatcherProvider.test: api.{ext}のマッチ | E-15 (L42-48) | ○ |
| C-77 | DevPagesAPIRouteMatcherProvider.test: 非APIルートの除外 | E-15 (L50) | ○ |
| C-78 | DevPagesAPIRouteMatcherProvider.test: 無効拡張子の除外 | E-15 (L33) | ○ |
| C-79 | DevPagesAPIRouteMatcherProvider.transform: localeNormalizer時にPagesAPILocaleRouteMatcher | E-15 (L65-75) | ○ |
| C-80 | DevPagesAPIRouteMatcherProvider.transform: localeNormalizerなし時にPagesAPIRouteMatcher | E-15 (L76-85) | ○ |
| C-81 | DevPagesAPIRouteMatcherProvider.transform: matcher属性の設定 | E-15 (L61-85) | ○ |
| C-82 | DevPagesAPIRouteMatcherProvider.transform: 空ファイルリストで空配列 | E-15 (L57-59) | ○ |
| C-83 | DefaultFileReader.constructor: optionsの設定 | E-17 (L28-30) | ○ |
| C-84 | DefaultFileReader.read: recursiveReadDirのオプション確認 | E-17 (L39-52) | ○ |
| C-85 | DefaultFileReader.read: ファイル一覧の返却 | E-17 (L39-52) | ○ |
| C-86 | DefaultFileReader.read: 存在しないディレクトリのエラー | E-17 (L39-52) | ○ |
| C-87 | BatchedFileReader.constructor: readerの設定 | E-18 (L19) | ○ |
| C-88 | BatchedFileReader.read: Promiseの返却 | E-18 (L110-124) | ○ |
| C-89 | BatchedFileReader.read: 同一ディレクトリのバッチ処理 | E-18 (L78-107) | ○ |
| C-90 | BatchedFileReader.read: 異なるディレクトリの並行処理 | E-18 (L78-107) | ○ |
| C-91 | BatchedFileReader.read: エラー時のreject | E-18 (L56-60) | ○ |
| C-92 | BatchedFileReader.getOrCreateBatch: バッチの再利用 | E-18 (L34-36) | ○ |
| C-93 | BatchedFileReader.getOrCreateBatch: 新バッチの作成 | E-18 (L38-76) | ○ |
| C-94 | BatchedFileReader.load: 重複排除 | E-18 (L83) | ○ |
| C-95 | BatchedFileReader.load: 空ディレクトリリストの処理 | E-18 (L49) | △ |
| C-96 | BatchedFileReader.load: 全体エラー時の全reject | E-18 (L56-60) | ○ |
| C-97 | BatchedFileReader.load: 個別エラー時の部分reject | E-18 (L65-72) | ○ |
| C-98 | BatchedFileReader.schedule: process.nextTickの動作 | E-18 (L24-31) | △ |

## 4) 不足情報（Unknown / Missing）
- C-56: DevAppPageRouteMatcherProvider.transformの不変条件違反テストは、内部キャッシュMapの不整合状態を外部から再現する方法が明確でない。テスト時にはモックやリフレクションを使う必要がある可能性がある。
  - 候補：内部状態を操作するヘルパー関数 / テスト用のサブクラス作成 / private変数への直接アクセス
- C-95: BatchedFileReader.loadの空ディレクトリリスト処理は、スケジュールコールバック内の早期リターン条件であり、外部から直接テストするには非同期タイミングの制御が必要。
  - 候補：process.nextTickのモック / テスト用の同期的schedule実装
- C-98: BatchedFileReader.scheduleはprivateメソッドであり、直接テストよりもread()を通じた統合的テストが適切。
  - 候補：read()メソッド経由の間接テスト / privateメソッドへのアクセス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの対応が明確で、テストケースの根拠が十分
- 1: 中リスク - C-56のInvariantエラーテストは実装詳細に依存するため、テスト実装時に方針検討が必要
- 0: 低リスク - privateメソッド（test, schedule等）のテストはpublicメソッド経由で間接的にカバー可能

## 6) レビュアーチェックリスト（最小）
- [ ] CachedRouteMatcherProviderのキャッシュロジック（C-01〜C-05）が正しくテストされているか
- [ ] 各Provider（App/Pages/PagesAPI）のtransformメソッドが正常系・異常系・境界値を網羅しているか
- [ ] i18nProvider有無の分岐が全てのPagesプロバイダで網羅されているか
- [ ] DevプロバイダのTurbopackモード固有処理（%5F変換）がテストされているか
- [ ] BatchedFileReaderの重複排除・エラーハンドリングが十分にテストされているか
- [ ] メタデータルートの単一/複数パターン生成（C-62）が正しくテストされているか
- [ ] BLOCKED_PAGESの除外ロジック（C-23, C-28）がテストされているか
