---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：next-src-server-route-modules 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **UT-RTM-076 (AppRouteRouteModule.handle 正常系)**: handleメソッドは多数の依存（workAsyncStorage, workUnitAsyncStorage, actionAsyncStorage等）を持ち、モック構築の妥当性を実際のテスト実装時に確認する必要がある
  2. **UT-RTM-022 (RouteModule.prepare 動的ルートパラメータ)**: prepareメソッドは非常に複雑で多くの外部依存を持つため、テストケースのカバレッジが十分か確認が必要
  3. **UT-RTM-113 (getHandler Bot検出)**: isBot関数の挙動への依存があり、User-Agentパターンの網羅性について要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/route-modules/route-module.ts` - RouteModule基底クラス（コンストラクタ、prepare、getResponseCache、handleResponse、onRequestError、getNextConfigEdge、loadCustomCacheHandlers、getIncrementalCache）
- E-02: `packages/next/src/server/route-modules/checks.ts` - 型チェック関数（isAppRouteRouteModule、isAppPageRouteModule、isPagesRouteModule、isPagesAPIRouteModule）
- E-03: `packages/next/src/server/route-modules/app-route/module.ts` - AppRouteRouteModuleクラス（コンストラクタ、resolve、do、handle、hasNonStaticMethods、trackDynamic、プロキシハンドラ群）
- E-04: `packages/next/src/server/route-modules/app-route/helpers/auto-implement-methods.ts` - autoImplementMethods関数
- E-05: `packages/next/src/server/route-modules/app-route/helpers/clean-url.ts` - cleanURL関数
- E-06: `packages/next/src/server/route-modules/app-route/helpers/get-pathname-from-absolute-path.ts` - getPathnameFromAbsolutePath関数
- E-07: `packages/next/src/server/route-modules/app-route/helpers/is-static-gen-enabled.ts` - isStaticGenEnabled関数
- E-08: `packages/next/src/server/route-modules/app-route/helpers/parsed-url-query-to-params.ts` - parsedUrlQueryToParams関数
- E-09: `packages/next/src/server/route-modules/app-page/helpers/prerender-manifest-matcher.ts` - PrerenderManifestMatcherクラス
- E-10: `packages/next/src/server/route-modules/app-page/helpers/prerender-manifest-matcher.test.ts` - 既存テストファイル（参考）
- E-11: `packages/next/src/server/route-modules/app-page/module.ts` - AppPageRouteModuleクラス（match、normalizeUrl、getVaryHeader、render）
- E-12: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModuleクラス（コンストラクタ、render）
- E-13: `packages/next/src/server/route-modules/pages-api/module.ts` - PagesAPIRouteModuleクラス（コンストラクタ、render）
- E-14: `packages/next/src/server/route-modules/app-page/module.render.ts` - lazyRenderAppPage関数
- E-15: `packages/next/src/server/route-modules/pages/module.render.ts` - lazyRenderPagesPage関数
- E-16: `packages/next/src/server/route-modules/pages/pages-handler.ts` - getHandler関数
- E-17: `packages/next/src/server/route-modules/app-route/shared-modules.ts` - 共有モジュールエクスポート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-RTM-001: RouteModuleコンストラクタが正しく初期化される | E-01 (L132-143) | ○ |
| C-02 | UT-RTM-002/003: isDevがNODE_ENVに基づき設定される | E-01 (L140) | ○ |
| C-03 | UT-RTM-004/005: getResponseCacheがResponseCacheを生成・再利用する | E-01 (L1028-1034) | ○ |
| C-04 | UT-RTM-006: getNextConfigEdgeがEdgeで正しく動作する | E-01 (L515-552) | ○ |
| C-05 | UT-RTM-007: getNextConfigEdgeがEdge以外でエラーを投げる | E-01 (L519-523) | ○ |
| C-06 | UT-RTM-008: nextConfigが取得できない場合のエラー | E-01 (L535-537) | ○ |
| C-07 | UT-RTM-009/010: deploymentIdの取得とエラー処理 | E-01 (L539-549) | ○ |
| C-08 | UT-RTM-011/012/013: onRequestErrorのログ制御 | E-01 (L488-512) | ○ |
| C-09 | UT-RTM-014-017: handleResponseのキャッシュエントリ処理 | E-01 (L1036-1097) | ○ |
| C-10 | UT-RTM-018/019: prepareのエラーケース | E-01 (L554-666, L941-943) | ○ |
| C-11 | UT-RTM-020: i18nロケール検出 | E-01 (L681-695) | ○ |
| C-12 | UT-RTM-021: _next/dataパス正規化 | E-01 (L669-672) | ○ |
| C-13 | UT-RTM-022: 動的ルートパラメータ解析 | E-01 (L758-901) | ○ |
| C-14 | UT-RTM-023: /index正規化 | E-01 (L964-966) | ○ |
| C-15 | UT-RTM-024: basePath処理 | E-01 (L657-659) | ○ |
| C-16 | UT-RTM-025-032: checks.tsの型チェック関数群 | E-02 (L10-32) | ○ |
| C-17 | UT-RTM-033-040: autoImplementMethodsの動作 | E-04 (L11-82) | ○ |
| C-18 | UT-RTM-041-046: cleanURLの動作 | E-05 (L8-14) | ○ |
| C-19 | UT-RTM-047-050: getPathnameFromAbsolutePathの動作 | E-06 (L7-19) | ○ |
| C-20 | UT-RTM-051-059: isStaticGenEnabledの条件分岐 | E-07 (L10-20) | ○ |
| C-21 | UT-RTM-060-063: parsedUrlQueryToParamsの変換 | E-08 (L9-20) | ○ |
| C-22 | UT-RTM-064-069: PrerenderManifestMatcherの初期化とマッチング | E-09 (L38-80), E-10 | ○ |
| C-23 | UT-RTM-070-073: AppRouteRouteModuleコンストラクタの制約チェック | E-03 (L219-287) | ○ |
| C-24 | UT-RTM-074/075: resolveメソッドのメソッド解決 | E-03 (L295-301) | ○ |
| C-25 | UT-RTM-076: handleメソッドの正常系 | E-03 (L694-849) | △ |
| C-26 | UT-RTM-077/078: handleメソッドのミドルウェア制約 | E-03 (L835-844) | ○ |
| C-27 | UT-RTM-079: Response型でない返却値の検出 | E-03 (L830-833) | ○ |
| C-28 | UT-RTM-080-083: hasNonStaticMethodsの判定 | E-03 (L861-873) | ○ |
| C-29 | UT-RTM-084-088: trackDynamicの各ストアタイプ処理 | E-03 (L1183-1252) | ○ |
| C-30 | UT-RTM-089: WrappedNextRouterErrorの初期化 | E-03 (L92-97) | ○ |
| C-31 | UT-RTM-090/091: AppPageRouteModule.matchとキャッシュ | E-11 (L89-105) | ○ |
| C-32 | UT-RTM-092-094: AppPageRouteModule.normalizeUrlの分岐 | E-11 (L112-145) | ○ |
| C-33 | UT-RTM-095-097: getVaryHeaderのインターセプション判定 | E-11 (L164-193) | ○ |
| C-34 | UT-RTM-098: AppPageRouteModule.render | E-11 (L147-162) | ○ |
| C-35 | UT-RTM-099/100: PagesRouteModuleの初期化とレンダリング | E-12 (L124-155) | ○ |
| C-36 | UT-RTM-101-103: PagesAPIRouteModuleの初期化・検証・レンダリング | E-13 (L109-161) | ○ |
| C-37 | UT-RTM-104/105: lazyRenderAppPageのミニマルモード制約 | E-14 (L3-13) | ○ |
| C-38 | UT-RTM-106/107: lazyRenderPagesPageのミニマルモード制約 | E-15 (L3-13) | ○ |
| C-39 | UT-RTM-108-120: getHandlerの各処理分岐 | E-16 (L52-782) | ○ |
| C-40 | UT-RTM-076: handleの複雑な依存関係のモック妥当性 | **根拠なし** | △ |
| C-41 | UT-RTM-113: isBot関数のUser-Agentパターン網羅性 | **根拠なし** | △ |
| C-42 | UT-RTM-022: prepareメソッドの全分岐カバレッジ | **根拠なし** | △ |
| C-43 | UT-RTM-111: キャッシュキー生成ロジックの全条件網羅 | **根拠なし** | △ |
| C-44 | UT-RTM-116: リダイレクト処理のbasePath考慮 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **handleメソッドの統合テスト的な複雑さ**: AppRouteRouteModule.handleは、workAsyncStorage, workUnitAsyncStorage, actionAsyncStorageの3つのAsyncLocalStorageを入れ子で使用しており、これらのモック構築の正確な方法はソースコードだけでは完全に検証できない
  - 候補：既存のテストコード / Next.jsのテストユーティリティ / AsyncLocalStorageのモック手法
- **isBot関数の判定パターン**: user-agent文字列の判定ロジックは外部モジュール（is-bot.ts）に依存しており、本モジュール内では直接確認できない
  - 候補：`packages/next/src/shared/lib/router/utils/is-bot.ts`
- **prepareメソッドの完全なテストカバレッジ**: prepareは約470行に及ぶ複雑なメソッドで、i18n、動的ルート、リライト、basePath等の多数の条件分岐を持つ。全分岐を120テストケースでカバーすることは困難
  - 候補：追加テストケースの検討 / 統合テストとの役割分担
- **pages-handler.tsのキャッシュキー生成**: locale有無、srcPage種別（404/500/_error）の組み合わせが多く、全パターンの網羅が必要
  - 候補：条件分岐のデシジョンテーブルの作成
- **リダイレクト処理のbasePath考慮**: pages-handler.tsのhandleRedirect内のbasePath処理の全条件を検証するための追加テストケースが必要
  - 候補：basePath有無 x redirect.basePath有無 の組み合わせテスト

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: RouteModule.prepareメソッドは非常に長く複雑であり、テストケースが一部の主要パスのみをカバーしている可能性がある。統合テストとの併用を推奨
- **リスク1 (中)**: AppRouteRouteModule.doメソッド内のprerenderロジック（prospective render + final render）は複雑な非同期制御フローを持ち、単体テストでの検証に限界がある
- **リスク0 (低)**: vendoredディレクトリ内のファイルは全て再エクスポートのみであり、テスト対象としての優先度は低い（テストケース一覧から除外済み）

## 6) レビュアーチェックリスト（最小）
- [ ] checks.tsの4つの型チェック関数について、全RouteKindとの組み合わせが網羅されているか
- [ ] autoImplementMethodsのAllowヘッダ生成ロジックが正しくソートされているか
- [ ] isStaticGenEnabledの境界値（revalidate=0, revalidate=1）が正しくテストされているか
- [ ] PrerenderManifestMatcherの既存テスト(E-10)との重複・差異が適切か
- [ ] getHandlerの各Cache-Control設定パターンが網羅されているか
- [ ] prepareメソッドのi18n関連テストケースが十分か（特にdomainLocale検出）
- [ ] trackDynamicの全workUnitStoreタイプ（cache, private-cache, unstable-cache, prerender, prerender-client, prerender-runtime, prerender-ppr, prerender-legacy, request）が網羅されているか
