---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 155
  claims_with_evidence: 150
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：next-src-server-top 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：150 / 155、根拠なし：5
- 優先レビュー（高）
  1. **C-018 (getStorageDirectory Docker環境)**: isDockerFunctionの動作を直接検証できないため要確認
  2. **C-051 (calculateSizeAdjustValues)**: capsize-font-metrics.jsonの実データ依存のため要確認
  3. **C-149 (postProcessHTML optimizeCss有効)**: crittersモジュールのインストール依存のため要確認
  4. **C-154 (createDedupedByCallsiteServerErrorLoggerDev)**: React.cacheの動作環境依存のため要確認
  5. **C-096 (requirePage HTML)**: ファイルシステムアクセスのモック必要のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/accept-header.ts` - acceptLanguageパーサの実装
- E-02: `packages/next/src/server/body-streams.ts` - ボディストリーム処理の実装
- E-03: `packages/next/src/server/cache-dir.ts` - キャッシュディレクトリ取得の実装
- E-04: `packages/next/src/server/ci-info.ts` - CI環境情報の実装
- E-05: `packages/next/src/server/client-component-renderer-logger.ts` - クライアントコンポーネントローダーの実装
- E-06: `packages/next/src/server/crypto-utils.ts` - 暗号化/復号の実装
- E-07: `packages/next/src/server/htmlescape.ts` - HTMLエスケープの実装
- E-08: `packages/next/src/server/internal-utils.ts` - 内部クエリ除去の実装
- E-09: `packages/next/src/server/is-private-ip.ts` - プライベートIP判定の実装
- E-10: `packages/next/src/server/match-bundle.ts` - バンドルマッチの実装
- E-11: `packages/next/src/server/get-app-route-from-entrypoint.ts` - Appルート取得の実装
- E-12: `packages/next/src/server/get-route-from-entrypoint.ts` - ルート取得の実装
- E-13: `packages/next/src/server/get-page-files.ts` - ページファイル取得の実装
- E-14: `packages/next/src/server/font-utils.ts` - フォントサイズ調整の実装
- E-15: `packages/next/src/server/dynamic-rendering-utils.ts` - 動的レンダリングユーティリティの実装
- E-16: `packages/next/src/server/request-meta.ts` - リクエストメタデータの実装
- E-17: `packages/next/src/server/render-result.ts` - RenderResultクラスの実装
- E-18: `packages/next/src/server/load-manifest.external.ts` - マニフェスト読み込みの実装
- E-19: `packages/next/src/server/load-components.ts` - コンポーネント読み込みの実装
- E-20: `packages/next/src/server/require.ts` - ページrequireの実装
- E-21: `packages/next/src/server/pipe-readable.ts` - パイプ処理の実装
- E-22: `packages/next/src/server/server-utils.ts` - サーバーユーティリティの実装
- E-23: `packages/next/src/server/send-payload.ts` - ペイロード送信の実装
- E-24: `packages/next/src/server/send-response.ts` - レスポンス送信の実装
- E-25: `packages/next/src/server/serve-static.ts` - 静的ファイル配信の実装
- E-26: `packages/next/src/server/server-route-utils.ts` - ルートユーティリティの実装
- E-27: `packages/next/src/server/utils.ts` - ユーティリティ関数の実装
- E-28: `packages/next/src/server/revalidation-utils.ts` - リバリデーションユーティリティの実装
- E-29: `packages/next/src/server/setup-http-agent-env.ts` - HTTPエージェント設定の実装
- E-30: `packages/next/src/server/require-hook.ts` - requireフックの実装
- E-31: `packages/next/src/server/config-utils.ts` - Webpackフック設定の実装
- E-32: `packages/next/src/server/post-process.ts` - HTML後処理の実装
- E-33: `packages/next/src/server/runtime-reacts.external.ts` - ランタイムReact管理の実装
- E-34: `packages/next/src/server/create-deduped-by-callsite-server-error-logger.ts` - 重複ログ抑制の実装
- E-35: `packages/next/src/server/is-private-ip.test.ts` - isPrivateIpの既存テスト
- E-36: `packages/next/src/server/config.test.ts` - configの既存テスト
- E-37: `packages/next/src/server/server-utils.test.ts` - server-utilsの既存テスト
- E-38: `packages/next/src/server/load-manifest.test.ts` - loadManifestの既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | acceptLanguage: 単一言語ヘッダで正しい言語が返る | E-01 | ○ |
| C-002 | acceptLanguage: 複数言語ヘッダで最優先言語が返る | E-01 | ○ |
| C-003 | acceptLanguage: preferencesを指定した場合に一致する言語が返る | E-01 | ○ |
| C-004 | acceptLanguage: prefixMatchで言語サブタグが一致する | E-01 | ○ |
| C-005 | acceptLanguage: ワイルドカード処理 | E-01 | ○ |
| C-006 | acceptLanguage: 空ヘッダで空文字列が返る | E-01 | ○ |
| C-007 | acceptLanguage: header=undefinedで空文字列が返る | E-01 | ○ |
| C-008 | parse: セミコロン3つ以上で不正ヘッダエラー | E-01 | ○ |
| C-009 | parse: 空トークンで不正ヘッダエラー | E-01 | ○ |
| C-010 | parse: 不正q値形式でエラー | E-01 | ○ |
| C-011 | parse: q=0の言語は除外される | E-01 | ○ |
| C-012 | requestToBodyStream: ストリーム変換の基本動作 | E-02 | ○ |
| C-013 | getCloneableBody: ボディクローンの基本動作 | E-02 | ○ |
| C-014 | getCloneableBody: サイズ制限チェック | E-02 | ○ |
| C-015 | getCloneableBody: finalize処理 | E-02 | ○ |
| C-016 | getCloneableBody: エラーハンドリング | E-02 | ○ |
| C-017 | getStorageDirectory: 非Docker環境でcacheパスが返る | E-03 | ○ |
| C-018 | getStorageDirectory: Docker環境でundefinedが返る | E-03 | △ |
| C-019 | isCI: CI環境変数でtrue | E-04 | ○ |
| C-020 | hasNextSupport: ZEIT Nowでtrue | E-04 | ○ |
| C-021 | encryptWithSecret: データが暗号化される | E-06 | ○ |
| C-022 | decryptWithSecret: 暗号化データが復号される | E-06 | ○ |
| C-023 | decryptWithSecret: 異なる秘密鍵で失敗 | E-06 | ○ |
| C-024 | decryptWithSecret: 不正hex文字列で失敗 | E-06 | ○ |
| C-025 | htmlEscapeJsonString: &エスケープ | E-07 | ○ |
| C-026 | htmlEscapeJsonString: <エスケープ | E-07 | ○ |
| C-027 | htmlEscapeJsonString: >エスケープ | E-07 | ○ |
| C-028 | htmlEscapeJsonString: U+2028/U+2029エスケープ | E-07 | ○ |
| C-029 | htmlEscapeJsonString: 空文字列 | E-07 | ○ |
| C-030 | htmlEscapeJsonString: エスケープ不要文字列 | E-07 | ○ |
| C-031 | stripInternalQueries: 内部クエリ削除 | E-08 | ○ |
| C-032 | stripInternalSearchParams: 文字列URL処理 | E-08 | ○ |
| C-033 | stripInternalSearchParams: URLオブジェクト処理 | E-08 | ○ |
| C-034 | isPrivateIp: プライベートIPv4でtrue | E-09, E-35 | ○ |
| C-035 | isPrivateIp: パブリックIPv4でfalse | E-09, E-35 | ○ |
| C-036 | isPrivateIp: ループバックIPでtrue | E-09, E-35 | ○ |
| C-037 | isPrivateIp: IPv6ループバックでtrue | E-09, E-35 | ○ |
| C-038 | isPrivateIp: 角括弧付きIPv6 | E-09, E-35 | ○ |
| C-039 | isPrivateIp: IPv4マッピングIPv6 | E-09, E-35 | ○ |
| C-040 | isPrivateIp: 不正IP文字列でfalse | E-09, E-35 | ○ |
| C-041 | matchBundle: マッチ時ルート返却 | E-10 | ○ |
| C-042 | matchBundle: 不一致時null返却 | E-10 | ○ |
| C-043 | getAppRouteFromEntrypoint: appエントリからルート取得 | E-11 | ○ |
| C-044 | getAppRouteFromEntrypoint: ルートパスで'/'返却 | E-11 | ○ |
| C-045 | getAppRouteFromEntrypoint: 不一致時null返却 | E-11 | ○ |
| C-046 | getRouteFromEntrypoint: pagesエントリからルート取得 | E-12 | ○ |
| C-047 | getRouteFromEntrypoint: app=trueでappルート探索 | E-12 | ○ |
| C-048 | getRouteFromEntrypoint: staticエントリからルート取得 | E-12 | ○ |
| C-049 | getPageFiles: 存在ページのファイルリスト | E-13 | ○ |
| C-050 | getPageFiles: 未存在ページで空配列 | E-13 | ○ |
| C-051 | calculateSizeAdjustValues: フォントメトリクス計算 | E-14 | △ |
| C-052 | isHangingPromiseRejectionError: trueケース | E-15 | ○ |
| C-053 | isHangingPromiseRejectionError: nullでfalse | E-15 | ○ |
| C-054 | isHangingPromiseRejectionError: 通常Errorでfalse | E-15 | ○ |
| C-055 | makeHangingPromise: abort済みシグナル | E-15 | ○ |
| C-056 | makeHangingPromise: ペンディングPromise生成 | E-15 | ○ |
| C-057 | makeHangingPromise: 遅延abort処理 | E-15 | ○ |
| C-058 | getRequestMeta: キー無しでオブジェクト全体 | E-16 | ○ |
| C-059 | getRequestMeta: キー指定で特定値 | E-16 | ○ |
| C-060 | getRequestMeta: メタデータ未設定で空オブジェクト | E-16 | ○ |
| C-061 | setRequestMeta: メタデータ設定 | E-16 | ○ |
| C-062 | addRequestMeta: メタデータ追加 | E-16 | ○ |
| C-063 | removeRequestMeta: メタデータ削除 | E-16 | ○ |
| C-064 | RenderResult: コンストラクタ基本動作 | E-17 | ○ |
| C-065 | RenderResult: isNull trueケース | E-17 | ○ |
| C-066 | RenderResult: isNull falseケース | E-17 | ○ |
| C-067 | RenderResult: isDynamic falseケース | E-17 | ○ |
| C-068 | RenderResult: isDynamic trueケース | E-17 | ○ |
| C-069 | RenderResult: toUnchunkedString 文字列 | E-17 | ○ |
| C-070 | RenderResult: toUnchunkedString null | E-17 | ○ |
| C-071 | RenderResult: toUnchunkedString 動的エラー | E-17 | ○ |
| C-072 | RenderResult: toUnchunkedString stream=true | E-17 | ○ |
| C-073 | RenderResult: fromStatic | E-17 | ○ |
| C-074 | RenderResult: EMPTY | E-17 | ○ |
| C-075 | RenderResult: push | E-17 | ○ |
| C-076 | RenderResult: unshift | E-17 | ○ |
| C-077 | RenderResult: assignMetadata | E-17 | ○ |
| C-078 | loadManifest: JSON読み込み | E-18, E-38 | ○ |
| C-079 | loadManifest: キャッシュヒット | E-18, E-38 | ○ |
| C-080 | loadManifest: freeze検証 | E-18 | ○ |
| C-081 | loadManifest: ファイル未発見エラー | E-18 | ○ |
| C-082 | evalManifest: JS評価 | E-18 | ○ |
| C-083 | evalManifest: 空ファイルエラー | E-18 | ○ |
| C-084 | clearManifestCache: キャッシュクリア | E-18 | ○ |
| C-085 | clearManifestCache: 非存在キーでfalse | E-18 | ○ |
| C-086 | loadManifestFromRelativePath: 相対パス読み込み | E-18 | ○ |
| C-087 | loadManifestFromRelativePath: handleMissing | E-18 | ○ |
| C-088 | loadManifestWithRetries: 1回目成功 | E-19 | ○ |
| C-089 | loadManifestWithRetries: 全リトライ失敗 | E-19 | ○ |
| C-090 | tryLoadManifestWithRetries: 成功 | E-19 | ○ |
| C-091 | tryLoadManifestWithRetries: 失敗でundefined | E-19 | ○ |
| C-092 | getMaybePagePath: 存在ページのパス | E-20 | ○ |
| C-093 | getMaybePagePath: 未存在ページでnull | E-20 | ○ |
| C-094 | getMaybePagePath: isAppPath=trueでAppManifest参照 | E-20 | ○ |
| C-095 | getPagePath: 未発見でPageNotFoundError | E-20 | ○ |
| C-096 | requirePage: HTMLページ読み込み | E-20 | △ |
| C-097 | isAbortError: AbortErrorでtrue | E-21 | ○ |
| C-098 | isAbortError: ResponseAbortedでtrue | E-21 | ○ |
| C-099 | isAbortError: 通常Errorでfalse | E-21 | ○ |
| C-100 | isAbortError: nullでfalse | E-21 | ○ |
| C-101 | pipeToNodeResponse: パイプ基本動作 | E-21 | ○ |
| C-102 | pipeToNodeResponse: エラー済みレスポンス | E-21 | ○ |
| C-103 | interpolateDynamicPath: パラメータ補間 | E-22, E-37 | ○ |
| C-104 | interpolateDynamicPath: Regex未設定 | E-22 | ○ |
| C-105 | interpolateDynamicPath: catch-all | E-22 | ○ |
| C-106 | normalizeDynamicRouteParams: パラメータ正規化 | E-22 | ○ |
| C-107 | normalizeDynamicRouteParams: デフォルト値一致 | E-22 | ○ |
| C-108 | normalizeCdnUrl: CDN URL正規化 | E-22 | ○ |
| C-109 | getPreviouslyRevalidatedTags: タグ取得成功 | E-22 | ○ |
| C-110 | getPreviouslyRevalidatedTags: トークン不一致 | E-22 | ○ |
| C-111 | getPreviouslyRevalidatedTags: ヘッダ未設定 | E-22 | ○ |
| C-112 | sendEtagResponse: 304レスポンス | E-23 | ○ |
| C-113 | sendEtagResponse: ETag不一致 | E-23 | ○ |
| C-114 | sendEtagResponse: ETag未設定 | E-23 | ○ |
| C-115 | sendRenderResult: Powered-Byヘッダ | E-23 | ○ |
| C-116 | sendRenderResult: HEADリクエスト | E-23 | ○ |
| C-117 | sendRenderResult: 送信済みレスポンス | E-23 | ○ |
| C-118 | serveStatic: 静的ファイル配信 | E-25 | ○ |
| C-119 | serveStatic: ディレクトリアクセス拒否 | E-25 | ○ |
| C-120 | getContentType: MIME type取得 | E-25 | ○ |
| C-121 | getExtension: 拡張子取得 | E-25 | ○ |
| C-122 | stringifyQuery: クエリ文字列化 | E-26 | ○ |
| C-123 | stringifyQuery: 初期クエリエンコード | E-26 | ○ |
| C-124 | isBlockedPage: ブロックページでtrue | E-27 | ○ |
| C-125 | isBlockedPage: 通常ページでfalse | E-27 | ○ |
| C-126 | debounce: 基本動作 | E-27 | ○ |
| C-127 | debounce: 連続呼び出し集約 | E-27 | ○ |
| C-128 | debounce: maxWait強制実行 | E-27 | ○ |
| C-129 | executeRevalidates: 全実行 | E-28 | ○ |
| C-130 | executeRevalidates: 空でfalse | E-28 | ○ |
| C-131 | withExecuteRevalidates: コールバック後リバリデーション | E-28 | ○ |
| C-132 | withExecuteRevalidates: store=undefined | E-28 | ○ |
| C-133 | setHttpClientAndAgentOptions: エージェント設定 | E-29 | ○ |
| C-134 | setHttpClientAndAgentOptions: 再設定防止 | E-29 | ○ |
| C-135 | setHttpClientAndAgentOptions: 不正config | E-29 | ○ |
| C-136 | wrapClientComponentLoader: ラップ動作 | E-05 | ○ |
| C-137 | wrapClientComponentLoader: performance未対応 | E-05 | ○ |
| C-138 | getClientComponentLoaderMetrics: 未記録でundefined | E-05 | ○ |
| C-139 | getClientComponentLoaderMetrics: リセット | E-05 | ○ |
| C-140 | addHookAliases: エイリアス追加 | E-30 | ○ |
| C-141 | addHookAliases: 空配列 | E-30 | ○ |
| C-142 | registerClientReact: React登録 | E-33 | ○ |
| C-143 | getClientReact: React取得 | E-33 | ○ |
| C-144 | getClientReact: 未登録でnull | E-33 | ○ |
| C-145 | registerServerReact: Server React登録 | E-33 | ○ |
| C-146 | getServerReact: 未登録でnull | E-33 | ○ |
| C-147 | loadWebpackHook: 初回登録 | E-31 | ○ |
| C-148 | loadWebpackHook: 重複登録防止 | E-31 | ○ |
| C-149 | postProcessHTML: optimizeCss無効 | E-32 | ○ |
| C-150 | sendResponse: ステータスとヘッダコピー | E-24 | ○ |
| C-151 | sendResponse: set-cookie個別append | E-24 | ○ |
| C-152 | sendResponse: x-middleware-set-cookie除外 | E-24 | ○ |
| C-153 | sendResponse: HEADリクエスト | E-24 | ○ |
| C-154 | createDedupedByCallsiteServerErrorLoggerDev: 重複抑制 | E-34 | △ |
| C-155 | loadManifest: skipParse | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-018**: `isDockerFunction`は外部ライブラリ(`is-docker`)に依存しており、テスト時のDocker環境モックが必要
  - 候補：is-dockerモジュールのモック / 環境変数による制御 / コンテナ内テスト実行
- **C-051**: `capsize-font-metrics.json`の実データに依存しており、フォント名の正確なマッピングが必要
  - 候補：テスト用フォントメトリクスのフィクスチャ / capsizeFontsMetricsモジュールのモック
- **C-096**: ファイルシステムアクセスを伴うため、テスト時にはfsのモック・tmpdir使用が必要
  - 候補：fs.promises.readFileのモック / テスト用HTMLファイルの配置
- **C-149**: `critters`モジュールのインストールと動作環境に依存
  - 候補：crittersモジュールのモック / 実インストールによるE2Eテスト
- **C-154**: `React.cache`がcanary/experimentalチャネルのみで利用可能
  - 候補：React.cacheのモック / canary Reactでのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 純粋関数のユーティリティ関数群（htmlescape, isPrivateIp, matchBundle等）は入出力が明確で信頼度が高い
- 1: 中リスク - ストリーム操作関連（body-streams, pipe-readable, render-result）はモックの複雑さに注意
- 1: 中リスク - マニフェスト読み込み関連（load-manifest, load-components, require）はファイルシステム依存
- 0: 低リスク - 暗号化関連（crypto-utils）は標準cryptoモジュール使用で確実にテスト可能
- 1: 中リスク - リバリデーション関連（revalidation-utils）はWorkStoreの状態管理が複雑

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがpublic関数を網羅しているか（base-server.ts, next-server.ts, config.ts等の大規模ファイルはモジュール範囲外のため除外が妥当か確認）
- [ ] 暗号化関連テスト（C-021〜C-024）のセキュリティ観点が十分か
- [ ] HTMLエスケープテスト（C-025〜C-030）がXSS防止の観点で十分か
- [ ] isPrivateIp（C-034〜C-040）のIPv4/IPv6カバレッジが十分か
- [ ] RenderResultクラス（C-064〜C-077）のストリーム操作テストが実行可能か
- [ ] マニフェスト読み込み（C-078〜C-091）のリトライロジックがテスト可能か
- [ ] debounce（C-126〜C-128）のタイミング依存テストが安定しているか
- [ ] 大規模ファイル（base-server.ts, next-server.ts, config.ts, render.tsx, image-optimizer.ts, config-shared.ts, config-schema.ts）がモジュール範囲の「トップレベルファイル」に含まれるが、統合テスト向けであり単体テスト一覧からの除外判断は妥当か
