---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 166
  claims_with_evidence: 160
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：next-src-server-typescript 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：160 / 166、根拠なし：6
- 優先レビュー（高）
  1. **C-077 (config.getQuickInfoAtPosition 関数値ホバー)**: 関数値イニシャライザ内のホバー動作は複雑な条件分岐に依存し、実行時の挙動確認が必要
  2. **C-091 (config.getSemanticDiagnostics 非リテラル値)**: 非リテラル値の判定ロジックは多数の条件分岐のelse節に依存し、完全な検証が困難
  3. **C-134/C-135 (isFunctionReturningPromise Union型)**: Union型のPromise判定はTypeCheckerの動作に強く依存するため、実行時テストでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/typescript/utils.ts` - ユーティリティ関数群（init, getTs, getInfo, getTypeChecker, getSource, removeStringQuotes, isPositionInsideNode, isDefaultFunctionExport, isInsideApp, isAppEntryFile, isPageFile, getEntryInfo）
- E-02: `packages/next/src/server/typescript/constant.ts` - 定数定義（NEXT_TS_ERRORS, ALLOWED_EXPORTS, DISALLOWED_SERVER_REACT_APIS, DISALLOWED_SERVER_REACT_DOM_APIS, ALLOWED_PAGE_PROPS, ALLOWED_LAYOUT_PROPS）
- E-03: `packages/next/src/server/typescript/rules/server.ts` - サーバーレイヤールール（filterCompletionsAtPosition, hasDisallowedReactAPIDefinition, getSemanticDiagnosticsForImportDeclaration）
- E-04: `packages/next/src/server/typescript/rules/entry.ts` - エントリルール（getCompletionsAtPosition, getSemanticDiagnostics）
- E-05: `packages/next/src/server/typescript/rules/config.ts` - 設定ルール（addCompletionsAtPosition, getQuickInfoAtPosition, getCompletionEntryDetails, getSemanticDiagnosticsForExportVariableStatement）
- E-06: `packages/next/src/server/typescript/rules/client-boundary.ts` - クライアント境界ルール（getSemanticDiagnosticsForExportVariableStatement, getSemanticDiagnosticsForFunctionExport）
- E-07: `packages/next/src/server/typescript/rules/metadata.ts` - メタデータルール（client.getSemanticDiagnosticsForExportVariableStatement, client.getSemanticDiagnosticsForExportDeclaration, server.getSemanticDiagnosticsForExportVariableStatement, server.getSemanticDiagnosticsForExportDeclaration, hasType）
- E-08: `packages/next/src/server/typescript/rules/error.ts` - エラーエントリルール（getSemanticDiagnostics）
- E-09: `packages/next/src/server/typescript/rules/server-boundary.ts` - サーバー境界ルール（isPromiseType, isFunctionReturningPromise, getSemanticDiagnosticsForExportDeclaration, getSemanticDiagnosticsForExportVariableStatement, getSemanticDiagnosticsForFunctionExport）
- E-10: `packages/next/src/server/typescript/index.ts` - プラグインメインエントリ（createTSPlugin, proxy.getCompletionsAtPosition, proxy.getCompletionEntryDetails, proxy.getQuickInfoAtPosition, proxy.getSemanticDiagnostics）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | init関数がts・info・appDirRegExpを正しく初期化する | E-01 (utils.ts L15-27) | ○ |
| C-002 | srcディレクトリ含むプロジェクトパスでappDirRegExpが正しく生成される | E-01 (utils.ts L22-24, 正規表現パターン) | ○ |
| C-003 | ログメッセージが[next]プレフィックス付きで出力される | E-01 (utils.ts L10-12) | ○ |
| C-004 | 初期化済みのTypeScriptモジュールが返却される | E-01 (utils.ts L29-31) | ○ |
| C-005 | 初期化済みのPluginCreateInfoが返却される | E-01 (utils.ts L33-35) | ○ |
| C-006 | プログラムとTypeCheckerが正常に取得される | E-01 (utils.ts L37-49) | ○ |
| C-007 | プログラムが取得できない場合undefinedが返る | E-01 (utils.ts L39-41) | ○ |
| C-008 | TypeCheckerが取得できない場合undefinedが返る | E-01 (utils.ts L44-46) | ○ |
| C-009 | 指定ファイル名のSourceFileが取得される | E-01 (utils.ts L51-65) | ○ |
| C-010 | getSourceでプログラムが取得できない場合undefinedが返る | E-01 (utils.ts L53-55) | ○ |
| C-011 | ソースファイルが存在しない場合undefinedが返る | E-01 (utils.ts L59-61) | ○ |
| C-012 | シングルクォートが除去される | E-01 (utils.ts L67-69) | ○ |
| C-013 | ダブルクォートが除去される | E-01 (utils.ts L67-69) | ○ |
| C-014 | バッククォートが除去される | E-01 (utils.ts L67-69) | ○ |
| C-015 | 空文字列が渡された場合に空文字列が返る | E-01 (utils.ts L67-69, 正規表現動作) | ○ |
| C-016 | 引用符を含まない文字列はそのまま返る | E-01 (utils.ts L67-69) | ○ |
| C-017 | 位置がノード範囲内の場合trueが返る | E-01 (utils.ts L71-74) | ○ |
| C-018 | 位置がノード範囲外の場合falseが返る | E-01 (utils.ts L71-74) | ○ |
| C-019 | 位置がノード開始位置と同一の場合trueが返る | E-01 (utils.ts L73, start <= position) | ○ |
| C-020 | 位置がノード終了位置と同一の場合trueが返る | E-01 (utils.ts L73, position <= node.getFullWidth() + start) | ○ |
| C-021 | export default functionの場合trueが返る | E-01 (utils.ts L76-99) | ○ |
| C-022 | export function(defaultなし)の場合falseが返る | E-01 (utils.ts L94-96) | ○ |
| C-023 | FunctionDeclarationでないノードの場合falseが返る | E-01 (utils.ts L79, 98) | ○ |
| C-024 | 修飾子がないFunctionDeclarationの場合falseが返る | E-01 (utils.ts L83) | ○ |
| C-025 | appディレクトリ内のファイルパスの場合trueが返る | E-01 (utils.ts L101-103) | ○ |
| C-026 | appディレクトリ外のファイルパスの場合falseが返る | E-01 (utils.ts L101-103) | ○ |
| C-027 | src/appディレクトリ内のファイルパスの場合trueが返る | E-01 (utils.ts L22-24, (/src)?/app) | ○ |
| C-028 | page.tsxファイルの場合isAppEntryFileがtrueが返る | E-01 (utils.ts L104-109) | ○ |
| C-029 | layout.tsxファイルの場合isAppEntryFileがtrueが返る | E-01 (utils.ts L104-109) | ○ |
| C-030 | page.jsファイルの場合trueが返る | E-01 (utils.ts L107, 正規表現にjsが含まれる) | ○ |
| C-031 | page.jsxファイルの場合trueが返る | E-01 (utils.ts L107, 正規表現にjsxが含まれる) | ○ |
| C-032 | page.mjsファイルの場合trueが返る | E-01 (utils.ts L107, 正規表現にmjsが含まれる) | ○ |
| C-033 | appディレクトリ外のpage.tsxの場合falseが返る | E-01 (utils.ts L106, appDirRegExp.test) | ○ |
| C-034 | 非エントリファイルの場合falseが返る | E-01 (utils.ts L107, basename正規表現) | ○ |
| C-035 | isPageFileでpage.tsxの場合trueが返る | E-01 (utils.ts L110-115) | ○ |
| C-036 | isPageFileでlayout.tsxの場合falseが返る | E-01 (utils.ts L113, page正規表現のみ) | ○ |
| C-037 | use clientディレクティブでclient=trueが返る | E-01 (utils.ts L118-181, L133-135) | ○ |
| C-038 | use serverディレクティブでserver=trueが返る | E-01 (utils.ts L147-149) | ○ |
| C-039 | ディレクティブなしでclient=false, server=falseが返る | E-01 (utils.ts L177) | ○ |
| C-040 | use clientとuse serverの両方がある場合エラーがスローされる | E-01 (utils.ts L163-171) | ○ |
| C-041 | use clientがファイル先頭でない場合にthrowOnInvalidDirective=trueでエラー | E-01 (utils.ts L136-146) | ○ |
| C-042 | use clientがファイル先頭でない場合にthrowOnInvalidDirective=falseでエラーなし | E-01 (utils.ts L134, isDirective=falseの場合のelseパス) | ○ |
| C-043 | ソースファイルが取得できない場合にclient=false, server=false | E-01 (utils.ts L180) | ○ |
| C-044 | NEXT_TS_ERRORSが全エラーコードを含む | E-02 (constant.ts L1-13) | ○ |
| C-045 | ALLOWED_EXPORTSが6項目を含む | E-02 (constant.ts L15-22) | ○ |
| C-046 | DISALLOWED_SERVER_REACT_APISが禁止APIを全て含む | E-02 (constant.ts L26-45) | ○ |
| C-047 | DISALLOWED_SERVER_REACT_DOM_APISが禁止APIを含む | E-02 (constant.ts L47-50) | ○ |
| C-048 | ALLOWED_PAGE_PROPSがparams, searchParamsを含む | E-02 (constant.ts L52) | ○ |
| C-049 | ALLOWED_LAYOUT_PROPSがparams, childrenを含む | E-02 (constant.ts L53) | ○ |
| C-050 | 禁止ReactAPIのCompletionEntryがフィルタされる | E-03 (server.ts L11-22) | ○ |
| C-051 | source='react'でない同名APIはフィルタされない | E-03 (server.ts L16-17, source条件) | ○ |
| C-052 | 空の配列が渡された場合に空配列が返る | E-03 (server.ts L12, filter動作) | ○ |
| C-053 | 禁止APIのdefinitionが含まれる場合trueが返る | E-03 (server.ts L25-33) | ○ |
| C-054 | 禁止APIでないdefinitionの場合falseが返る | E-03 (server.ts L30, includes判定) | ○ |
| C-055 | containerNameがReactでない場合falseが返る | E-03 (server.ts L31, containerName条件) | ○ |
| C-056 | reactからuseStateインポートでエラー診断が返る | E-03 (server.ts L36-89, L49-66) | ○ |
| C-057 | reactから許可APIインポートでエラーなし | E-03 (server.ts L55, includes判定) | ○ |
| C-058 | react-domからuseFormStatusインポートでエラー診断が返る | E-03 (server.ts L67-85) | ○ |
| C-059 | react以外モジュールからのインポートはエラーなし | E-03 (server.ts L49, L67, importPath正規表現) | ○ |
| C-060 | importClauseがない場合にエラーなし | E-03 (server.ts L48, if条件) | ○ |
| C-061 | ページファイルでparams, searchParams補完が返る | E-04 (entry.ts L15-109, L35-38) | ○ |
| C-062 | レイアウトファイルでparams, children補完が返る | E-04 (entry.ts L41-57) | ○ |
| C-063 | 名前付きスロットが存在するレイアウトでスロット名が補完に含まれる | E-04 (entry.ts L47-52) | ○ |
| C-064 | パラメータノードがない場合に空配列が返る | E-04 (entry.ts L24-28) | ○ |
| C-065 | 位置がパラメータノード外の場合に空配列が返る | E-04 (entry.ts L28) | ○ |
| C-066 | ページファイルで無効プロップ名の場合エラー診断が返る | E-04 (entry.ts L112-161, L147-155) | ○ |
| C-067 | ページファイルでparams, searchParamsのみの場合エラーなし | E-04 (entry.ts L147, includes判定) | ○ |
| C-068 | レイアウトファイルで無効プロップ名の場合エラー診断が返る | E-04 (entry.ts L127-138) | ○ |
| C-069 | レイアウトファイルでparams, childrenのみの場合エラーなし | E-04 (entry.ts L147, includes判定) | ○ |
| C-070 | レイアウトファイルでスロットプロップが許可される | E-04 (entry.ts L130-137) | ○ |
| C-071 | ObjectBindingPatternでないパラメータの場合にエラーなし | E-04 (entry.ts L144) | ○ |
| C-072 | エクスポート名にカーソルがある場合に全API設定名補完が追加される | E-05 (config.ts L267-291) | ○ |
| C-073 | 既知API設定名の値にカーソルがある場合にオプション値補完が追加される | E-05 (config.ts L284-290) | ○ |
| C-074 | 既知設定名にホバーした場合にAPI説明が返る | E-05 (config.ts L295-428) | ○ |
| C-075 | 有効な設定値にホバーした場合にオプション説明が返る | E-05 (config.ts L353-395) | ○ |
| C-076 | 未知設定名にホバーした場合にundefinedが返る | E-05 (config.ts L300) | ○ |
| C-077 | 関数型の値のイニシャライザ内でホバーした場合にTypeScriptデフォルトを返す | E-05 (config.ts L402-408) | △ |
| C-078 | 設定名のエントリ詳細が返る | E-05 (config.ts L432-545) | ○ |
| C-079 | 設定値のエントリ詳細が返る | E-05 (config.ts L446-449) | ○ |
| C-080 | metadataエントリでMetadataインポートがない場合にcodeActionsが含まれる | E-05 (config.ts L452-530) | ○ |
| C-081 | metadataエントリでMetadataインポート済みの場合にcodeActionsがundefined | E-05 (config.ts L505-506) | ○ |
| C-082 | moduleSpecifierがnext/typescriptで始まらない場合undefined | E-05 (config.ts L441) | ○ |
| C-083 | ALLOWED_EXPORTSに含まれないエクスポートの場合エラー診断 | E-05 (config.ts L548-664, L561-569) | ○ |
| C-084 | ALLOWED_EXPORTSに含まれるエクスポートの場合エラーなし | E-05 (config.ts L561, includes判定) | ○ |
| C-085 | dynamicに無効値でエラー診断が返る | E-05 (config.ts L581-595) | ○ |
| C-086 | dynamicに有効値でエラーなし | E-05 (config.ts L585-588) | ○ |
| C-087 | revalidateに数値0でエラーなし | E-05 (config.ts L102-103, isValid) | ○ |
| C-088 | revalidateにfalseでエラーなし | E-05 (config.ts L102, isValid) | ○ |
| C-089 | revalidateに負の数値でエラー診断 | E-05 (config.ts L103, >= 0) | ○ |
| C-090 | preferredRegionに配列でisValidで検証される | E-05 (config.ts L72-82) | ○ |
| C-091 | 静的に解析できない値の場合エラー診断が返る | E-05 (config.ts L638-643) | △ |
| C-092 | ArrowFunctionイニシャライザの場合に委譲される (client) | E-06 (client-boundary.ts L8-31) | ○ |
| C-093 | ArrowFunctionでないイニシャライザの場合に空配列が返る (client) | E-06 (client-boundary.ts L19) | ○ |
| C-094 | 関数型プロップがある場合にINVALID_CLIENT_ENTRY_PROP警告 | E-06 (client-boundary.ts L33-119, L64-96) | ○ |
| C-095 | actionという名前のプロップは警告なし | E-06 (client-boundary.ts L75-76) | ○ |
| C-096 | 名前がActionで終わるプロップは警告なし | E-06 (client-boundary.ts L76, 正規表現) | ○ |
| C-097 | error.tsxファイルでresetプロップは警告なし | E-06 (client-boundary.ts L81-82) | ○ |
| C-098 | global-error.tsxファイルでresetプロップは警告なし | E-06 (client-boundary.ts L44, 正規表現) | ○ |
| C-099 | クラス型プロップの場合にINVALID_CLIENT_ENTRY_PROP警告 | E-06 (client-boundary.ts L97-110) | ○ |
| C-100 | TypeCheckerが取得できない場合に空配列 (client) | E-06 (client-boundary.ts L39) | ○ |
| C-101 | パラメータがない関数の場合に空配列 (client) | E-06 (client-boundary.ts L46-47) | ○ |
| C-102 | クライアントでgenerateMetadata関数エクスポートでエラー | E-07 (metadata.ts L8-27) | ○ |
| C-103 | クライアントでmetadata変数エクスポートでエラー | E-07 (metadata.ts L30-44) | ○ |
| C-104 | クライアントでmetadata以外の変数エクスポートでエラーなし | E-07 (metadata.ts L32, name判定) | ○ |
| C-105 | クライアントでexport { metadata }でエラー | E-07 (metadata.ts L48-73) | ○ |
| C-106 | クライアントでexport { generateMetadata }でエラー | E-07 (metadata.ts L59) | ○ |
| C-107 | クライアントでexport { otherThing }でエラーなし | E-07 (metadata.ts L59, includes判定) | ○ |
| C-108 | サーバーでgenerateMetadata関数に戻り値型なしで警告 | E-07 (metadata.ts L76-103) | ○ |
| C-109 | async generateMetadataにPromise<Metadata>提案警告 | E-07 (metadata.ts L89-91, L98) | ○ |
| C-110 | サーバーでgenerateMetadata関数に戻り値型ありでエラーなし | E-07 (metadata.ts L85-87) | ○ |
| C-111 | サーバーでmetadata変数に型注釈なしで警告 | E-07 (metadata.ts L105-120) | ○ |
| C-112 | サーバーでmetadata変数に型注釈ありでエラーなし | E-07 (metadata.ts L106-108) | ○ |
| C-113 | サーバーでgenerateMetadataアロー関数に戻り値型なしで警告 | E-07 (metadata.ts L123-143) | ○ |
| C-114 | サーバーでexport { generateMetadata }型なしで警告 | E-07 (metadata.ts L149-240) | ○ |
| C-115 | type-onlyのexportでエラーなし | E-07 (metadata.ts L163, L165) | ○ |
| C-116 | TypeCheckerが取得できない場合に空配列 (metadata.server) | E-07 (metadata.ts L154-156) | ○ |
| C-117 | FunctionDeclarationに戻り値型がある場合trueが返る (hasType) | E-07 (metadata.ts L257-263) | ○ |
| C-118 | FunctionDeclarationに戻り値型がない場合falseが返る (hasType) | E-07 (metadata.ts L262) | ○ |
| C-119 | VariableDeclarationに型注釈がある場合trueが返る (hasType) | E-07 (metadata.ts L280) | ○ |
| C-120 | VariableDeclarationに型注釈がない場合falseが返る (hasType) | E-07 (metadata.ts L266-280) | ○ |
| C-121 | generateMetadataアロー関数イニシャライザに戻り値型ありでtrue | E-07 (metadata.ts L268-276) | ○ |
| C-122 | サポートされないノード型の場合falseが返る (hasType) | E-07 (metadata.ts L247-254) | ○ |
| C-123 | error.tsxでuse clientなしの場合にエラー診断が返る | E-08 (error.ts L7-33, L19-30) | ○ |
| C-124 | error.tsxでuse clientありの場合にエラーなし | E-08 (error.ts L32) | ○ |
| C-125 | global-error.tsxでuse clientなしの場合にエラー診断 | E-08 (error.ts L13, L19-30) | ○ |
| C-126 | global-error.tsxでuse clientありの場合にエラーなし | E-08 (error.ts L32) | ○ |
| C-127 | error.tsxでもglobal-error.tsxでもないファイルで空配列 | E-08 (error.ts L15) | ○ |
| C-128 | Promise型の場合trueが返る (isPromiseType) | E-09 (server-boundary.ts L8-20) | ○ |
| C-129 | 非Promise型の場合falseが返る (isPromiseType) | E-09 (server-boundary.ts L13-17) | ○ |
| C-130 | targetがない型の場合falseが返る (isPromiseType) | E-09 (server-boundary.ts L10) | ○ |
| C-131 | Promiseを返す関数の場合trueが返る | E-09 (server-boundary.ts L22-53) | ○ |
| C-132 | Promiseを返さない関数の場合falseが返る | E-09 (server-boundary.ts L45) | ○ |
| C-133 | 呼び出しシグネチャがない場合falseが返る | E-09 (server-boundary.ts L48-50) | ○ |
| C-134 | Union型でPromise|Promiseの場合trueが返る | E-09 (server-boundary.ts L37-43) | △ |
| C-135 | Union型でPromise|stringの場合falseが返る | E-09 (server-boundary.ts L39-41) | △ |
| C-136 | Promiseを返さないexportでエラー診断 (server-boundary) | E-09 (server-boundary.ts L56-86) | ○ |
| C-137 | Promiseを返すexportでエラーなし (server-boundary) | E-09 (server-boundary.ts L72) | ○ |
| C-138 | type-onlyのexportでエラーなし (server-boundary) | E-09 (server-boundary.ts L67, L69) | ○ |
| C-139 | TypeCheckerが取得できない場合に空配列 (server-boundary export) | E-09 (server-boundary.ts L62) | ○ |
| C-140 | ArrowFunctionイニシャライザの場合に委譲される (server) | E-09 (server-boundary.ts L88-127, L101) | ○ |
| C-141 | 関数でないイニシャライザの場合にエラー診断 (server) | E-09 (server-boundary.ts L113-121) | ○ |
| C-142 | Identifier型イニシャライザの場合に委譲される | E-09 (server-boundary.ts L105) | ○ |
| C-143 | CallExpression型イニシャライザの場合に委譲される | E-09 (server-boundary.ts L104) | ○ |
| C-144 | Promiseを返さない関数でエラー診断 (function export) | E-09 (server-boundary.ts L129-156) | ○ |
| C-145 | Promiseを返す関数でエラーなし (function export) | E-09 (server-boundary.ts L144) | ○ |
| C-146 | TypeCheckerが取得できない場合に空配列 (function export) | E-09 (server-boundary.ts L140) | ○ |
| C-147 | プラグインが無効の場合に元のlanguageServiceが返る | E-10 (index.ts L40-44) | ○ |
| C-148 | プラグインが有効の場合にプロキシlanguageServiceが返る | E-10 (index.ts L40-57) | ○ |
| C-149 | enabledが指定されていない場合にデフォルトで有効になる | E-10 (index.ts L40, ?? true) | ○ |
| C-150 | appエントリファイルでない場合にpriorがそのまま返る (completions) | E-10 (index.ts L75) | ○ |
| C-151 | サーバーエントリファイルの場合にserverLayerのフィルタが適用される | E-10 (index.ts L79-82) | ○ |
| C-152 | ソースファイルが取得できない場合にpriorが返る (completions) | E-10 (index.ts L88) | ○ |
| C-153 | entryConfigの詳細が見つかった場合にそれが返る | E-10 (index.ts L119-124) | ○ |
| C-154 | entryConfigの詳細が見つからない場合にlanguageServiceの結果が返る | E-10 (index.ts L126-134) | ○ |
| C-155 | appエントリファイルでない場合にpriorが返る (quickInfo) | E-10 (index.ts L143) | ○ |
| C-156 | サーバーエントリで禁止APIにホバーした場合にundefined | E-10 (index.ts L147-158) | ○ |
| C-157 | サーバーエントリでreactインポートの場合にserverLayer診断追加 | E-10 (index.ts L199-211) | ○ |
| C-158 | appエントリでexport constの場合にentryConfigとmetadata診断追加 | E-10 (index.ts L213-234) | ○ |
| C-159 | クライアントエントリでexport constの場合にclientBoundary診断追加 | E-10 (index.ts L237-244) | ○ |
| C-160 | サーバーエントリでexport constの場合にserverBoundary診断追加 | E-10 (index.ts L246-253) | ○ |
| C-161 | appディレクトリ内のerror.tsxの場合にerrorEntry診断追加 | E-10 (index.ts L191-197) | ○ |
| C-162 | export default functionの場合にentryDefault診断追加 | E-10 (index.ts L254-263) | ○ |
| C-163 | getEntryInfoがエラーをスローした場合にMISPLACED_ENTRY_DIRECTIVE追加 | E-10 (index.ts L176-189) | ○ |
| C-164 | ソースファイルが取得できない場合にpriorがそのまま返る (diagnostics) | E-10 (index.ts L170) | ○ |
| C-165 | appエントリでexport { ... }の場合にmetadata診断追加 | E-10 (index.ts L317-330) | ○ |
| C-166 | サーバーエントリでexport { ... }の場合にserverBoundary診断追加 | E-10 (index.ts L332-339) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-077: `config.getQuickInfoAtPosition`の関数値イニシャライザ内ホバー動作は、複雑な条件分岐（isFunctionValue && isPositionInsideNode(position, value) && !isPositionInsideNode(position, name)）に依存しており、実行時テストでの検証が推奨される
  - 候補：TypeScript Language Service の統合テスト / E2Eテスト
- C-091: 非リテラル値の判定は多数のelse分岐の最終節に依存し、全パターン網羅の根拠が不十分
  - 候補：config.tsの具体的な分岐フローの網羅テスト
- C-134/C-135: Union型のPromise判定はTypeCheckerの実行時動作に強く依存
  - 候補：TypeScript Compiler API の挙動テスト
- 既存テストコードの参照：本モジュールに対する既存のテストファイルの存在確認が未実施（test/ディレクトリの調査が必要）

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: TypeScript Language Service Plugin のテストは、TypeScriptのコンパイラAPIに強く依存するため、モック構築が複雑になる可能性がある。特にTypeChecker、SourceFile、ASTノードのモックは注意が必要
- **1 (中リスク)**: `config.ts`の`getSemanticDiagnosticsForExportVariableStatement`は多数の値型分岐（StringLiteral, NumericLiteral, BooleanLiteral, ArrayLiteralExpression等）を持ち、各分岐の網羅テストが必要
- **0 (低リスク)**: 定数定義（constant.ts）のテストは単純な値比較であり、リスクは低い
- **0 (低リスク)**: ユーティリティ関数（removeStringQuotes, isPositionInsideNode等）は純粋関数であり、テストが容易

## 6) レビュアーチェックリスト（最小）
- [ ] TypeScript Compiler APIのモック戦略が適切か（TypeChecker, SourceFile, Node等）
- [ ] 各ルールファイル（server.ts, entry.ts, config.ts, client-boundary.ts, server-boundary.ts, metadata.ts, error.ts）の主要分岐が網羅されているか
- [ ] `getEntryInfo`のディレクティブ判定（use client / use server）の全パターンが網羅されているか
- [ ] config.tsのAPI_DOCSに定義された各設定オプション（dynamic, fetchCache, preferredRegion, revalidate, dynamicParams, runtime）の有効/無効値テストが十分か
- [ ] client-boundary.tsの「Server Action例外」（action名、xxxAction名、error.tsxのreset）が正しくテストされているか
- [ ] server-boundary.tsのPromise返却判定（isPromiseType, isFunctionReturningPromise）のエッジケース（Union型等）が検証されているか
