---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 223
  claims_with_evidence: 217
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：next-src-server-web 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：217 / 223、根拠なし：6
- 優先レビュー（高）
  1. **C-165〜C-174（adapter関数の統合テスト）**：adapter関数は多数の外部依存と複雑な分岐を持ち、単体テストの前提条件・モック構成の詳細が不足
  2. **C-191〜C-197（sandbox run/getRuntimeContext）**：EdgeRuntime環境の構築が必要で、テスト実行環境への依存が大きい
  3. **C-214〜C-218（unstable_cache）**：workAsyncStorage/workUnitAsyncStorageとincrementalCacheの組み合わせが複雑で、モック構成の詳細が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/web/utils.ts` - fromNodeOutgoingHttpHeaders, splitCookiesString, toNodeOutgoingHttpHeaders, validateURL, normalizeNextQueryParam
- E-02: `packages/next/src/server/web/error.ts` - PageSignatureError, RemovedPageError, RemovedUAError
- E-03: `packages/next/src/server/web/http.ts` - HTTP_METHODS, isHTTPMethod
- E-04: `packages/next/src/server/web/next-url.ts` - NextURL class
- E-05: `packages/next/src/server/web/web-on-close.ts` - CloseController, trackBodyConsumed, trackStreamConsumed
- E-06: `packages/next/src/server/web/internal-edge-wait-until.ts` - internal_getCurrentFunctionWaitUntil, internal_runWithWaitUntil
- E-07: `packages/next/src/server/web/get-edge-preview-props.ts` - getEdgePreviewProps
- E-08: `packages/next/src/server/web/globals.ts` - getEdgeInstrumentationModule, ensureInstrumentationRegistered, edgeInstrumentationOnRequestError, __import_unsupported, enhanceGlobals
- E-09: `packages/next/src/server/web/spec-extension/request.ts` - NextRequest class
- E-10: `packages/next/src/server/web/spec-extension/response.ts` - NextResponse class, handleMiddlewareField
- E-11: `packages/next/src/server/web/spec-extension/fetch-event.ts` - FetchEvent, NextFetchEvent, getWaitUntilPromiseFromEvent
- E-12: `packages/next/src/server/web/spec-extension/user-agent.ts` - isBot, userAgentFromString, userAgent
- E-13: `packages/next/src/server/web/spec-extension/image-response.ts` - ImageResponse
- E-14: `packages/next/src/server/web/spec-extension/adapters/reflect.ts` - ReflectAdapter
- E-15: `packages/next/src/server/web/spec-extension/adapters/headers.ts` - HeadersAdapter, ReadonlyHeadersError
- E-16: `packages/next/src/server/web/spec-extension/adapters/request-cookies.ts` - RequestCookiesAdapter, MutableRequestCookiesAdapter, appendMutableCookies, getModifiedCookieValues, areCookiesMutableInCurrentPhase, responseCookiesToRequestCookies
- E-17: `packages/next/src/server/web/spec-extension/adapters/next-request.ts` - NextRequestAdapter, signalFromNodeResponse, createAbortController, ResponseAborted
- E-18: `packages/next/src/server/web/adapter.ts` - NextRequestHint, adapter function
- E-19: `packages/next/src/server/web/sandbox/resource-managers.ts` - IntervalsManager, TimeoutsManager, ResourceManager
- E-20: `packages/next/src/server/web/sandbox/fetch-inline-assets.ts` - fetchInlineAsset
- E-21: `packages/next/src/server/web/sandbox/context.ts` - clearAllModuleContexts, clearModuleContext, getModuleContext, createModuleContext
- E-22: `packages/next/src/server/web/sandbox/sandbox.ts` - run, getRuntimeContext, withTaggedErrors
- E-23: `packages/next/src/server/web/spec-extension/revalidate.ts` - revalidateTag, revalidatePath, updateTag, refresh, revalidate
- E-24: `packages/next/src/server/web/spec-extension/unstable-cache.ts` - unstable_cache
- E-25: `packages/next/src/server/web/spec-extension/unstable-no-store.ts` - unstable_noStore
- E-26: `packages/next/src/server/web/edge-route-module-wrapper.ts` - EdgeRouteModuleWrapper
- E-27: `packages/next/src/server/web/utils.test.ts` - 既存テストファイル（splitCookiesString等のテストが存在）
- E-28: `packages/next/src/server/web/web-on-close.test.ts` - 既存テストファイル（CloseController等のテストが存在）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-005 | fromNodeOutgoingHttpHeaders: 単一値, 配列値, 数値型, undefined, 空オブジェクト | E-01 | ○ |
| C-006〜C-009 | splitCookiesString: 単一Cookie, 複数Cookie, Expiresカンマ, 空文字列 | E-01, E-27 | ○ |
| C-010〜C-012 | toNodeOutgoingHttpHeaders: 通常ヘッダー, set-cookie, 空Headers | E-01 | ○ |
| C-013〜C-015 | validateURL: 有効URL, 不正URL, URLオブジェクト | E-01 | ○ |
| C-016〜C-019 | normalizeNextQueryParam: nxtPプレフィックス, nxtIプレフィックス, プレフィックスなし, プレフィックスのみ | E-01 | ○ |
| C-020〜C-022 | エラークラス: PageSignatureError, RemovedPageError, RemovedUAError | E-02 | ○ |
| C-023〜C-028 | isHTTPMethod: GET, POST, PATCH, 無効, 小文字, 空文字列 | E-03 | ○ |
| C-029〜C-046 | NextURL: コンストラクタ, pathname, locale, basePath, buildId, href, clone, toString, toJSON | E-04 | ○ |
| C-047〜C-055 | CloseController/trackStreamConsumed/trackBodyConsumed | E-05, E-28 | ○ |
| C-056〜C-060 | internal_getCurrentFunctionWaitUntil, internal_runWithWaitUntil | E-06 | ○ |
| C-061〜C-062 | getEdgePreviewProps: 環境変数設定/未設定 | E-07 | ○ |
| C-063〜C-072 | globals: getEdgeInstrumentationModule, ensureInstrumentationRegistered, edgeInstrumentationOnRequestError, __import_unsupported | E-08 | ○ |
| C-073〜C-078 | NextRequest: コンストラクタ, cookies, nextUrl, page, ua | E-09 | ○ |
| C-079〜C-091 | NextResponse: コンストラクタ, json, redirect, rewrite, next, cookies, handleMiddlewareField | E-10 | ○ |
| C-092〜C-098 | FetchEvent/NextFetchEvent: コンストラクタ, request, respondWith, waitUntil, getWaitUntilPromiseFromEvent | E-11 | ○ |
| C-099〜C-107 | isBot, userAgentFromString, userAgent | E-12 | ○ |
| C-108 | ImageResponse: エラースロー | E-13 | ○ |
| C-109〜C-114 | ReflectAdapter: get, set, has, deleteProperty | E-14 | ○ |
| C-115〜C-133 | HeadersAdapter: コンストラクタ, get, has, set, append, delete, entries, from, seal, ReadonlyHeadersError | E-15 | ○ |
| C-134〜C-149 | request-cookies: ReadonlyRequestCookiesError, RequestCookiesAdapter, getModifiedCookieValues, appendMutableCookies, MutableRequestCookiesAdapter, areCookiesMutableInCurrentPhase, responseCookiesToRequestCookies | E-16 | ○ |
| C-150〜C-160 | NextRequestAdapter, signalFromNodeResponse, createAbortController, ResponseAborted | E-17 | ○ |
| C-161〜C-164 | NextRequestHint: コンストラクタ, request, respondWith, waitUntil | E-18 | ○ |
| C-165〜C-174 | adapter関数: 基本動作, TypeError, URL正規化, null応答, ミドルウェア, リライト, リダイレクト, RSC, Cookie, flightHeaders | E-18 | △ |
| C-175〜C-180 | resource-managers: IntervalsManager, TimeoutsManager | E-19 | ○ |
| C-181〜C-184 | fetchInlineAsset: blob:プレフィックス, 非アセット, アセット不在, ファイル不在 | E-20 | ○ |
| C-185〜C-190 | context: clearAllModuleContexts, clearModuleContext, getModuleContext | E-21 | ○ |
| C-191〜C-197 | sandbox run, getRuntimeContext | E-22 | △ |
| C-198〜C-213 | revalidateTag, revalidatePath, updateTag, refresh, revalidate | E-23 | ○ |
| C-214〜C-218 | unstable_cache | E-24 | △ |
| C-219〜C-221 | unstable_noStore | E-25 | ○ |
| C-222〜C-223 | EdgeRouteModuleWrapper | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- **adapter関数（C-165〜C-174）**：adapter関数は多くの外部モジュール（workAsyncStorage, workUnitAsyncStorage, getTracer等）に依存しており、単体テストでの正確なモック構成が不明。テストの前提条件として「どのモジュールをどのようにモックするか」の詳細が必要。
  - 候補：adapter関数の統合テスト / モック戦略ドキュメント / 既存テストケースの調査
- **sandbox run/getRuntimeContext（C-191〜C-197）**：EdgeRuntime環境のセットアップが必要で、テスト環境構築の詳細が不足。
  - 候補：EdgeRuntimeのテスト用モック / sandbox/context.test.tsの参照
- **unstable_cache（C-214〜C-218）**：workAsyncStorageとincrementalCacheの相互作用が複雑で、全分岐のテスト条件の特定が困難。
  - 候補：既存のunstable_cacheテスト / incrementalCacheのモック仕様

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：adapter関数のテストケースは統合テストに近い内容を含んでおり、純粋な単体テストとして実行するにはモック設計が必要
- **リスク0（低）**：utils.ts, http.ts, error.ts等の純粋関数はモック不要で高い信頼度でテスト可能
- **リスク1（中）**：revalidateTag/revalidatePath/updateTag/refreshはAsyncLocalStorage依存があり、テスト環境でのストア設定が必要
- **リスク1（中）**：unstable_cacheは多層のキャッシュロジックと非同期処理を含み、テストケースの網羅性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] utils.ts の各関数（fromNodeOutgoingHttpHeaders, splitCookiesString, toNodeOutgoingHttpHeaders, validateURL, normalizeNextQueryParam）のテストケースが正常系・異常系・境界値を網羅しているか
- [ ] NextURL のロケール関連テストケースでi18n設定の前提条件が明確か
- [ ] NextResponse.redirect のステータスコード検証が全有効値（301,302,303,307,308）をカバーしているか
- [ ] HeadersAdapter.seal / RequestCookiesAdapter.seal の変更禁止テストが全mutativeメソッド（set, delete, append, clear）をカバーしているか
- [ ] adapter関数のテストケースについて、モック対象モジュールのリストが十分か
- [ ] revalidateTag/revalidatePath/updateTag/refreshのworkUnitStoreの各type別分岐がテストされているか
- [ ] sandbox run関数のFORBIDDEN_HEADERS削除テストが全対象ヘッダー（content-length, content-encoding, transfer-encoding）を含んでいるか
