---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 226
  claims_with_evidence: 220
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：next-src-shared-lib 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：220 / 226、根拠なし：6
- 優先レビュー（高）
  1. **image-loader.ts の defaultLoader テストケース未生成**：複雑な条件分岐があるがランタイム環境依存が多くテストケース生成を見送った部分あり
  2. **router/router.ts のテストケース未生成**：非常に大きなファイルで、ブラウザ環境依存が強いため単体テスト対象から除外
  3. **format-webpack-messages.ts のテストケース未生成**：Webpackメッセージフォーマットはビルドツール依存で単体テスト困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/shared/lib/bloom-filter.ts` - BloomFilterクラスの実装
- E-02: `packages/next/src/shared/lib/deep-freeze.ts` - deepFreeze関数の実装
- E-03: `packages/next/src/shared/lib/encode-uri-path.ts` - encodeURIPath関数の実装
- E-04: `packages/next/src/shared/lib/escape-regexp.ts` - escapeStringRegexp関数の実装
- E-05: `packages/next/src/shared/lib/fnv1a.ts` - fnv1aハッシュ関数の実装
- E-06: `packages/next/src/shared/lib/hash.ts` - djb2Hash/hexHash関数の実装
- E-07: `packages/next/src/shared/lib/get-hostname.ts` - getHostname関数の実装
- E-08: `packages/next/src/shared/lib/is-plain-object.ts` - isPlainObject/getObjectClassLabel関数の実装
- E-09: `packages/next/src/shared/lib/is-thenable.ts` - isThenable関数の実装
- E-10: `packages/next/src/shared/lib/mitt.ts` - mittイベントエミッターの実装
- E-11: `packages/next/src/shared/lib/normalized-asset-prefix.ts` - normalizedAssetPrefix関数の実装
- E-12: `packages/next/src/shared/lib/match-local-pattern.ts` - matchLocalPattern/hasLocalMatch関数の実装
- E-13: `packages/next/src/shared/lib/match-remote-pattern.ts` - matchRemotePattern/hasRemoteMatch関数の実装
- E-14: `packages/next/src/shared/lib/find-closest-quality.ts` - findClosestQuality関数の実装
- E-15: `packages/next/src/shared/lib/magic-identifier.ts` - decodeMagicIdentifier等の実装
- E-16: `packages/next/src/shared/lib/segment.ts` - セグメント関連関数群の実装
- E-17: `packages/next/src/shared/lib/server-reference-info.ts` - サーバーリファレンス情報解析の実装
- E-18: `packages/next/src/shared/lib/image-blur-svg.ts` - getImageBlurSvg関数の実装
- E-19: `packages/next/src/shared/lib/invariant-error.ts` - InvariantErrorクラスの実装
- E-20: `packages/next/src/shared/lib/is-internal.ts` - isInternal関数の実装
- E-21: `packages/next/src/shared/lib/promise-with-resolvers.ts` - createPromiseWithResolvers関数の実装
- E-22: `packages/next/src/shared/lib/router/utils/parse-path.ts` - parsePath関数の実装
- E-23: `packages/next/src/shared/lib/router/utils/path-has-prefix.ts` - pathHasPrefix関数の実装
- E-24: `packages/next/src/shared/lib/router/utils/add-path-prefix.ts` - addPathPrefix関数の実装
- E-25: `packages/next/src/shared/lib/router/utils/add-path-suffix.ts` - addPathSuffix関数の実装
- E-26: `packages/next/src/shared/lib/router/utils/remove-path-prefix.ts` - removePathPrefix関数の実装
- E-27: `packages/next/src/shared/lib/router/utils/remove-trailing-slash.ts` - removeTrailingSlash関数の実装
- E-28: `packages/next/src/shared/lib/router/utils/relativize-url.ts` - parseRelativeURL/getRelativeURL関数の実装
- E-29: `packages/next/src/shared/lib/router/utils/app-paths.ts` - normalizeAppPath/normalizeRscURL関数の実装
- E-30: `packages/next/src/shared/lib/router/utils/is-dynamic.ts` - isDynamicRoute関数の実装
- E-31: `packages/next/src/shared/lib/router/utils/format-url.ts` - formatUrl関数の実装
- E-32: `packages/next/src/shared/lib/router/utils/get-asset-path-from-route.ts` - getAssetPathFromRoute関数の実装
- E-33: `packages/next/src/shared/lib/router/utils/get-route-from-asset-path.ts` - getRouteFromAssetPath関数の実装
- E-34: `packages/next/src/shared/lib/router/utils/escape-path-delimiters.ts` - escapePathDelimiters関数の実装
- E-35: `packages/next/src/shared/lib/router/utils/omit.ts` - omit関数の実装
- E-36: `packages/next/src/shared/lib/router/utils/interception-routes.ts` - インターセプションルート関数群の実装
- E-37: `packages/next/src/shared/lib/router/utils/sorted-routes.ts` - getSortedRoutes/UrlNodeの実装
- E-38: `packages/next/src/shared/lib/router/utils/route-regex.ts` - getRouteRegex/getNamedRouteRegex関数の実装
- E-39: `packages/next/src/shared/lib/router/utils/route-matcher.ts` - getRouteMatcher関数の実装
- E-40: `packages/next/src/shared/lib/router/utils/add-locale.ts` - addLocale関数の実装
- E-41: `packages/next/src/shared/lib/i18n/normalize-locale-path.ts` - normalizeLocalePath関数の実装
- E-42: `packages/next/src/shared/lib/i18n/detect-domain-locale.ts` - detectDomainLocale関数の実装
- E-43: `packages/next/src/shared/lib/page-path/ensure-leading-slash.ts` - ensureLeadingSlash関数の実装
- E-44: `packages/next/src/shared/lib/page-path/normalize-path-sep.ts` - normalizePathSep関数の実装
- E-45: `packages/next/src/shared/lib/page-path/denormalize-page-path.ts` - denormalizePagePath関数の実装
- E-46: `packages/next/src/shared/lib/page-path/normalize-page-path.ts` - normalizePagePath関数の実装
- E-47: `packages/next/src/shared/lib/page-path/denormalize-app-path.ts` - denormalizeAppPagePath関数の実装
- E-48: `packages/next/src/shared/lib/page-path/remove-page-path-tail.ts` - removePagePathTail関数の実装
- E-49: `packages/next/src/shared/lib/router/utils/querystring.ts` - searchParamsToUrlQuery等の実装
- E-50: `packages/next/src/shared/lib/router/utils/is-bot.ts` - isBot/getBotType関数の実装
- E-51: `packages/next/src/shared/lib/router/utils/get-dynamic-param.ts` - parseParameter/parseMatchedParameter関数の実装
- E-52: `packages/next/src/shared/lib/router/utils/sortable-routes.ts` - getSegmentSpecificity/compareRouteSegments/sortPages関数の実装
- E-53: `packages/next/src/shared/lib/segment-cache/segment-value-encoding.ts` - createSegmentRequestKeyPart等の実装
- E-54: `packages/next/src/shared/lib/page-path/get-page-paths.ts` - getPagePaths関数の実装
- E-55: `packages/next/src/shared/lib/image-config.ts` - imageConfigDefault定数の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BloomFilter constructor がデフォルトエラーレートで初期化される | E-01 (L23-31) | ○ |
| C-02 | BloomFilter.from が文字列配列からフィルタを生成する | E-01 (L33-40) | ○ |
| C-03 | BloomFilter.add/contains が正しく動作する | E-01 (L77-87) | ○ |
| C-04 | BloomFilter.export/import がデータを保存・復元できる | E-01 (L42-75) | ○ |
| C-05 | deepFreeze がオブジェクトを再帰的にフリーズする | E-02 (L11-32) | ○ |
| C-06 | deepFreeze が配列を再帰的にフリーズする | E-02 (L17-24) | ○ |
| C-07 | encodeURIPath がスラッシュを保持しつつエンコードする | E-03 (L1-6) | ○ |
| C-08 | escapeStringRegexp が正規表現特殊文字をエスケープする | E-04 (L5-11) | ○ |
| C-09 | fnv1a が各サイズでハッシュを生成する | E-05 (L35-72) | ○ |
| C-10 | fnv1a が不正なサイズでエラーをスローする | E-05 (L45-49) | ○ |
| C-11 | fnv1a がUnicode文字列を処理する | E-05 (L61-65) | ○ |
| C-12 | djb2Hash/hexHash が決定的ハッシュを生成する | E-06 (L8-19) | ○ |
| C-13 | getHostname がheadersまたはparsedからホスト名を取得する | E-07 (L9-23) | ○ |
| C-14 | isPlainObject がプレーンオブジェクトを判定する | E-08 (L5-22) | ○ |
| C-15 | isThenable がPromise/thenable を判定する | E-09 (L7-16) | ○ |
| C-16 | mitt が on/off/emit で正しくイベントを管理する | E-10 (L25-46) | ○ |
| C-17 | normalizedAssetPrefix が各種形式を正規化する | E-11 (L1-19) | ○ |
| C-18 | matchLocalPattern/hasLocalMatch がローカルパターンをマッチングする | E-12 (L5-29) | ○ |
| C-19 | matchRemotePattern/hasRemoteMatch がリモートパターンをマッチングする | E-13 (L5-53) | ○ |
| C-20 | matchRemotePattern が hostname 未定義でエラーをスローする | E-13 (L20-23) | ○ |
| C-21 | findClosestQuality が最も近い品質を返す | E-14 (L9-21) | ○ |
| C-22 | decodeMagicIdentifier が TURBOPACK 識別子をデコードする | E-15 (L23-93) | ○ |
| C-23 | deobfuscateModuleId がモジュールIDをクリーンアップする | E-15 (L102-116) | ○ |
| C-24 | removeFreeCallWrapper が (0, expr) パターンを除去する | E-15 (L123-131) | ○ |
| C-25 | segment 関数群が正しくセグメント操作を行う | E-16 (L3-89) | ○ |
| C-26 | extractInfoFromServerReferenceId がIDからサーバーリファレンス情報を抽出する | E-17 (L27-54) | ○ |
| C-27 | omitUnusedArgs が使用されていない引数を除外する | E-17 (L60-78) | ○ |
| C-28 | getImageBlurSvg がSVGブラーを生成する | E-18 (L4-34) | ○ |
| C-29 | InvariantError がメッセージをフォーマットする | E-19 (L1-9) | ○ |
| C-30 | isInternal がNext.js内部ファイルを判定する | E-20 (L12-20) | ○ |
| C-31 | createPromiseWithResolvers が resolve/reject/promise を返す | E-21 (L1-10) | ○ |
| C-32 | parsePath がパス・クエリ・ハッシュを分離する | E-22 (L6-22) | ○ |
| C-33 | pathHasPrefix がプレフィックスの完全一致を判定する | E-23 (L10-17) | ○ |
| C-34 | addPathPrefix がパスにプレフィックスを追加する | E-24 (L7-14) | ○ |
| C-35 | addPathSuffix がパスにサフィックスを追加する | E-25 (L8-15) | ○ |
| C-36 | removePathPrefix がプレフィックスを除去する | E-26 (L11-39) | ○ |
| C-37 | removeTrailingSlash が末尾スラッシュを除去する | E-27 (L8-10) | ○ |
| C-38 | parseRelativeURL/getRelativeURL が相対URLを処理する | E-28 (L16-42) | ○ |
| C-39 | normalizeAppPath がApp Routerパスを正規化する | E-29 (L23-52) | ○ |
| C-40 | normalizeRscURL が.rsc拡張子を除去する | E-29 (L58-64) | ○ |
| C-41 | isDynamicRoute が動的ルートを検出する | E-30 (L19-29) | ○ |
| C-42 | formatUrl がURLオブジェクトからURL文字列を生成する | E-31 (L29-73) | ○ |
| C-43 | getAssetPathFromRoute がルートをアセットパスに変換する | E-32 (L3-14) | ○ |
| C-44 | getRouteFromAssetPath がアセットパスをルートに変換する | E-33 (L6-19) | ○ |
| C-45 | escapePathDelimiters がデリミタをエスケープする | E-34 (L2-10) | ○ |
| C-46 | omit が指定キーを除外する | E-35 (L1-12) | ○ |
| C-47 | isInterceptionRouteAppPath がインターセプションルートを検出する | E-36 (L13-22) | ○ |
| C-48 | extractInterceptionRouteInformation がインターセプション情報を抽出する | E-36 (L39-108) | ○ |
| C-49 | getSortedRoutes がルートを優先度順にソートする | E-37 (L207-227) | ○ |
| C-50 | getSortedRoutes が同じレベルで異なるスラッグ名でエラーを出す | E-37 (L128-133) | ○ |
| C-51 | getRouteRegex がルート正規表現を生成する | E-38 (L149-172) | ○ |
| C-52 | getRouteMatcher がパスマッチとパラメータ抽出を行う | E-39 (L17-50) | ○ |
| C-53 | addLocale がロケールプレフィックスを管理する | E-40 (L9-30) | ○ |
| C-54 | normalizeLocalePath がパスからロケールを検出・除去する | E-41 (L22-61) | ○ |
| C-55 | detectDomainLocale がドメインロケールを検出する | E-42 (L3-25) | ○ |
| C-56 | ensureLeadingSlash が先頭スラッシュを保証する | E-43 (L5-7) | ○ |
| C-57 | normalizePathSep がパス区切り文字を正規化する | E-44 (L6-8) | ○ |
| C-58 | denormalizePagePath がページパスを逆変換する | E-45 (L12-19) | ○ |
| C-59 | normalizePagePath がページパスを正規化する | E-46 (L14-33) | ○ |
| C-60 | denormalizeAppPagePath がAppページパスを逆変換する | E-47 (L1-8) | ○ |
| C-61 | removePagePathTail が拡張子とindex末尾を除去する | E-48 (L14-31) | ○ |
| C-62 | searchParamsToUrlQuery/urlQueryToSearchParams がクエリを変換する | E-49 (L3-47) | ○ |
| C-63 | assign が SearchParams をマージする | E-49 (L49-64) | ○ |
| C-64 | isBot/getBotType がボットを検出する | E-50 (L21-33) | ○ |
| C-65 | parseParameter/parseMatchedParameter がパラメータを解析する | E-51 (L189-220) | ○ |
| C-66 | getSegmentSpecificity/compareRouteSegments がルートの特異度を判定する | E-52 (L35-114) | ○ |
| C-67 | sortPages がページをソートする | E-52 (L176-180) | ○ |
| C-68 | createSegmentRequestKeyPart がセグメントキーを生成する | E-53 (L14-48) | ○ |
| C-69 | appendSegmentRequestKeyPart がキーを連結する | E-53 (L50-68) | ○ |
| C-70 | convertSegmentPathToStaticExportFilename がファイル名に変換する | E-53 (L90-94) | ○ |
| C-71 | getPagePaths がページパス候補を生成する | E-54 (L16-40) | ○ |
| C-72 | image-loader.ts defaultLoader のバリデーションと URL 生成 | **根拠あり(E-55)だが環境依存コードのためテストケース限定的** | △ |
| C-73 | router/router.ts のルーター全体のテスト | **根拠なし - ブラウザ環境依存が強く単体テスト困難** | △ |
| C-74 | format-webpack-messages.ts のフォーマットテスト | **根拠なし - Webpack依存のメッセージフォーマット** | △ |
| C-75 | loadable.shared-runtime.tsx のテスト | **根拠なし - React コンポーネントで単体テスト困難** | △ |
| C-76 | head.tsx/side-effect.tsx のテスト | **根拠なし - React コンポーネントで単体テスト困難** | △ |
| C-77 | image-external.tsx のテスト | **根拠なし - React コンポーネントで単体テスト困難** | △ |

## 4) 不足情報（Unknown / Missing）
- **React コンポーネント系ファイル**: `head.tsx`, `side-effect.tsx`, `image-external.tsx`, `loadable.shared-runtime.tsx`, `dynamic.tsx`, `app-dynamic.tsx`, `lazy-dynamic/*.tsx` はReactコンポーネントであり、単体テストよりもコンポーネントテスト/統合テストが適切
  - 候補：React Testing Library / Enzyme / Jest + jsdom
- **router/router.ts**: ブラウザ環境に強く依存した大規模ファイルで、単体テストよりもE2Eテストが適切
  - 候補：Playwright / Cypress
- **format-webpack-messages.ts**: Webpack のエラーメッセージフォーマットに特化しており、Webpackバンドラーの出力形式に依存
  - 候補：Webpack テスト環境での統合テスト
- **turbopack/manifest-loader.ts**: Turbopackマニフェストの読み込み処理で、ファイルシステムとの連携が必要
  - 候補：モック化によるテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ユーティリティ関数群（hash, escape-regexp, encode-uri-path, omit等）：ロジックが単純で根拠が明確
- **0: 低リスク** - パス操作関数群（parse-path, path-has-prefix, add-path-prefix等）：ソースコードに明示的なロジックがあり全分岐をカバー
- **1: 中リスク** - i18n関連（normalize-locale-path, detect-domain-locale, add-locale）：ロケール検出のエッジケースが多い
- **1: 中リスク** - セキュリティ関連（match-remote-pattern, match-local-pattern）：画像ソースの検証ロジックでエッジケースの見落としリスクあり
- **1: 中リスク** - ルートソート/マッチング（sorted-routes, route-regex, route-matcher）：複雑な正規表現とルート優先度ロジック
- **2: 高リスク** - server-reference-info.ts：ビット操作によるIDパース処理で、仕様変更時の追従が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BloomFilter のテストケースがfalse positive率の確率的性質を考慮しているか
- [ ] match-remote-pattern / match-local-pattern のテストケースがワイルドカードパターンを網羅しているか
- [ ] server-reference-info のビットマスクテストケースが全ビットパターンをカバーしているか
- [ ] sorted-routes のテストケースが実際のNext.jsルーティングの優先度ルールと一致しているか
- [ ] interception-routes のテストケースが全マーカータイプ（(.), (..), (...), (..)(..)）をカバーしているか
- [ ] i18n関連テストケースがマルチバイト文字のロケール名を考慮しているか
- [ ] React コンポーネント系ファイルの除外判断が妥当か確認
