---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 116
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：next-src-telemetry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：116 / 120、根拠なし：4
- 優先レビュー（高）
  1. **UT-TEL-017**：_getProjectIdByGitのタイムアウト処理（プライベート関数のため直接テスト困難）
  2. **UT-TEL-058**：NEXT_TELEMETRY_DEBUGでのspawnSync使用（環境依存の動作確認が必要）
  3. **UT-TEL-114**：glibcVersionとinstalledSwcPackagesの収集（process.reportの利用可能性が環境依存）
  4. **UT-TEL-115**：glibc取得失敗時の安全な処理（process.reportの存在が環境依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/telemetry/anonymous-meta.ts` - getAnonymousMeta関数の実装（メモ化、CPU情報、CI情報、環境変数）
- E-02: `packages/next/src/telemetry/post-telemetry-payload.ts` - postNextTelemetryPayload関数の実装（fetch、retry、AbortSignal）
- E-03: `packages/next/src/telemetry/post-telemetry-payload.test.ts` - 既存テストファイル（送信成功、リトライ、エラー握りつぶし）
- E-04: `packages/next/src/telemetry/project-id.ts` - getRawProjectId, _getProjectIdByGit関数の実装
- E-05: `packages/next/src/telemetry/storage.ts` - Telemetryクラスの全メソッド実装（constructor, notify, anonymousId, salt, isDisabled, isEnabled, setEnabled, oneWayHash, getProjectId, record, flush, flushDetached, submitRecord）
- E-06: `packages/next/src/telemetry/flush-telemetry.ts` - flushTelemetry関数の実装
- E-07: `packages/next/src/telemetry/detached-flush.ts` - デタッチフラッシュスクリプト
- E-08: `packages/next/src/telemetry/events/build.ts` - ビルド関連イベント生成関数群（eventTypeCheckCompleted, eventLintCheckCompleted, eventAnalyzeCompleted, eventBuildCompleted, eventBuildFailed, eventBuildOptimize, eventBuildFeatureUsage, eventPackageUsedInGetServerSideProps, eventMcpToolUsage, eventErrorThrown）
- E-09: `packages/next/src/telemetry/events/error-feedback.ts` - eventErrorFeedback関数
- E-10: `packages/next/src/telemetry/events/plugins.ts` - eventNextPlugins関数
- E-11: `packages/next/src/telemetry/events/version.ts` - eventCliSession関数
- E-12: `packages/next/src/telemetry/events/session-stopped.ts` - eventCliSessionStopped関数
- E-13: `packages/next/src/telemetry/events/swc-load-failure.ts` - eventSwcLoadFailure関数
- E-14: `packages/next/src/telemetry/events/swc-plugins.ts` - eventSwcPlugins関数
- E-15: `packages/next/src/telemetry/events/mcp-telemetry.test.ts` - MCPテレメトリ既存テスト
- E-16: `packages/next/src/telemetry/events/index.ts` - イベントモジュール再エクスポート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TEL-001) | getAnonymousMetaがシステム情報を含むオブジェクトを返す | E-01 (L25-52) | ○ |
| C-02 (UT-TEL-002) | getAnonymousMetaがキャッシュされた値を返す | E-01 (L23, L26-28) | ○ |
| C-03 (UT-TEL-003) | CPUが0件の場合にnullになる | E-01 (L30, L39-40) | ○ |
| C-04 (UT-TEL-004) | NOW_REGION=dev1でisNowDev=true | E-01 (L31, L44) | ○ |
| C-05 (UT-TEL-005) | NOW_REGION未設定でisNowDev=false | E-01 (L44) | ○ |
| C-06 (UT-TEL-006) | CI環境でisCIがtrueでciNameが設定される | E-01 (L46-47) | ○ |
| C-07 (UT-TEL-007) | 非CI環境でisCI=false, ciName=null | E-01 (L46-47) | ○ |
| C-08 (UT-TEL-008) | テレメトリペイロードが正常に送信される | E-02 (L18-48), E-03 (L14-46) | ○ |
| C-09 (UT-TEL-009) | リトライ後に成功する | E-02 (L37), E-03 (L48-68) | ○ |
| C-10 (UT-TEL-010) | リトライ回数超過後にエラーが握りつぶされる | E-02 (L39-41), E-03 (L70-88) | ○ |
| C-11 (UT-TEL-011) | ok=falseでリトライされる | E-02 (L31-35) | ○ |
| C-12 (UT-TEL-012) | signal未指定時にAbortSignal.timeoutが使用される | E-02 (L19-21) | ○ |
| C-13 (UT-TEL-013) | 指定されたsignalが使用される | E-02 (L18, L29) | ○ |
| C-14 (UT-TEL-014) | gitリモートURLが返却される | E-04 (L14-41) | ○ |
| C-15 (UT-TEL-015) | REPOSITORY_URLにフォールバック | E-04 (L43-46) | ○ |
| C-16 (UT-TEL-016) | cwdにフォールバック | E-04 (L45) | ○ |
| C-17 (UT-TEL-017) | gitコマンドタイムアウトでnullが返却される | E-04 (L25, L38-40) | △ |
| C-18 (UT-TEL-018) | CI環境でdistDir/cacheが返却される | E-05 (L41-49) | ○ |
| C-19 (UT-TEL-019) | Docker環境でdistDir/cacheが返却される | E-05 (L42) | ○ |
| C-20 (UT-TEL-020) | 非CI・非Docker環境でundefinedが返却される | E-05 (L48) | ○ |
| C-21 (UT-TEL-021) | Telemetryインスタンスが正常生成される | E-05 (L62-82) | ○ |
| C-22 (UT-TEL-022) | Conf初期化失敗でconfがnull | E-05 (L70-77) | ○ |
| C-23 (UT-TEL-023) | NEXT_TELEMETRY_DISABLED読み込み | E-05 (L64-66) | ○ |
| C-24 (UT-TEL-024) | 初回通知メッセージ出力 | E-05 (L84-111) | ○ |
| C-25 (UT-TEL-025) | 通知済みの場合にメッセージ非出力 | E-05 (L93-95) | ○ |
| C-26 (UT-TEL-026) | テレメトリ無効時に通知非出力 | E-05 (L85-87) | ○ |
| C-27 (UT-TEL-027) | confがnullで通知非出力 | E-05 (L85) | ○ |
| C-28 (UT-TEL-028) | 既存anonymousId返却 | E-05 (L113-117) | ○ |
| C-29 (UT-TEL-029) | anonymousId新規生成・保存 | E-05 (L119-121) | ○ |
| C-30 (UT-TEL-030) | confがnullで毎回新規ID生成 | E-05 (L114, L120) | ○ |
| C-31 (UT-TEL-031) | 既存salt返却 | E-05 (L124-128) | ○ |
| C-32 (UT-TEL-032) | salt新規生成・保存 | E-05 (L130-132) | ○ |
| C-33 (UT-TEL-033) | NEXT_TELEMETRY_DISABLEDでisDisabled=true | E-05 (L136) | ○ |
| C-34 (UT-TEL-034) | confがnullでisDisabled=true | E-05 (L136) | ○ |
| C-35 (UT-TEL-035) | telemetry.enabled=falseでisDisabled=true | E-05 (L139) | ○ |
| C-36 (UT-TEL-036) | 全条件有効でisDisabled=false | E-05 (L135-140) | ○ |
| C-37 (UT-TEL-037) | isEnabled=trueの判定 | E-05 (L148-154) | ○ |
| C-38 (UT-TEL-038) | isEnabled=falseの判定 | E-05 (L150) | ○ |
| C-39 (UT-TEL-039) | setEnabledでtrue設定 | E-05 (L142-146) | ○ |
| C-40 (UT-TEL-040) | setEnabledでfalse設定 | E-05 (L143) | ○ |
| C-41 (UT-TEL-041) | confがnullでsetEnabledがnull返却 | E-05 (L144-145) | ○ |
| C-42 (UT-TEL-042) | 同一入力で同一ハッシュ | E-05 (L156-167) | ○ |
| C-43 (UT-TEL-043) | 異なる入力で異なるハッシュ | E-05 (L156-167) | ○ |
| C-44 (UT-TEL-044) | ハッシュが64文字hex | E-05 (L166) | ○ |
| C-45 (UT-TEL-045) | salt差異でハッシュ差異 | E-05 (L161) | ○ |
| C-46 (UT-TEL-046) | getProjectIdがハッシュ化値返却 | E-05 (L169-172) | ○ |
| C-47 (UT-TEL-047) | loadProjectIdキャッシュ利用 | E-05 (L170) | ○ |
| C-48 (UT-TEL-048) | 単一イベント記録 | E-05 (L174-217) | ○ |
| C-49 (UT-TEL-049) | 複数イベント配列記録 | E-05 (L174) | ○ |
| C-50 (UT-TEL-050) | deferred=trueでsubmitRecordスキップ | E-05 (L179-189) | ○ |
| C-51 (UT-TEL-051) | 完了後にqueueから削除 | E-05 (L203-208) | ○ |
| C-52 (UT-TEL-052) | submitRecord失敗時のRecordObject | E-05 (L197-201) | ○ |
| C-53 (UT-TEL-053) | flushで全Promise解決 | E-05 (L219-221) | ○ |
| C-54 (UT-TEL-054) | 空キューのフラッシュ | E-05 (L220) | ○ |
| C-55 (UT-TEL-055) | Promise拒否時にnull返却 | E-05 (L220) | ○ |
| C-56 (UT-TEL-056) | flushDetachedでファイル書き出しとプロセス起動 | E-05 (L226-276) | ○ |
| C-57 (UT-TEL-057) | 空キューでスキップ | E-05 (L238-241) | ○ |
| C-58 (UT-TEL-058) | NEXT_TELEMETRY_DEBUGでspawnSync使用 | E-05 (L258-259) | △ |
| C-59 (UT-TEL-059) | _controllerがabortされる | E-05 (L231) | ○ |
| C-60 (UT-TEL-060) | ファイル名にプロセスID含む | E-05 (L245) | ○ |
| C-61 (UT-TEL-061) | submitRecordでpostNextTelemetryPayload呼び出し | E-05 (L314-328) | ○ |
| C-62 (UT-TEL-062) | 無効時に送信スキップ | E-05 (L309-311) | ○ |
| C-63 (UT-TEL-063) | 空イベント配列で即座解決 | E-05 (L288-290) | ○ |
| C-64 (UT-TEL-064) | デバッグモードでconsole.error出力 | E-05 (L292-306) | ○ |
| C-65 (UT-TEL-065) | 単一イベントの配列変換 | E-05 (L282-286) | ○ |
| C-66 (UT-TEL-066) | flushTelemetryでflush呼び出し | E-06 (L3-10) | ○ |
| C-67 (UT-TEL-067) | telemetry未設定時の安全な動作 | E-06 (L7-8) | ○ |
| C-68 (UT-TEL-068) | eventTypeCheckCompletedのイベント形式 | E-08 (L20-28) | ○ |
| C-69 (UT-TEL-069) | typescriptVersion=nullの処理 | E-08 (L13) | ○ |
| C-70 (UT-TEL-070) | eventLintCheckCompletedのイベント形式 | E-08 (L45-53) | ○ |
| C-71 (UT-TEL-071) | eventAnalyzeCompleted成功イベント | E-08 (L66-74) | ○ |
| C-72 (UT-TEL-072) | eventAnalyzeCompleted失敗イベント | E-08 (L63-64) | ○ |
| C-73 (UT-TEL-073) | eventBuildCompletedのイベント形式 | E-08 (L86-108) | ○ |
| C-74 (UT-TEL-074) | ダンダーディレクトリ検出 | E-08 (L7, L98-100) | ○ |
| C-75 (UT-TEL-075) | __tests__の除外 | E-08 (L7-8) | ○ |
| C-76 (UT-TEL-076) | テストファイルパターン検出 | E-08 (L9, L101-104) | ○ |
| C-77 (UT-TEL-077) | 空pagePaths | E-08 (L97) | ○ |
| C-78 (UT-TEL-078) | eventBuildFailedのイベント形式 | E-08 (L117-122) | ○ |
| C-79 (UT-TEL-079) | eventBuildOptimizeのイベント形式 | E-08 (L151-178) | ○ |
| C-80 (UT-TEL-080) | NEXT_RSPACKでisRspack=true | E-08 (L175) | ○ |
| C-81 (UT-TEL-081) | NEXT_RSPACK未設定でisRspack=false | E-08 (L175) | ○ |
| C-82 (UT-TEL-082) | eventBuildFeatureUsageのイベント配列 | E-08 (L221-231) | ○ |
| C-83 (UT-TEL-083) | 空usagesで空配列 | E-08 (L224) | ○ |
| C-84 (UT-TEL-084) | 複数機能使用状況のマッピング | E-08 (L224) | ○ |
| C-85 (UT-TEL-085) | eventPackageUsedInGetServerSideProps | E-08 (L240-251) | ○ |
| C-86 (UT-TEL-086) | 空パッケージ配列 | E-08 (L245) | ○ |
| C-87 (UT-TEL-087) | eventMcpToolUsageのイベント配列 | E-08 (L268-278), E-15 | ○ |
| C-88 (UT-TEL-088) | featureNameからtoolNameへの変換 | E-08 (L273-274), E-15 (L108-122) | ○ |
| C-89 (UT-TEL-089) | 空MCP使用状況 | E-08 (L271), E-15 (L99-102) | ○ |
| C-90 (UT-TEL-090) | eventErrorThrownのイベント形式 | E-08 (L294-305) | ○ |
| C-91 (UT-TEL-091) | anonymizedLocation=undefinedの処理 | E-08 (L303) | ○ |
| C-92 (UT-TEL-092) | extractNextErrorCode=undefinedで'Unknown' | E-08 (L301) | ○ |
| C-93 (UT-TEL-093) | eventErrorFeedbackのイベント形式 | E-09 (L19-27) | ○ |
| C-94 (UT-TEL-094) | wasHelpful=falseの記録 | E-09 (L19-27) | ○ |
| C-95 (UT-TEL-095) | eventNextPluginsの依存関係イベント | E-10 (L12-48) | ○ |
| C-96 (UT-TEL-096) | devDependenciesの包含 | E-10 (L21-23) | ○ |
| C-97 (UT-TEL-097) | package.json未存在で空配列 | E-10 (L17-19) | ○ |
| C-98 (UT-TEL-098) | バージョン未設定のスキップ | E-10 (L29-31) | ○ |
| C-99 (UT-TEL-099) | 例外発生時に空配列 | E-10 (L45-47) | ○ |
| C-100 (UT-TEL-100) | eventCliSessionのイベント形式 | E-11 (L45-137) | ○ |
| C-101 (UT-TEL-101) | __NEXT_VERSION未設定で空配列 | E-11 (L81-83) | ○ |
| C-102 (UT-TEL-102) | i18n設定の反映 | E-11 (L85, L101-104) | ○ |
| C-103 (UT-TEL-103) | i18n未設定時のnull | E-11 (L101-104) | ○ |
| C-104 (UT-TEL-104) | images設定の反映 | E-11 (L98-99, L105-115) | ○ |
| C-105 (UT-TEL-105) | reactCompilerオブジェクト設定 | E-11 (L127-134) | ○ |
| C-106 (UT-TEL-106) | reactCompilerブーリアン設定 | E-11 (L128-130, L132-134) | ○ |
| C-107 (UT-TEL-107) | eventCliSessionStoppedのイベント形式 | E-12 (L14-40) | ○ |
| C-108 (UT-TEL-108) | __NEXT_VERSION未設定で空配列 | E-12 (L21-23) | ○ |
| C-109 (UT-TEL-109) | turboFlag=undefinedでpayloadに含まれない | E-12 (L30-34) | ○ |
| C-110 (UT-TEL-110) | turboFlagのboolean変換 | E-12 (L32) | ○ |
| C-111 (UT-TEL-111) | NEXT_RSPACKでisRspack設定 | E-12 (L37) | ○ |
| C-112 (UT-TEL-112) | eventSwcLoadFailureの記録・フラッシュ | E-13 (L21-69) | ○ |
| C-113 (UT-TEL-113) | telemetry未設定で安全に返る | E-13 (L24-26) | ○ |
| C-114 (UT-TEL-114) | glibcVersionとinstalledSwcPackagesの収集 | E-13 (L28-52) | △ |
| C-115 (UT-TEL-115) | glibc取得失敗時のundefined | E-13 (L31-34) | △ |
| C-116 (UT-TEL-116) | eventSwcPluginsのイベント配列 | E-14 (L15-50) | ○ |
| C-117 (UT-TEL-117) | ファイルパスプラグインのbasename処理 | E-14 (L35-37) | ○ |
| C-118 (UT-TEL-118) | package.json未存在で空配列 | E-14 (L20-23) | ○ |
| C-119 (UT-TEL-119) | swcPlugins未設定で空配列 | E-14 (L29) | ○ |
| C-120 (UT-TEL-120) | 依存関係にないプラグインのversion=undefined | E-14 (L33) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-TEL-017 (_getProjectIdByGit タイムアウト)**：`_getProjectIdByGit`はプライベート関数であり、直接単体テストで呼び出すにはモジュールの内部エクスポートか、テスト用のリファクタリングが必要。gitコマンドのタイムアウト動作（timeout: 1000）の実証は、統合テストまたはモック環境が必要。
  - 候補：git execのモック / child_processのスタブ / テストユーティリティによる間接テスト
- **UT-TEL-058 (spawnSync使用確認)**：`flushDetached`内でのspawnSync/spawnの分岐テストは、child_processモジュールのモックが必要。実際の子プロセス起動を伴うテストは環境依存が大きい。
  - 候補：child_processモジュールのモック / jest.mockによるspawnSync検証
- **UT-TEL-114, UT-TEL-115 (process.report利用)**：`process.report.getReport()`はNode.jsのバージョンおよび実行環境に依存し、全環境で利用可能ではない。glibcVersionの取得はLinux環境限定。
  - 候補：process.reportのモック / 条件付きテスト（CI環境での実行）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント生成関数群（build.ts, error-feedback.ts, plugins.ts, version.ts, session-stopped.ts）は純粋関数であり、テストケースの信頼性が高い
- 0: 低リスク - Telemetryクラスのプロパティアクセサ（anonymousId, salt, isDisabled, isEnabled）はConfモックで検証可能
- 1: 中リスク - flushDetachedのテストはchild_process.spawnのモックが必要であり、テスト実装の複雑度が高い
- 1: 中リスク - eventSwcLoadFailureはtraceGlobalsへの依存があり、グローバル状態のモック管理が必要
- 0: 低リスク - oneWayHash関数はcryptoモジュールの標準APIを使用しており、テストの再現性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] UT-TEL-001〜007: getAnonymousMetaの各フィールドがソースコードの実装と一致しているか
- [ ] UT-TEL-008〜013: postNextTelemetryPayloadのリトライ設定（minTimeout: 500, retries: 1, factor: 1）がテストケースに正しく反映されているか
- [ ] UT-TEL-021〜027: Telemetryコンストラクタとnotifyメソッドの条件分岐が網羅されているか
- [ ] UT-TEL-033〜038: isDisabledとisEnabledの判定条件が相互に矛盾していないか
- [ ] UT-TEL-042〜045: oneWayHashのソルト付与とSHA-256ダイジェスト生成のテスト観点が十分か
- [ ] UT-TEL-056〜060: flushDetachedのファイルI/Oとプロセス起動のテスト観点が現実的か
- [ ] UT-TEL-073〜077: REGEXP_DIRECTORY_DUNDER, REGEXP_DIRECTORY_TESTS, REGEXP_FILE_TESTの正規表現パターンテストが適切か
- [ ] UT-TEL-100〜106: eventCliSessionの多数のconfigフィールドのマッピングが正確か
- [ ] UT-TEL-112〜115: eventSwcLoadFailureの環境依存処理のテスト実現可能性を確認
