---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 88
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：next-src-trace 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：88 / 93、根拠なし：5
- 優先レビュー（高）
  1. **UT-TRC-010（durationがMAX_SAFE_INTEGER超過時のエラー）**：実際に発生させるテスト条件の構成が推測
  2. **UT-TRC-013（RECORD_SPAN_THRESHOLD_MSフィルタリング）**：環境変数によるフィルタ動作の実行時挙動は推測
  3. **UT-TRC-063（ENOENT以外のローテーションエラー）**：fs.unlinkSyncのモック条件が推測
  4. **UT-TRC-064（バックプレッシャー制御のdrain待ち）**：drainイベントのタイミング検証が推測
  5. **UT-TRC-073/074（サイズリミットの検証）**：内部RotatingWriteStreamのプロパティへの直接アクセスが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/trace/trace.ts` - Spanクラス、trace関数、exportTraceState、initializeTraceState、getTraceEvents、recordTraceEvents、clearTraceEvents
- E-02: `packages/next/src/trace/shared.ts` - setGlobal、traceGlobals、traceId
- E-03: `packages/next/src/trace/types.ts` - SpanId型、TraceState型、TraceEvent型
- E-04: `packages/next/src/trace/report/index.ts` - MultiReporterクラス、reporterインスタンス
- E-05: `packages/next/src/trace/report/to-telemetry.ts` - reportToTelemetry、TRACE_EVENT_ACCESSLIST
- E-06: `packages/next/src/trace/report/to-json.ts` - batcher関数、RotatingWriteStreamクラス、reportToJson関数
- E-07: `packages/next/src/trace/report/to-json-build.ts` - reportToJsonBuild関数、allowlistedEvents
- E-08: `packages/next/src/trace/upload-trace.ts` - uploadTrace関数
- E-09: `packages/next/src/trace/trace-uploader.ts` - upload IIFE、DEV_ALLOWED_EVENTS、BUILD_ALLOWED_EVENTS
- E-10: `packages/next/src/trace/trace.test.ts` - 既存テスト（Span生成、Worker状態管理）
- E-11: `packages/next/src/trace/report/index.test.ts` - 既存テスト（JSONレポーター、テレメトリレポーター）
- E-12: `packages/next/src/trace/index.ts` - エクスポートモジュール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-TRC-001: Span constructorで名前・status・idが正しく設定される | E-01 (trace.ts L29-64) | ○ |
| C-02 | UT-TRC-002: parentId指定でSpanが生成される | E-01 (trace.ts L52) | ○ |
| C-03 | UT-TRC-003: attrs指定で属性がコピーされる | E-01 (trace.ts L53) | ○ |
| C-04 | UT-TRC-004: startTime指定で_startが設定される | E-01 (trace.ts L57) | ○ |
| C-05 | UT-TRC-005: attrs未指定で空オブジェクト | E-01 (trace.ts L53) | ○ |
| C-06 | UT-TRC-006: defaultParentSpanIdが使われる | E-01 (trace.ts L52, L168-172) | ○ |
| C-07 | UT-TRC-007: stop()でStatusがStoppedになりreportされる | E-01 (trace.ts L70-98) | ○ |
| C-08 | UT-TRC-008: stopTime指定でduration計算 | E-01 (trace.ts L76-77) | ○ |
| C-09 | UT-TRC-009: 二重stop防止 | E-01 (trace.ts L71-75) | ○ |
| C-10 | UT-TRC-010: MAX_SAFE_INTEGER超過エラー | E-01 (trace.ts L79-81) | △ |
| C-11 | UT-TRC-011: shouldSaveTraceEventsがtrueで保存 | E-01 (trace.ts L94-96) | ○ |
| C-12 | UT-TRC-012: shouldSaveTraceEvents=falseで保存スキップ | E-01 (trace.ts L94-96) | ○ |
| C-13 | UT-TRC-013: RECORD_SPAN_THRESHOLD_MSフィルタ | E-01 (trace.ts L15-17, L92) | △ |
| C-14 | UT-TRC-014: traceChildで親IDが設定される | E-01 (trace.ts L100-102), E-10 | ○ |
| C-15 | UT-TRC-015: traceChildに属性指定 | E-01 (trace.ts L100-102) | ○ |
| C-16 | UT-TRC-016: manualTraceChildの手動時間指定 | E-01 (trace.ts L104-122) | ○ |
| C-17 | UT-TRC-017: manualTraceChildのデフォルトタイミング | E-01 (trace.ts L119-121) | ○ |
| C-18 | UT-TRC-018: getIdでID返却 | E-01 (trace.ts L124-126), E-10 | ○ |
| C-19 | UT-TRC-019: setAttributeで属性設定 | E-01 (trace.ts L128-130) | ○ |
| C-20 | UT-TRC-020: setAttribute上書き | E-01 (trace.ts L128-130) | ○ |
| C-21 | UT-TRC-021: traceFnで同期関数実行・stop | E-01 (trace.ts L132-138), E-10 | ○ |
| C-22 | UT-TRC-022: traceFn例外時もstop | E-01 (trace.ts L132-138 finally) | ○ |
| C-23 | UT-TRC-023: traceAsyncFnで非同期関数実行・stop | E-01 (trace.ts L140-146), E-10 | ○ |
| C-24 | UT-TRC-024: traceAsyncFn reject時もstop | E-01 (trace.ts L140-146 finally) | ○ |
| C-25 | UT-TRC-025: trace関数でSpan生成 | E-01 (trace.ts L149-155), E-10 | ○ |
| C-26 | UT-TRC-026: trace関数の省略パラメータ | E-01 (trace.ts L149-155) | ○ |
| C-27 | UT-TRC-027: flushAllTracesでreporter.flushAll呼び出し | E-01 (trace.ts L157-158) | ○ |
| C-28 | UT-TRC-028: flushAllTracesにendオプション | E-01 (trace.ts L157-158) | ○ |
| C-29 | UT-TRC-029: exportTraceStateで状態エクスポート | E-01 (trace.ts L163-167), E-10 | ○ |
| C-30 | UT-TRC-030: initializeTraceStateで状態初期化 | E-01 (trace.ts L168-172), E-10 | ○ |
| C-31 | UT-TRC-031: getTraceEventsで保存イベント返却 | E-01 (trace.ts L174-176), E-10 | ○ |
| C-32 | UT-TRC-032: getTraceEventsで空配列 | E-01 (trace.ts L174-176) | ○ |
| C-33 | UT-TRC-033: recordTraceEventsでイベント記録 | E-01 (trace.ts L178-188), E-10 | ○ |
| C-34 | UT-TRC-034: recordTraceEventsで保存 | E-01 (trace.ts L185-187) | ○ |
| C-35 | UT-TRC-035: recordTraceEventsで空配列 | E-01 (trace.ts L178-188) | ○ |
| C-36 | UT-TRC-036: recordTraceEventsでcount更新 | E-01 (trace.ts L181-183), E-10 | ○ |
| C-37 | UT-TRC-037: clearTraceEventsでクリア | E-01 (trace.ts L190), E-10 | ○ |
| C-38 | UT-TRC-038: setGlobalで値設定 | E-02 (shared.ts L11-13), E-11 | ○ |
| C-39 | UT-TRC-039: setGlobalで上書き | E-02 (shared.ts L11-13) | ○ |
| C-40 | UT-TRC-040: traceGlobalsのMap初期化 | E-02 (shared.ts L3-8) | ○ |
| C-41 | UT-TRC-041: TRACE_ID環境変数 | E-02 (shared.ts L15-18) | ○ |
| C-42 | UT-TRC-042: NEXT_PRIVATE_TRACE_ID環境変数 | E-02 (shared.ts L15-18) | ○ |
| C-43 | UT-TRC-043: ランダムhex生成 | E-02 (shared.ts L15-18) | ○ |
| C-44 | UT-TRC-044: MultiReporter初期化 | E-04 (report/index.ts L7-11) | ○ |
| C-45 | UT-TRC-045: MultiReporter.reportで全Reporter呼び出し | E-04 (report/index.ts L18-20) | ○ |
| C-46 | UT-TRC-046: MultiReporter.flushAllで全Reporter呼び出し | E-04 (report/index.ts L14-16) | ○ |
| C-47 | UT-TRC-047: flushAllにendオプション伝搬 | E-04 (report/index.ts L14-16) | ○ |
| C-48 | UT-TRC-048: telemetry許可リストイベント記録 | E-05 (to-telemetry.ts L5-27), E-11 | ○ |
| C-49 | UT-TRC-049: telemetry非許可イベント無視 | E-05 (to-telemetry.ts L12-14), E-11 | ○ |
| C-50 | UT-TRC-050: telemetry未設定で早期リターン | E-05 (to-telemetry.ts L16-18) | ○ |
| C-51 | UT-TRC-051: flushAllが空関数 | E-05 (to-telemetry.ts L30) | ○ |
| C-52 | UT-TRC-052: batcher初期化 | E-06 (to-json.ts L8-32) | ○ |
| C-53 | UT-TRC-053: batcher.reportでイベント蓄積 | E-06 (to-json.ts L20-21) | ○ |
| C-54 | UT-TRC-054: 100件超過でreportEvents発火 | E-06 (to-json.ts L23-28) | ○ |
| C-55 | UT-TRC-055: 100件ちょうどで未発火 | E-06 (to-json.ts L23) | ○ |
| C-56 | UT-TRC-056: flushAllで残存フラッシュ | E-06 (to-json.ts L13-18) | ○ |
| C-57 | UT-TRC-057: 空フラッシュ | E-06 (to-json.ts L15-17) | ○ |
| C-58 | UT-TRC-058: キュー待ち合わせ | E-06 (to-json.ts L14) | ○ |
| C-59 | UT-TRC-059: RotatingWriteStream初期化 | E-06 (to-json.ts L41-53) | ○ |
| C-60 | UT-TRC-060: write書き込みとsize更新 | E-06 (to-json.ts L72-91) | ○ |
| C-61 | UT-TRC-061: ファイルローテーション | E-06 (to-json.ts L58-71, 75-78) | ○ |
| C-62 | UT-TRC-062: ENOENT許容 | E-06 (to-json.ts L62-66) | ○ |
| C-63 | UT-TRC-063: ENOENT以外エラースロー | E-06 (to-json.ts L64-66) | △ |
| C-64 | UT-TRC-064: バックプレッシャー制御 | E-06 (to-json.ts L80-90) | △ |
| C-65 | UT-TRC-065: end()でストリーム終了 | E-06 (to-json.ts L93-97) | ○ |
| C-66 | UT-TRC-066: reportToJsonで正常報告 | E-06 (to-json.ts L100-131), E-11 | ○ |
| C-67 | UT-TRC-067: distDir未設定で早期リターン | E-06 (to-json.ts L101-105) | ○ |
| C-68 | UT-TRC-068: phase未設定で早期リターン | E-06 (to-json.ts L103-105) | ○ |
| C-69 | UT-TRC-069: 本番flushAll | E-06 (to-json.ts L133-145) | ○ |
| C-70 | UT-TRC-070: 開発モードflushAll | E-06 (to-json.ts L139) | ○ |
| C-71 | UT-TRC-071: end=trueで強制終了 | E-06 (to-json.ts L139) | ○ |
| C-72 | UT-TRC-072: batch未初期化でundefined | E-06 (to-json.ts L135-143) | ○ |
| C-73 | UT-TRC-073: 開発モードで50MBサイズ制限 | E-06 (to-json.ts L115) | △ |
| C-74 | UT-TRC-074: 本番モードでInfinity | E-06 (to-json.ts L115) | ○ |
| C-75 | UT-TRC-075: ビルドトレース許可イベント報告 | E-07 (to-json-build.ts L77-91, L92-132) | ○ |
| C-76 | UT-TRC-076: ビルドトレース非許可イベント無視 | E-07 (to-json-build.ts L93-95) | ○ |
| C-77 | UT-TRC-077: ビルドトレースdistDir未設定 | E-07 (to-json-build.ts L97-101) | ○ |
| C-78 | UT-TRC-078: ビルドトレースphase未設定 | E-07 (to-json-build.ts L99-101) | ○ |
| C-79 | UT-TRC-079: 開発モードでビルドトレース無効 | E-07 (to-json-build.ts L104-106) | ○ |
| C-80 | UT-TRC-080: 許可リスト全件テスト | E-07 (to-json-build.ts L77-90) | ○ |
| C-81 | UT-TRC-081: ビルドトレースflushAll | E-07 (to-json-build.ts L134-145) | ○ |
| C-82 | UT-TRC-082: ビルドトレースbatch未初期化 | E-07 (to-json-build.ts L135-144) | ○ |
| C-83 | UT-TRC-083: uploadTraceのspawn呼び出し | E-08 (upload-trace.ts L4-58) | ○ |
| C-84 | UT-TRC-084: デバッグモードでspawnSync | E-08 (upload-trace.ts L29-32) | ○ |
| C-85 | UT-TRC-085: sync=trueでspawnSync | E-08 (upload-trace.ts L30-32) | ○ |
| C-86 | UT-TRC-086: isTurboSessionのString変換 | E-08 (upload-trace.ts L42) | ○ |
| C-87 | UT-TRC-087: detached=trueデフォルト | E-08 (upload-trace.ts L48) | ○ |
| C-88 | UT-TRC-088: TraceEvent構造検証 | E-01 (trace.ts L83-91) | ○ |
| C-89 | UT-TRC-089: traceFnでSpan自身渡し | E-01 (trace.ts L132-138) | ○ |
| C-90 | UT-TRC-090: traceAsyncFnでSpan自身渡し | E-01 (trace.ts L140-146) | ○ |
| C-91 | UT-TRC-091: ID連番 | E-01 (trace.ts L7-10), E-10 | ○ |
| C-92 | UT-TRC-092: duration マイクロ秒計算 | E-01 (trace.ts L77) | ○ |
| C-93 | UT-TRC-093: timestamp マイクロ秒計算 | E-01 (trace.ts L82) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-10 (UT-TRC-010)**: `Number.MAX_SAFE_INTEGER`を超えるdurationを発生させる具体的なテスト条件は、実行環境でのhrtimeの挙動に依存するため推測を含む
  - 候補：BigInt値のモック / 極端なstartTime指定
- **C-13 (UT-TRC-013)**: `NEXT_TRACE_SPAN_THRESHOLD_MS`環境変数によるフィルタリングの具体的挙動はテスト実行時の環境設定に依存
  - 候補：環境変数モック / jest.spyOn(process.env)
- **C-63 (UT-TRC-063)**: `fs.unlinkSync`がENOENT以外のエラーを返すケースのモック方法は推測
  - 候補：jest.spyOn(fs, 'unlinkSync') / fs-extra mock
- **C-64 (UT-TRC-064)**: WriteStreamのバックプレッシャー（drainイベント）のテスト方法は推測
  - 候補：writeStream.writeのモック / stream mock
- **C-73 (UT-TRC-073)**: RotatingWriteStreamのsizeLimitプロパティがprivateではないが内部実装へのアクセスが必要
  - 候補：RotatingWriteStreamをエクスポートしてテスト / 書き込み量から間接検証

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): Spanクラスの基本操作（constructor, stop, traceChild, getId, setAttribute, traceFn, traceAsyncFn）は既存テスト(E-10)で確認済み部分が多い
- 0 (低リスク): MultiReporter、reportToTelemetryは既存テスト(E-11)と整合
- 1 (中リスク): RotatingWriteStreamのローテーション・バックプレッシャー系テストはファイルシステムモックが必要
- 1 (中リスク): uploadTrace関数はchild_processモックが必要で、実行環境依存度が高い
- 0 (低リスク): trace-uploader.ts（IIFEのupload関数）はテストケース一覧の対象外とした（プロセスとして直接実行されるスクリプトのため単体テストの対象外）

## 6) レビュアーチェックリスト（最小）
- [ ] Spanクラスのテストケース（UT-TRC-001〜UT-TRC-024）がconstructor, stop, traceChild, manualTraceChild, getId, setAttribute, traceFn, traceAsyncFnの全publicメソッドを網羅しているか
- [ ] 既存テスト（trace.test.ts, report/index.test.ts）と重複するテストケースが矛盾していないか
- [ ] RotatingWriteStreamのローテーション条件（sizeLimit超過）のテスト方針が妥当か
- [ ] batcher関数の100件閾値テスト（UT-TRC-054, UT-TRC-055）の境界値が正しいか
- [ ] uploadTrace関数のテスト（UT-TRC-083〜087）がchild_processの呼び出し検証として十分か
- [ ] trace-uploader.ts（IIFE）を単体テスト対象外とした判断が妥当か（統合テスト/E2Eで別途カバーする想定）
- [ ] RECORD_SPAN_THRESHOLD_MS環境変数によるフィルタリングテスト（UT-TRC-013）のテスト方法が実現可能か
