---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：third-parties 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **C-53 (UT-THP-053)**：TPCYouTubeEmbedの戻り値がscripts=[]の場合の挙動はソースコードのoptional chaining (`scripts?.map`) から推測だが、third-party-capitalの実装は未確認
  2. **C-59 (UT-THP-059)**：GTMParamsの型定義上 gtmId と gtmScriptUrl の両方が未指定のケースは TypeScript の union 型で防がれるが、ランタイムでの挙動は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/third-parties/src/ThirdPartyScriptEmbed.tsx` - ThirdPartyScriptEmbedコンポーネント定義
- E-02: `packages/third-parties/src/google/ga.tsx` - GoogleAnalyticsコンポーネント・sendGAEvent関数定義
- E-03: `packages/third-parties/src/google/gtm.tsx` - GoogleTagManagerコンポーネント・sendGTMEvent関数定義
- E-04: `packages/third-parties/src/google/google-maps-embed.tsx` - GoogleMapsEmbedコンポーネント定義
- E-05: `packages/third-parties/src/google/youtube-embed.tsx` - YouTubeEmbedコンポーネント・scriptStrategy定義
- E-06: `packages/third-parties/src/google/index.tsx` - 再エクスポート定義
- E-07: `packages/third-parties/src/types/google.ts` - 型定義（GTMParams, GAParams, GoogleMapsEmbed, YouTubeEmbed）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThirdPartyScriptEmbed: htmlが指定された場合にdangerouslySetInnerHTMLでレンダリング | E-01 (L38-47: html条件分岐とdangerouslySetInnerHTML) | ○ |
| C-02 | ThirdPartyScriptEmbed: height/widthが指定された場合のスタイル設定 | E-01 (L41-42: style計算ロジック) | ○ |
| C-03 | ThirdPartyScriptEmbed: height/widthがnullの場合auto設定 | E-01 (L41-42: 三項演算子でnull判定) | ○ |
| C-04 | ThirdPartyScriptEmbed: childrenがレンダリングされること | E-01 (L36: {children}) | ○ |
| C-05 | ThirdPartyScriptEmbed: dataNtpc属性設定 | E-01 (L44: data-ntpc={dataNtpc}) | ○ |
| C-06 | ThirdPartyScriptEmbed: dataNtpc指定時のperformance.mark呼び出し | E-01 (L21-30: useEffect内のperformance.mark) | ○ |
| C-07 | ThirdPartyScriptEmbed: html=null時にdivが非表示 | E-01 (L38: html ? ... : null) | ○ |
| C-08 | ThirdPartyScriptEmbed: html=undefined時にdivが非表示 | E-01 (L38: falsyチェック) | ○ |
| C-09 | ThirdPartyScriptEmbed: dataNtpc空文字時のperformance.mark抑制 | E-01 (L21: if (dataNtpc)で空文字はfalsy) | ○ |
| C-10 | ThirdPartyScriptEmbed: height=0時のスタイル | E-01 (L41: height != null判定で0はnullでない) | ○ |
| C-11 | GoogleAnalytics: GA初期化スクリプトレンダリング | E-02 (L38-49: Script id='_next-ga-init') | ○ |
| C-12 | GoogleAnalytics: gtag.jsスクリプトレンダリング | E-02 (L50-54: Script id='_next-ga' src=gtag URL) | ○ |
| C-13 | GoogleAnalytics: debugMode=true時のdebug_mode設定 | E-02 (L46: 三項演算子でdebugMode判定) | ○ |
| C-14 | GoogleAnalytics: debugMode=false時のdebug_mode非設定 | E-02 (L46: debugModeがfalsyの場合空文字) | ○ |
| C-15 | GoogleAnalytics: カスタムdataLayerName | E-02 (L42-43: window[dataLayerName]参照) | ○ |
| C-16 | GoogleAnalytics: nonce属性設定 | E-02 (L48, L53: nonce={nonce}) | ○ |
| C-17 | GoogleAnalytics: performance.mark呼び出し | E-02 (L29-33: performance.mark with 'next-third-parties-ga') | ○ |
| C-18 | GoogleAnalytics: デフォルトdataLayerName | E-02 (L17: dataLayerName = 'dataLayer') | ○ |
| C-19 | sendGAEvent: dataLayerへのpush | E-02 (L65-66: window[currDataLayerName].push(arguments)) | ○ |
| C-20 | sendGAEvent: 未初期化時のconsole.warn | E-02 (L60-62: currDataLayerName === undefined判定) | ○ |
| C-21 | sendGAEvent: dataLayer不在時のconsole.warn | E-02 (L67-70: else句のconsole.warn) | ○ |
| C-22 | GoogleTagManager: GTM初期化スクリプトレンダリング | E-03 (L55-65: Script id='_next-gtm-init') | ○ |
| C-23 | GoogleTagManager: gtm.js URL生成 | E-03 (L23-27: new URL + searchParams.set('id', gtmId)) | ○ |
| C-24 | GoogleTagManager: カスタムgtmScriptUrl | E-03 (L23-24: gtmScriptUrl || デフォルトURL) | ○ |
| C-25 | GoogleTagManager: auth パラメータ付与 | E-03 (L33-34: searchParams.set('gtm_auth', auth)) | ○ |
| C-26 | GoogleTagManager: preview パラメータ付与 | E-03 (L36-38: gtm_preview + gtm_cookies_win) | ○ |
| C-27 | GoogleTagManager: カスタムdataLayerNameのURL反映 | E-03 (L29-31: searchParams.set('l', dataLayerName)) | ○ |
| C-28 | GoogleTagManager: デフォルトdataLayerでlパラメータ除外 | E-03 (L29: dataLayerName !== 'dataLayer'条件) | ○ |
| C-29 | GoogleTagManager: dataLayerオブジェクトのpush | E-03 (L62: JSON.stringify(dataLayer)でpush) | ○ |
| C-30 | GoogleTagManager: dataLayer未指定時のpush非実行 | E-03 (L62: dataLayer三項演算子でfalsyは空文字) | ○ |
| C-31 | GoogleTagManager: nonce属性設定 | E-03 (L65, L71: nonce={nonce}) | ○ |
| C-32 | GoogleTagManager: performance.mark呼び出し | E-03 (L46-50: performance.mark with 'next-third-parties-gtm') | ○ |
| C-33 | GoogleTagManager: data-ntpc='GTM'設定 | E-03 (L69: data-ntpc="GTM") | ○ |
| C-34 | sendGTMEvent: デフォルトdataLayerNameでのpush | E-03 (L77-82: currDataLayerName使用) | ○ |
| C-35 | sendGTMEvent: カスタムdataLayerNameでのpush | E-03 (L79: dataLayerName || currDataLayerName) | ○ |
| C-36 | sendGTMEvent: dataLayer未定義時の自動初期化 | E-03 (L81: window[dataLayer] = window[dataLayer] || []) | ○ |
| C-37 | GoogleMapsEmbed: ThirdPartyScriptEmbedレンダリング | E-04 (L12-18: ThirdPartyScriptEmbed使用) | ○ |
| C-38 | GoogleMapsEmbed: apiKeyからkeyへの変換 | E-04 (L7-8: destructuring + key: apiKey) | ○ |
| C-39 | GoogleMapsEmbed: height/widthの伝搬 | E-04 (L13-14: formattedProps.height || null) | ○ |
| C-40 | GoogleMapsEmbed: height/width未指定時のnull | E-04 (L13-14: || null でfalsyはnull) | ○ |
| C-41 | GoogleMapsEmbed: dataNtpc設定 | E-04 (L16: dataNtpc="GoogleMapsEmbed") | ○ |
| C-42 | YouTubeEmbed: ThirdPartyScriptEmbedレンダリング | E-05 (L20-34: ThirdPartyScriptEmbed使用) | ○ |
| C-43 | YouTubeEmbed: html伝搬 | E-05 (L17: TPCYouTubeEmbed戻り値, L23: html={html}) | ○ |
| C-44 | YouTubeEmbed: Script要素レンダリング | E-05 (L26-33: scripts?.map) | ○ |
| C-45 | YouTubeEmbed: strategy変換(server->beforeInteractive) | E-05 (L10: scriptStrategy.server = 'beforeInteractive') | ○ |
| C-46 | YouTubeEmbed: strategy変換(client->afterInteractive) | E-05 (L11: scriptStrategy.client = 'afterInteractive') | ○ |
| C-47 | YouTubeEmbed: strategy変換(idle->lazyOnload) | E-05 (L12: scriptStrategy.idle = 'lazyOnload') | ○ |
| C-48 | YouTubeEmbed: strategy変換(worker->worker) | E-05 (L13: scriptStrategy.worker = 'worker') | ○ |
| C-49 | YouTubeEmbed: height/width伝搬 | E-05 (L21-22: props.height || null, props.width || null) | ○ |
| C-50 | YouTubeEmbed: height/width未指定時のnull | E-05 (L21-22: || null) | ○ |
| C-51 | YouTubeEmbed: dataNtpc設定 | E-05 (L24: dataNtpc="YouTubeEmbed") | ○ |
| C-52 | YouTubeEmbed: stylesheets伝搬 | E-05 (L31: stylesheets={stylesheets}) | ○ |
| C-53 | YouTubeEmbed: scripts空配列時の挙動 | E-05 (L26: scripts?.map) | △ |
| C-54 | YouTubeEmbed: scripts undefined時の挙動 | E-05 (L26: scripts?.map - optional chaining) | ○ |
| C-55 | index.tsx: GoogleMapsEmbedエクスポート | E-06 (L1: export { default as GoogleMapsEmbed }) | ○ |
| C-56 | index.tsx: YouTubeEmbedエクスポート | E-06 (L2: export { default as YouTubeEmbed }) | ○ |
| C-57 | index.tsx: GoogleTagManager/sendGTMEventエクスポート | E-06 (L3: export { GoogleTagManager, sendGTMEvent }) | ○ |
| C-58 | index.tsx: GoogleAnalytics/sendGAEventエクスポート | E-06 (L4: export { GoogleAnalytics, sendGAEvent }) | ○ |
| C-59 | GoogleTagManager: gtmId/gtmScriptUrl両方未指定時の挙動 | E-07 (L23-31: GTMParams union型), E-03 (L23-28) | △ |
| C-60 | GoogleTagManager: gtmScriptUrlのみ指定時の挙動 | E-03 (L23-24: gtmScriptUrl || デフォルト, L26-28: gtmId条件) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-53**: `scripts?.map([])` は空配列に対してmap実行で空のJSX配列を返すが、third-party-capitalライブラリの実際の戻り値パターンが未確認のため、空配列が返される場面が実在するか不明
  - 候補: third-party-capitalライブラリのソースコード / third-party-capitalのテスト / third-party-capitalのドキュメント
- **C-59**: TypeScriptの型定義（GTMParams union型）では `gtmId` か `gtmScriptUrl` のどちらかが必須だが、JavaScript実行時に両方undefinedが渡された場合のランタイムエラーハンドリングは実装に含まれていない
  - 候補: ランタイムバリデーションの実装 / Next.js公式ドキュメントの利用ガイドライン

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - third-partiesモジュールは比較的小規模（7ファイル）で、各コンポーネントのロジックは明確。テストケースはソースコードの条件分岐・props処理を直接的にカバーしている。
- **1: 中リスク** - third-party-capitalライブラリへの依存部分（GoogleMapsEmbed, YouTubeEmbed）は外部ライブラリのモックが必要であり、モックの正確性がテストの信頼性に影響する。
- **0: 低リスク** - sendGAEvent/sendGTMEventのグローバル状態（currDataLayerName, window.dataLayer）管理はテスト間の分離が重要だが、ロジック自体は単純。

## 6) レビュアーチェックリスト（最小）
- [ ] ThirdPartyScriptEmbedのdangerouslySetInnerHTMLに対するXSSリスクのテストケースが十分か確認
- [ ] sendGAEvent/sendGTMEventのグローバル状態管理テストで、テスト間の状態リセットが考慮されているか確認
- [ ] third-party-capitalライブラリのモック戦略が適切か確認（GoogleMapsEmbed, YouTubeEmbed）
- [ ] GTMParamsのunion型（gtmId | gtmScriptUrl）の境界ケースが網羅されているか確認
- [ ] performance.markのモック方法がテストフレームワークに適合するか確認
