---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 70
  claims_with_evidence: 58
  claims_without_evidence: 12
confidence_derived: 0.83
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された受入テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・設定ファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：58 / 70、根拠なし：12
- 優先レビュー（高）
  1. **UAT-042（画像の遅延読み込み）**：image-component.tsxのソースコードから推定したが、専用E2Eテストの直接確認なし
  2. **UAT-062（Server Componentでの機密情報隠蔽）**：server-onlyパッケージの統合に関する専用テストの確認が不十分
  3. **UAT-066（環境変数）**：@next/envパッケージの参照のみで、具体的なE2Eテストの確認なし
  4. **UAT-069（スタンドアロンモード）**：設定項目から推定したが、専用E2Eテストの直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/create-next-app/create-app.ts` - create-next-appの実装
- E-02: `packages/next/src/cli/next-dev.ts` - next devコマンドのエントリポイント
- E-03: `packages/next/src/cli/next-build.ts` - next buildコマンドのエントリポイント
- E-04: `packages/next/src/cli/next-start.ts` - next startコマンドのエントリポイント
- E-05: `test/e2e/app-dir/app-rendering/rendering.test.ts` - App Routerレンダリングテスト
- E-06: `test/e2e/app-dir/navigation/navigation.test.ts` - ナビゲーションテスト
- E-07: `test/e2e/app-dir/app-prefetch/prefetching.test.ts` - プリフェッチテスト
- E-08: `test/e2e/app-dir/actions/app-action.test.ts` - Server Actionsテスト
- E-09: `test/e2e/app-dir/actions/app-action-progressive-enhancement.test.ts` - プログレッシブエンハンスメントテスト
- E-10: `test/e2e/app-dir/errors/index.test.ts` - エラーハンドリングテスト
- E-11: `test/e2e/app-dir/global-error/basic/index.test.ts` - グローバルエラーテスト
- E-12: `test/e2e/app-dir/not-found/basic/index.test.ts` - Not Foundテスト
- E-13: `test/e2e/app-dir/metadata/metadata.test.ts` - メタデータテスト
- E-14: `test/e2e/middleware-redirects/test/index.test.ts` - ミドルウェアリダイレクトテスト
- E-15: `test/e2e/middleware-rewrites/test/index.test.ts` - ミドルウェアリライトテスト
- E-16: `test/e2e/middleware-matcher/index.test.ts` - ミドルウェアマッチャーテスト
- E-17: `test/e2e/app-dir/app-routes/app-custom-routes.test.ts` - APIルートテスト
- E-18: `test/e2e/app-dir/dynamic/dynamic.test.ts` - 動的ルーティング/next/dynamicテスト
- E-19: `test/e2e/app-dir/app-static/app-static.test.ts` - 静的生成テスト
- E-20: `test/e2e/app-dir/app-css/index.test.ts` - CSSサポートテスト
- E-21: `test/e2e/app-dir/parallel-routes-and-interception/` - パラレル/インターセプトルートテスト
- E-22: `packages/next/src/client/image-component.tsx` - next/imageコンポーネント実装
- E-23: `packages/next/src/server/image-optimizer.ts` - 画像最適化サーバー実装
- E-24: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF保護実装
- E-25: `packages/next/src/client/components/app-router-announcer.tsx` - ルーターアナウンサー実装
- E-26: `test/e2e/middleware-general/test/index.test.ts` - ミドルウェア全般テスト
- E-27: `test/e2e/app-dir/back-forward-cache/` - 戻る/進むキャッシュテスト
- E-28: `test/e2e/app-dir/chunk-loading/` - チャンクローディングテスト
- E-29: `test/development/app-hmr/` - HMRテスト
- E-30: `test/development/client-dev-overlay/` - エラーオーバーレイテスト
- E-31: `test/e2e/middleware-request-header-overrides/` - リクエストヘッダーオーバーライドテスト
- E-32: `test/e2e/middleware-static-files/` - 静的ファイルミドルウェアテスト
- E-33: `test/production/build-lifecycle-hooks/` - ビルドライフサイクルフックテスト
- E-34: `test/production/bundle-size/` - バンドルサイズテスト
- E-35: `test/e2e/next-font/` - next/fontテスト
- E-36: `test/e2e/app-dir/app-edge/` - Edge Runtimeテスト
- E-37: `test/e2e/edge-api-endpoints-can-receive-body/` - Edge APIエンドポイントテスト
- E-38: `packages/next/src/export/index.ts` - Static Export実装
- E-39: `packages/next/src/telemetry/` - テレメトリ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: create-next-appによるプロジェクト作成（TypeScript + App Router） | E-01 | ○ |
| C-02 | UAT-002: create-next-appによるTailwind CSS有効プロジェクト作成 | E-01 | ○ |
| C-03 | UAT-003: create-next-appによるESLint設定付きプロジェクト作成 | E-01 | ○ |
| C-04 | UAT-004: next devコマンドによる開発サーバー起動 | E-02 | ○ |
| C-05 | UAT-005: next dev --turbopackによるTurbopack開発サーバー起動 | E-02 | ○ |
| C-06 | UAT-006: カスタムポートでの開発サーバー起動 | E-02 | ○ |
| C-07 | UAT-007: next buildによるプロダクションビルド | E-03 | ○ |
| C-08 | UAT-008: next startによるプロダクションサーバー起動 | E-04 | ○ |
| C-09 | UAT-009: Server Componentページの初期表示 | E-05 | ○ |
| C-10 | UAT-010: Client Componentページの表示とハイドレーション | E-05 | ○ |
| C-11 | UAT-011: レイアウトのネスト表示 | E-05 | ○ |
| C-12 | UAT-012: SSRデータフェッチの並列実行 | E-05 | ○ |
| C-13 | UAT-013: クエリパラメータの設定と表示 | E-06 | ○ |
| C-14 | UAT-014: Unicode検索パラメータの処理 | E-06 | ○ |
| C-15 | UAT-015: クライアントサイドナビゲーション（Link遷移） | E-06 | ○ |
| C-16 | UAT-016: ブラウザの戻る/進むボタンでのナビゲーション | E-27 | ○ |
| C-17 | UAT-017: リンクのプリフェッチによる高速ナビゲーション | E-07 | ○ |
| C-18 | UAT-018: 基本的なServer Actionの実行 | E-08 | ○ |
| C-19 | UAT-019: ミドルウェアリライトとServer Actionの連携 | E-08 | ○ |
| C-20 | UAT-020: フォーム送信によるServer Actionの実行 | E-09 | ○ |
| C-21 | UAT-021: ISRページの再検証 | E-05 | ○ |
| C-22 | UAT-022: 静的生成ページの表示 | E-19 | ○ |
| C-23 | UAT-023: 動的セグメントを使用したページ表示 | E-18 | ○ |
| C-24 | UAT-024: キャッチオールルートの表示 | **根拠なし** | △ |
| C-25 | UAT-025: クライアントコンポーネントのエラーバウンダリ表示 | E-10 | ○ |
| C-26 | UAT-026: Server Componentレンダリングエラーのハンドリング | E-10 | ○ |
| C-27 | UAT-027: Global Errorページの表示 | E-11 | ○ |
| C-28 | UAT-028: カスタム404ページの表示 | E-12 | ○ |
| C-29 | UAT-029: ページタイトルとdescriptionの設定 | E-13 | ○ |
| C-30 | UAT-030: タイトルテンプレートの適用 | E-13 | ○ |
| C-31 | UAT-031: OGPメタデータの設定 | E-13 | ○ |
| C-32 | UAT-032: リダイレクトミドルウェアの動作 | E-14 | ○ |
| C-33 | UAT-033: リライトミドルウェアの動作 | E-15 | ○ |
| C-34 | UAT-034: リクエストヘッダー変更ミドルウェアの動作 | E-31 | ○ |
| C-35 | UAT-035: GETルートハンドラの動作 | E-17 | ○ |
| C-36 | UAT-036: 動的APIルートハンドラの動作 | E-17 | ○ |
| C-37 | UAT-037: generateStaticParamsを使用したAPIルートの静的生成 | E-17 | ○ |
| C-38 | UAT-038: 動的インポートコンポーネントのSSR表示 | E-18 | ○ |
| C-39 | UAT-039: ssr: falseの動的コンポーネントのクライアントサイド表示 | E-18 | ○ |
| C-40 | UAT-040: 動的コンポーネントのローディング表示 | E-18 | ○ |
| C-41 | UAT-041: 画像コンポーネントの最適化表示 | E-22, E-23 | ○ |
| C-42 | UAT-042: 画像の遅延読み込み（Lazy Loading） | E-22 | △ |
| C-43 | UAT-043: CSS Modulesの適用 | E-20 | ○ |
| C-44 | UAT-044: クライアントサイドナビゲーション時のCSS適用 | E-20 | ○ |
| C-45 | UAT-045: パラレルルートの同時表示 | E-21 | ○ |
| C-46 | UAT-046: インターセプトルートによるモーダル表示 | E-21 | ○ |
| C-47 | UAT-047: ロケールベースのルーティング | **根拠なし** | △ |
| C-48 | UAT-048: Google Fontsの最適化読み込み | E-35 | ○ |
| C-49 | UAT-049: Static Export | E-38 | ○ |
| C-50 | UAT-050: Edge Runtimeでのページレンダリング | E-36 | ○ |
| C-51 | UAT-051: Edge RuntimeでのAPIルートハンドラ | E-37 | ○ |
| C-52 | UAT-052: カスタムマッチャーによるミドルウェア適用範囲制御 | E-16 | ○ |
| C-53 | UAT-053: loading.tsxによるローディング状態表示 | **根拠なし** | △ |
| C-54 | UAT-054: React Suspenseによるストリーミングレンダリング | **根拠なし** | △ |
| C-55 | UAT-055: カスタムキャッシュハンドラの動作 | **根拠なし** | △ |
| C-56 | UAT-056: basePath設定でのページアクセス | **根拠なし** | △ |
| C-57 | UAT-057: HMRによる即時更新 | E-29 | ○ |
| C-58 | UAT-058: 開発モードでのエラーオーバーレイ表示 | E-30 | ○ |
| C-59 | UAT-059: TypeScriptの型チェック | **根拠なし** | △ |
| C-60 | UAT-060: next lintコマンドの実行 | **根拠なし** | △ |
| C-61 | UAT-061: CSRF保護の動作確認 | E-24 | ○ |
| C-62 | UAT-062: Server Componentでの機密情報隠蔽 | **根拠なし** | △ |
| C-63 | UAT-063: ページバンドルサイズの最適化 | E-34 | ○ |
| C-64 | UAT-064: コード分割の動作確認 | E-28 | ○ |
| C-65 | UAT-065: ルート遷移時のアナウンス | E-25 | ○ |
| C-66 | UAT-066: NEXT_PUBLIC_プレフィックスによるクライアント環境変数 | **根拠なし** | △ |
| C-67 | UAT-067: publicディレクトリからの静的ファイル配信 | E-32 | ○ |
| C-68 | UAT-068: ビルドライフサイクルフックの実行 | E-33 | ○ |
| C-69 | UAT-069: スタンドアロンモードでのデプロイ | **根拠なし** | △ |
| C-70 | UAT-070: テレメトリの無効化 | E-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- UAT-024（キャッチオールルート）：`test/e2e/app-dir/app-catch-all-optional`ディレクトリの存在は確認したが、テストファイルの内容を直接検証していない
  - 候補：`test/e2e/app-dir/app-catch-all-optional/` / App Router公式ドキュメント
- UAT-042（画像の遅延読み込み）：`image-component.tsx`のソースコードから遅延読み込み機能の実装を推定したが、専用のE2Eテストファイルを確認していない
  - 候補：`test/e2e/next-image-forward-ref/` / next/image関連テスト
- UAT-047（i18n）：`test/e2e/i18n-preferred-locale-detection`の存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/e2e/i18n-*` テストディレクトリ群
- UAT-053（Loading UI）：`test/e2e/app-dir/app-prefetch-false-loading`のディレクトリ存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/e2e/app-dir/app-prefetch-false-loading/` / `test/e2e/app-dir/searchparams-reuse-loading/`
- UAT-054（ストリーミング）：`test/e2e/app-dir/actions-streaming`のディレクトリ存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/e2e/app-dir/actions-streaming/` / `test/e2e/app-dir/metadata-streaming/`
- UAT-055（カスタムキャッシュハンドラ）：`test/e2e/app-dir/app-custom-cache-handler`のディレクトリ存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/e2e/app-dir/app-custom-cache-handler/`
- UAT-056（basePath）：`test/e2e/basepath`および`test/e2e/app-dir/app-basepath`のディレクトリ存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/e2e/basepath/` / `test/e2e/app-dir/app-basepath/`
- UAT-059（TypeScript型チェック）：`test/production/ci-missing-typescript-deps`のディレクトリ存在は確認したが、テスト内容を直接検証していない
  - 候補：`test/production/ci-missing-typescript-deps/` / TypeScript関連テスト
- UAT-060（ESLint統合）：`packages/eslint-plugin-next`の存在は確認したが、統合テストの内容を確認していない
  - 候補：`packages/eslint-plugin-next/` / ESLint関連テスト
- UAT-062（機密情報隠蔽）：server-onlyパッケージの使用はactions テストで確認（依存関係）したが、専用テストの確認なし
  - 候補：サーバー/クライアント境界に関するテスト
- UAT-066（環境変数）：@next/envパッケージの参照を確認したが、専用のE2Eテストの確認なし
  - 候補：`test/e2e/` 配下の環境変数関連テスト / `test/development/dotenv-default-expansion/`
- UAT-069（スタンドアロンモード）：output: 'standalone'設定は広く知られた機能だが、専用テストの直接確認なし
  - 候補：`test/production/` 配下のstandalone関連テスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：C-01〜C-23, C-25〜C-41, C-43〜C-46, C-48〜C-52, C-57〜C-58, C-61, C-63〜C-65, C-67〜C-68, C-70 - ソースコードまたはE2Eテストにより直接根拠を確認済み
- **リスク1（中リスク）**：C-24, C-42, C-47, C-53〜C-56, C-59〜C-60, C-66, C-69 - テストディレクトリやソースコードの存在は確認できるが、テスト内容の詳細を直接検証していない。テスト手順・期待結果が実際のE2Eテストと乖離している可能性がある
- **リスク2（高リスク）**：C-62 - server-onlyパッケージの統合テストに関しては、具体的なテストファイルの特定ができていない。テスト手順の妥当性を人間レビュアーが確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UAT-001〜UAT-011, UAT-018, UAT-025〜UAT-028）のテスト手順が実際の操作フローと一致しているか
- [ ] 根拠なし（△）の12件のテストケースについて、テスト手順と期待結果が実際のプロジェクト動作と整合しているか
- [ ] Server Actions（UAT-018〜UAT-020）のセキュリティ関連テストケースが十分か（CSRF以外の攻撃ベクトル）
- [ ] i18n（UAT-047）のテスト手順が実際のi18n設定と一致しているか
- [ ] パフォーマンス関連テストケース（UAT-063, UAT-064）の閾値が適切か
- [ ] Edge Runtime（UAT-050, UAT-051）のテスト手順がプロジェクトのEdge Runtime利用状況と整合しているか
- [ ] 本プロジェクト固有のビジネスロジック（フレームワークとしてのNext.js機能ではなく）に関するテストケースの追加が必要かどうか
