---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 37
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：37 / 40、根拠なし：3
- 優先レビュー（高）
  1. **C-25 (_ssgManifest.js)**：関数内のローカル変数から推測、出力パスの詳細は動的に決定
  2. **C-38 (client-build-manifest.json)**：定数定義はあるが、出力ロジックの詳細はTurbopack内部実装
  3. **C-40 (_devMiddlewareManifest.json)**：定数定義はあるが、開発サーバー内部での出力タイミングの詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/shared/lib/constants.ts` - マニフェスト定数定義
- E-02: `packages/next/src/build/index.ts` - ビルドメインロジック（writeManifest, writeFileUtf8等の呼び出し）
- E-03: `packages/next/src/build/webpack/plugins/build-manifest-plugin.ts` - BuildManifestPlugin
- E-04: `packages/next/src/build/webpack/plugins/pages-manifest-plugin.ts` - PagesManifestPlugin
- E-05: `packages/next/src/build/webpack/plugins/flight-manifest-plugin.ts` - FlightManifestPlugin（ClientReferenceManifest）
- E-06: `packages/next/src/build/webpack/plugins/next-font-manifest-plugin.ts` - NextFontManifestPlugin
- E-07: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - MiddlewarePlugin
- E-08: `packages/next/src/build/webpack/plugins/slow-module-detection-plugin.ts` - SlowModuleDetectionPlugin
- E-09: `packages/next/src/build/utils.ts` - printTreeView, printCustomRoutes関数
- E-10: `packages/next/src/build/generate-routes-manifest.ts` - generateRoutesManifest関数
- E-11: `packages/next/src/diagnostics/build-diagnostics.ts` - 診断レポート生成関数群
- E-12: `packages/next/src/trace/report/to-json-build.ts` - トレースレポート（trace-build）生成
- E-13: `packages/next/src/build/collect-build-traces.ts` - NFTトレース収集
- E-14: `packages/next/src/cli/next-info.ts` - next info診断コマンド
- E-15: `packages/next/src/build/analyze/index.ts` - バンドル解析（analyze）機能
- E-16: `packages/next/src/export/index.ts` - エクスポート機能（export-detail.json参照）
- E-17: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - Turbopackマニフェストローダー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-manifest.json: ビルド時に生成されるアセットマッピング | E-01 (BUILD_MANIFEST定数), E-03 (BuildManifestPlugin) | ○ |
| C-02 | pages-manifest.json: ページパスとファイルパスのマッピング | E-01 (PAGES_MANIFEST定数), E-04 (PagesManifestPlugin) | ○ |
| C-03 | app-paths-manifest.json: App Router用マッピング | E-01 (APP_PATHS_MANIFEST定数), E-02 (ビルドインポート) | ○ |
| C-04 | app-path-routes-manifest.json: アプリパスとルートの対応 | E-01 (APP_PATH_ROUTES_MANIFEST定数), E-02 (ビルドインポート) | ○ |
| C-05 | routes-manifest.json: ルーティング定義マニフェスト | E-01 (ROUTES_MANIFEST定数), E-10 (generateRoutesManifest関数) | ○ |
| C-06 | prerender-manifest.json: ISR/SSG事前レンダリング定義 | E-01 (PRERENDER_MANIFEST定数), E-02 (writePrerenderManifest関数) | ○ |
| C-07 | middleware-manifest.json: ミドルウェア定義 | E-01 (MIDDLEWARE_MANIFEST定数), E-07 (MiddlewarePlugin) | ○ |
| C-08 | react-loadable-manifest.json: 動的インポートチャンク情報 | E-01 (REACT_LOADABLE_MANIFEST定数), E-02 (ビルドインポート) | ○ |
| C-09 | client-reference-manifest: RSCクライアント参照 | E-01 (CLIENT_REFERENCE_MANIFEST定数), E-05 (FlightManifestPlugin) | ○ |
| C-10 | server-reference-manifest: サーバーアクション参照 | E-01 (SERVER_REFERENCE_MANIFEST定数), E-02 (ビルドインポート) | ○ |
| C-11 | next-font-manifest: フォント情報マニフェスト | E-01 (NEXT_FONT_MANIFEST定数), E-06 (NextFontManifestPlugin) | ○ |
| C-12 | subresource-integrity-manifest: SRIハッシュ情報 | E-01 (SUBRESOURCE_INTEGRITY_MANIFEST定数) | ○ |
| C-13 | images-manifest.json: 画像設定マニフェスト | E-01 (IMAGES_MANIFEST定数), E-02 (writeImagesManifest関数) | ○ |
| C-14 | functions-config-manifest.json: 関数設定マニフェスト | E-01 (FUNCTIONS_CONFIG_MANIFEST定数), E-02 (writeFunctionsConfigManifest関数) | ○ |
| C-15 | middleware-build-manifest.js: ミドルウェア用ビルドマニフェスト | E-01 (MIDDLEWARE_BUILD_MANIFEST定数) | ○ |
| C-16 | middleware-react-loadable-manifest.js: ミドルウェア用Loadable | E-01 (MIDDLEWARE_REACT_LOADABLE_MANIFEST定数) | ○ |
| C-17 | interception-route-rewrite-manifest.js: インターセプトルート | E-01 (INTERCEPTION_ROUTE_REWRITE_MANIFEST定数) | ○ |
| C-18 | dynamic-css-manifest.js: 動的CSS情報 | E-01 (DYNAMIC_CSS_MANIFEST定数) | ○ |
| C-19 | webpack-stats.json: Webpack統計情報 | E-01 (WEBPACK_STATS定数), E-17 (マニフェストローダー参照) | ○ |
| C-20 | BUILD_ID: ビルド識別子ファイル | E-01 (BUILD_ID_FILE定数), E-02 (nanoidインポート) | ○ |
| C-21 | export-marker.json: エクスポートマーカー | E-01 (EXPORT_MARKER定数), E-02 (writeManifest呼び出し L4120) | ○ |
| C-22 | export-detail.json: エクスポート詳細 | E-01 (EXPORT_DETAIL定数), E-02 (unlink呼び出し L4126), E-16 | ○ |
| C-23 | required-server-files.json: サーバーファイルリスト | E-02 (writeRequiredServerFilesManifest関数) | ○ |
| C-24 | package.json (distDir): CommonJSモジュール設定 | E-02 (writeFileUtf8呼び出し L1690-1692) | ○ |
| C-25 | _ssgManifest.js: SSGページ一覧クライアントマニフェスト | E-02 (writeClientSsgManifest関数) | △ |
| C-26 | build-diagnostics.json: ビルド診断情報 | E-11 (updateBuildDiagnostics関数) | ○ |
| C-27 | framework.json: フレームワークバージョン情報 | E-11 (recordFrameworkVersion関数) | ○ |
| C-28 | fetch-metrics.json: fetchメトリクス | E-11 (recordFetchMetrics関数) | ○ |
| C-29 | incremental-build-diagnostics.json: インクリメンタルビルド診断 | E-11 (updateIncrementalBuildMetrics関数) | ○ |
| C-30 | trace-build: ビルドトレースファイル | E-12 (reportToJsonBuild関数, RotatingWriteStream) | ○ |
| C-31 | *.nft.json: Node File Trace情報 | E-13 (collectBuildTraces関数) | ○ |
| C-32 | routes.json (Bundle Analyzer): バンドル解析ルート一覧 | E-15 (analyze関数, writeFile呼び出し), E-02 (L4327-4336) | ○ |
| C-33 | ビルドルートツリー: コンソール出力 | E-09 (printTreeView関数) | ○ |
| C-34 | カスタムルート一覧: コンソール出力 | E-09 (printCustomRoutes関数) | ○ |
| C-35 | 遅延モジュール検出レポート: コンソール出力 | E-08 (SlowModuleDetectionPlugin, generateReport関数) | ○ |
| C-36 | next info診断レポート: コンソール出力 | E-14 (printInfo, printVerboseInfo関数) | ○ |
| C-37 | _clientMiddlewareManifest.js: Turbopackクライアントミドルウェア | E-01 (TURBOPACK_CLIENT_MIDDLEWARE_MANIFEST定数), E-02 (L2750-2753) | ○ |
| C-38 | client-build-manifest.json: Turbopackクライアントビルド | E-01 (TURBOPACK_CLIENT_BUILD_MANIFEST定数) | △ |
| C-39 | _devPagesManifest.json: 開発用ページマニフェスト | E-01 (DEV_CLIENT_PAGES_MANIFEST定数) | ○ |
| C-40 | _devMiddlewareManifest.json: 開発用ミドルウェアマニフェスト | E-01 (DEV_CLIENT_MIDDLEWARE_MANIFEST定数) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-25 (_ssgManifest.js)**: writeClientSsgManifest関数のコードは確認済みだが、出力パスがbuildIdとdeploymentIdの条件分岐で動的に決定されるため、正確な出力パスは実行時環境に依存する。
  - 候補：ビルド実行時のデバッグログ / デプロイ設定ドキュメント
- **C-38 (client-build-manifest.json)**: 定数TURBOPACK_CLIENT_BUILD_MANIFESTは定義されているが、Turbopack内部でのmanifest生成ロジックはRust実装側にあり、TypeScriptソースコードからは完全な出力過程を追跡できない。
  - 候補：turbopack/cratesのRustソースコード / Turbopack設計ドキュメント
- **C-40 (_devMiddlewareManifest.json)**: 定数DEV_CLIENT_MIDDLEWARE_MANIFESTは定義されているが、開発サーバー内でのmanifest書き出しロジックの詳細コードパスは、hot-reloader等の複雑な制御フロー内にあり完全追跡が困難。
  - 候補：packages/next/src/server/dev/ 配下の詳細調査 / hot-reloaderソース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大多数のマニフェスト（C-01〜C-24, C-26〜C-37, C-39）は定数定義と生成コードの両方で確認済み
- 1: 中リスク - C-25: 出力パスが実行時条件に依存するが、機能自体は確認済み
- 1: 中リスク - C-38, C-40: 定数定義はあるが出力ロジックの完全な追跡が困難（Turbopack/開発サーバー内部）

## 6) レビュアーチェックリスト（最小）
- [ ] 全40件の帳票がプロジェクトの実際のビルド出力と一致しているか（`next build`実行後の.nextディレクトリ確認）
- [ ] Turbopack固有のマニフェスト（No.37, 38）がTurbopackビルド時に正しく出力されるか確認
- [ ] 開発用マニフェスト（No.39, 40）が開発サーバー起動時に正しく出力されるか確認
- [ ] 診断レポート（No.26-29）がビルドオプション・環境条件に応じて正しく出力されるか確認
- [ ] コンソール出力系（No.33-36）の説明がソースコードの実装と一致しているか確認
- [ ] 新しいマニフェストやレポートがソースコードに追加されていないか、最新のmainブランチとの差分を確認
