# 帳票設計書 13-images-manifest.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `images-manifest.json`（画像マニフェスト）の設計仕様を定義する。本マニフェストは、`next/image` コンポーネントの設定情報（デバイスサイズ・画像サイズ・リモートパターン・ローカルパターン等）を含み、画像最適化APIの動作パラメータを管理する。

### 本帳票の処理概要

本マニフェストは、`writeImagesManifest` 関数により生成されるJSONファイルであり、`next.config.js` の `images` 設定をランタイム用に加工・変換して出力する。リモートパターンとローカルパターンは正規表現に変換され、画像最適化APIがリクエストを検証する際に使用される。

**業務上の目的・背景**：Next.jsの画像最適化機能（`next/image`）は、デバイスサイズやリモートホストの制限など、多数の設定パラメータに基づいて動作する。ビルド時にこれらの設定を正規化・変換してマニフェストとして出力することで、ランタイムでの画像最適化APIが設定に基づいた適切な画像処理を実行できる。特にリモートパターンの正規表現変換により、不正なリモート画像URLからの保護を実現する。

**帳票の利用シーン**：`next build` コマンド実行時に自動生成される。生成後は、画像最適化API（`/_next/image`）がリクエスト処理時に参照する。デバイスサイズに応じたsrcset生成、リモートパターンマッチング、ローカルパターンマッチングなどの画像最適化処理で利用される。

**主要な出力内容**：
1. バージョン情報（固定値: 1）
2. 画像設定情報（images オブジェクト）
   - デバイスサイズ + 画像サイズの統合リスト（sizes）
   - リモートパターン（正規表現変換済み）
   - ローカルパターン（正規表現変換済み、設定時のみ）
   - その他のimages設定（loader、domains、formats等）

**帳票の出力タイミング**：`next build` コマンド実行時、ビルドプロセスの後半で `writeImagesManifest` 関数により生成される。

**帳票の利用者**：Next.jsフレームワーク内部の画像最適化API。開発者が画像最適化の動作確認やデバッグ目的で参照する場合もある。

## 帳票種別

ビルドマニフェスト（JSON形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON (.json) |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `images-manifest.json` |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

### JSON形式

```json
{
  "version": 1,
  "images": {
    "deviceSizes": [640, 750, 828, 1080, 1200, 1920, 2048, 3840],
    "imageSizes": [16, 32, 48, 64, 96, 128, 256, 384],
    "sizes": [16, 32, 48, 64, 96, 128, 256, 384, 640, 750, 828, 1080, 1200, 1920, 2048, 3840],
    "remotePatterns": [
      {
        "protocol": "https",
        "hostname": "^example\\.com$",
        "port": "",
        "pathname": "^.*$"
      }
    ],
    "localPatterns": [
      {
        "pathname": "^.*$"
      }
    ],
    "loader": "default",
    "formats": ["image/webp"]
  }
}
```

## 帳票レイアウト

### レイアウト概要

マニフェストはバージョン情報とimages設定オブジェクトで構成される。

```
┌─────────────────────────────────────┐
│  version: 1                         │
├─────────────────────────────────────┤
│  images: {                          │
│    deviceSizes: number[]            │
│    imageSizes: number[]             │
│    sizes: number[]                  │
│    remotePatterns: Pattern[]        │
│    localPatterns?: Pattern[]        │
│    loader: string                   │
│    formats: string[]                │
│    ...その他images設定               │
│  }                                  │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | 固定値 | `1` |
| 2 | images | 画像設定オブジェクト | `config.images` から加工 | オブジェクト |

### 明細部（images内フィールド）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | deviceSizes | デバイスサイズ配列 | `config.images.deviceSizes` | `number[]` |
| 2 | imageSizes | 画像サイズ配列 | `config.images.imageSizes` | `number[]` |
| 3 | sizes | deviceSizes + imageSizes の統合配列 | 上記2つのスプレッド結合 | `number[]` |
| 4 | remotePatterns | リモートパターン（正規表現変換済み） | `config.images.remotePatterns` をmakeReで変換 | `{ protocol?, hostname, port?, pathname, search? }[]` |
| 5 | localPatterns | ローカルパターン（正規表現変換済み） | `config.images.localPatterns` をmakeReで変換 | `{ pathname, search? }[]` |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ビルド実行 | `next build` が実行されること | Yes |
| images設定 | `next.config.js` の images 設定（デフォルト値あり） | No（デフォルト設定で生成） |

### ソート順

N/A

### 改ページ条件

N/A（データファイル）

## データベース参照仕様

### 参照テーブル一覧

N/A（`next.config.js` の設定値から生成）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| sizes | `[...deviceSizes, ...imageSizes]` | N/A | 2つの配列のスプレッド結合 |
| remotePatterns.protocol | `p.protocol?.replace(/:$/, '')` | N/A | 末尾のコロンを除去 |
| remotePatterns.hostname | `makeRe(p.hostname).source` | N/A | ホスト名パターンを正規表現に変換 |
| remotePatterns.pathname | `makeRe(p.pathname ?? '**', { dot: true }).source` | N/A | パスパターンを正規表現に変換（デフォルト: '**'） |
| localPatterns.pathname | `makeRe(p.pathname ?? '**', { dot: true }).source` | N/A | パスパターンを正規表現に変換（デフォルト: '**'） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build実行] --> B[writeImagesManifest呼び出し]
    B --> C[config.imagesをコピー]
    C --> D[sizes配列生成: deviceSizes + imageSizes]
    D --> E[remotePatterns正規表現変換]
    E --> F{localPatterns設定あり?}
    F -->|Yes| G[localPatterns正規表現変換]
    F -->|No| H[localPatternsはundefined]
    G --> I[JSONマニフェスト生成]
    H --> I
    I --> J[.next/images-manifest.json出力]
    J --> K[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 設定バリデーション | next.config.jsのimages設定が不正 | ビルド前の設定バリデーションで検出 | next.config.jsの設定を修正 |
| 書き込み失敗 | ファイルシステム書き込みエラー | OS依存のエラーメッセージ | ディスク容量・権限を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1ファイル（設定情報のみ） |
| 目標出力時間 | 即座（設定の変換のみ） |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

remotePatterns は外部画像ソースのホワイトリストとして機能する。デフォルトでは空配列（リモート画像禁止）であり、明示的に設定しない限りリモート画像は最適化されない。localPatterns は設定時のみ出力され、ローカル画像のアクセス制御に使用される。

## 備考

- `remotePatterns` のデフォルト値は空配列 `[]` であり、リモート画像の最適化を許可しない。
- `localPatterns` は `config.images.localPatterns` が設定されている場合のみマニフェストに含まれる。未設定時は `undefined`（全ローカル画像を許可）。
- `makeRe` はグロブパターンを正規表現に変換するpicomatchライブラリの関数である。
- `matchRemotePattern()` および `matchLocalPattern()` 関数がマニフェストの内容に依存するため、マニフェストの変更時はこれらの関数も更新が必要（コード内コメントに記載）。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | 99行目: `IMAGES_MANIFEST` 定数（値: `'images-manifest.json'`） |

**読解のコツ**: マニフェストの構造は `{ version: number, images: NextConfig['images'] }` の形式で、images フィールドは next.config.js の images 設定を加工したものである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | 654-685行目: `writeImagesManifest` 関数。config.imagesをコピーし、sizes統合、remotePatterns/localPatternsの正規表現変換を実行 |

**主要処理フロー**:
1. **658行目**: `config.images` をスプレッドでコピー
2. **659-660行目**: `deviceSizes` と `imageSizes` を結合して `sizes` 配列を生成
3. **663-670行目**: `remotePatterns` のhostname/pathnameをmakeReで正規表現変換
4. **673-679行目**: `localPatterns` が設定されている場合のみ正規表現変換
5. **681-684行目**: `writeManifest` でJSONファイルを出力

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | 4119行目: ビルドプロセス内での `writeImagesManifest(distDir, config)` 呼び出し |

### プログラム呼び出し階層図

```
next build (packages/next/src/build/index.ts)
    |
    +-- writeImagesManifest(distDir, config)
            |
            +-- config.images のコピーと加工
            |       +-- sizes = [...deviceSizes, ...imageSizes]
            |       +-- remotePatterns = makeRe() で正規表現変換
            |       +-- localPatterns = makeRe() で正規表現変換（設定時のみ）
            |
            +-- writeManifest(path.join(distDir, IMAGES_MANIFEST), manifest)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

next.config.js           writeImagesManifest()             .next/images-manifest.json
  images: {          -->   (設定値の加工・正規表現変換)  -->
    deviceSizes,           makeRe() でglob->regex変換
    imageSizes,
    remotePatterns,
    localPatterns,
    ...
  }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/index.ts` | ソース | `writeImagesManifest` 関数の定義と呼び出し |
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | `IMAGES_MANIFEST` 定数定義 |
