# 帳票設計書 14-functions-config-manifest.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `functions-config-manifest.json`（関数設定マニフェスト）の設計仕様を定義する。本マニフェストは、サーバーレス関数の設定（maxDuration、runtime、regions等）を管理し、デプロイメント環境における関数の動作パラメータを提供する。

### 本帳票の処理概要

本マニフェストは、ビルドプロセスの静的解析フェーズで各ページ・ルートの設定情報を収集し、`writeFunctionsConfigManifest` 関数により生成されるJSONファイルである。各ページのエクスポートされた設定値（`export const runtime`, `export const maxDuration`, `export const preferredRegion`）を集約する。

**業務上の目的・背景**：サーバーレス環境（Vercel等）にNext.jsアプリケーションをデプロイする際、各ルート（ページ・APIルート）に対して実行タイムアウト、ランタイム環境、デプロイリージョンなどの設定を個別に制御する必要がある。本マニフェストはこれらの設定情報を一元管理し、デプロイメントアダプターが各関数の設定を適切に構成できるようにする。

**帳票の利用シーン**：`next build` コマンド実行時に自動生成される。生成されたマニフェストは、デプロイメントアダプター（`build-complete.ts`）、エクスポート処理（`export/index.ts`）、ルーターファイルシステム（`router-utils/filesystem.ts`）、サーバー初期化（`next-server.ts`）で参照される。特にミドルウェアのNode.jsランタイム設定の判定に使用される。

**主要な出力内容**：
1. バージョン情報（固定値: 1）
2. 関数設定マップ（functions オブジェクト）
   - 各ページ/ルートのmaxDuration設定
   - 各ページ/ルートのruntime設定（'nodejs'のみ）
   - 各ページ/ルートのregions設定
   - ミドルウェアのmatchers設定

**帳票の出力タイミング**：`next build` コマンド実行時、静的解析と各ページのチェック完了後に `writeFunctionsConfigManifest` 関数により生成される。

**帳票の利用者**：Next.jsフレームワーク内部のサーバー・デプロイメントアダプター。Vercel等のデプロイプラットフォームが関数設定を読み取るために利用する。

## 帳票種別

ビルドマニフェスト（JSON形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON (.json) |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `functions-config-manifest.json` |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

### JSON形式

```json
{
  "version": 1,
  "functions": {
    "/api/hello": {
      "maxDuration": 30,
      "regions": ["iad1"]
    },
    "/dashboard": {
      "maxDuration": 60,
      "regions": ["iad1", "sfo1"]
    },
    "/_middleware": {
      "runtime": "nodejs",
      "matchers": [
        {
          "regexp": "^.*$",
          "originalSource": "/:path*"
        }
      ]
    }
  }
}
```

## 帳票レイアウト

### レイアウト概要

```
┌─────────────────────────────────────────┐
│  version: 1                             │
├─────────────────────────────────────────┤
│  functions: {                           │
│    [page: string]: {                    │
│      maxDuration?: number               │
│      runtime?: 'nodejs'                 │
│      regions?: string[] | string        │
│      matchers?: MatcherEntry[]          │
│    }                                    │
│  }                                      │
└─────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | 固定値 | `1` |
| 2 | functions | ページ/ルートごとの関数設定マップ | 静的解析結果 | オブジェクト |

### 明細部（functionsの各エントリ）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | maxDuration | 関数の最大実行時間（秒） | `export const maxDuration` | `number \| undefined` |
| 2 | runtime | ランタイム環境 | `export const runtime` | `'nodejs' \| undefined` |
| 3 | regions | デプロイリージョン | `export const preferredRegion` | `string[] \| string \| undefined` |
| 4 | matchers | ミドルウェアマッチャー | ミドルウェア設定 | `{ regexp, originalSource, has?, missing? }[]` |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 設定値の存在 | runtime, maxDuration, preferredRegion のいずれかがページにエクスポートされていること | Yes（ミドルウェア以外） |
| ミドルウェア存在 | middleware.ts/jsが存在しNode.jsランタイムの場合 | Yes（ミドルウェアエントリ用） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ページパス（functionsのキー） | アルファベット昇順（localeCompare） |

### 改ページ条件

N/A（データファイル）

## データベース参照仕様

### 参照テーブル一覧

N/A（ソースコードの静的解析結果から生成）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| regions配列化 | `typeof preferredRegion === 'string' ? [preferredRegion] : preferredRegion` | N/A | 文字列の場合は配列に変換 |
| functionsソート | `Object.entries(functions).sort(([a], [b]) => a.localeCompare(b))` | N/A | キーのアルファベット順でソート |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build実行] --> B[静的解析フェーズ開始]
    B --> C[functionsConfigManifest初期化]
    C --> D[各ページの静的情報を解析]
    D --> E{runtime/maxDuration/preferredRegion あり?}
    E -->|Yes| F[functionsConfigManifest.functionsにエントリ追加]
    E -->|No| G[スキップ]
    F --> H{次のページあり?}
    G --> H
    H -->|Yes| D
    H -->|No| I{ミドルウェアあり?}
    I -->|Yes| J[/_middlewareエントリ追加]
    I -->|No| K[writeFunctionsConfigManifest呼び出し]
    J --> K
    K --> L[キーでソート]
    L --> M[.next/server/functions-config-manifest.json出力]
    M --> N[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 設定値不正 | unsupportedSegmentConfigが検出された場合 | `errorFromUnsupportedSegmentConfig()` | ページの設定値を修正 |
| 書き込み失敗 | ファイルシステム書き込みエラー | OS依存のエラーメッセージ | ディスク容量・権限を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | プロジェクト内のルート数に依存（通常数十〜数百件） |
| 目標出力時間 | 即座（静的解析結果のシリアライズのみ） |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

本マニフェストにはサーバー関数の実行設定が含まれるが、機密情報は含まれない。ただし、runtime設定やregion設定はインフラストラクチャの構成情報であり、サーバーファイルとして保護する必要がある。

## 備考

- `FunctionsConfigManifest` インターフェースは `packages/next/src/build/index.ts` の597-613行目で定義される。
- ミドルウェアが Node.js ランタイム（`staticInfo.runtime === 'nodejs'`）の場合、`/_middleware` エントリにmatchers情報が含まれる。
- デプロイメントアダプター（`build-complete.ts`）では、このマニフェストを各ルートの関数設定として読み取り、サーバーレス関数のデプロイ構成に反映する。
- エクスポート処理（`export/index.ts`）では、ミドルウェアの存在判定に使用される。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.ts | `packages/next/src/build/index.ts` | 597-613行目: `FunctionsConfigManifest` インターフェース。version, functions フィールドの型定義 |
| 1-2 | constants.ts | `packages/next/src/shared/lib/constants.ts` | 92行目: `FUNCTIONS_CONFIG_MANIFEST` 定数（値: `'functions-config-manifest.json'`） |

**読解のコツ**: functions のバリュー型は `{ maxDuration?, runtime?, regions?, matchers? }` の任意フィールド構成。ミドルウェアエントリのみ `matchers` フィールドを持つ。

#### Step 2: マニフェスト生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | 2160-2163行目: マニフェスト初期化。615-629行目: `writeFunctionsConfigManifest` 関数でソート・書き込み |
| 2-2 | index.ts | `packages/next/src/build/index.ts` | 2363-2378行目: 各ページのstaticInfo（runtime, maxDuration, preferredRegion）をマニフェストに追加 |
| 2-3 | index.ts | `packages/next/src/build/index.ts` | 2720-2755行目: ミドルウェアのNode.jsランタイム設定をマニフェストに追加 |

**主要処理フロー**:
1. **2160行目**: `functionsConfigManifest` を `{ version: 1, functions: {} }` で初期化
2. **2374行目**: 各ページの `staticInfo` からmaxDuration, regionsを設定
3. **2722行目**: ミドルウェアがNode.jsランタイムの場合、`/_middleware` エントリを追加
4. **2758行目**: `writeFunctionsConfigManifest(distDir, functionsConfigManifest)` で書き込み

#### Step 3: マニフェスト利用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | 224-318行目: ルーターでのマニフェスト読み込み。ミドルウェアmatchers取得に利用 |
| 3-2 | build-complete.ts | `packages/next/src/build/adapter/build-complete.ts` | 876行目, 967行目: デプロイメントアダプターでの関数設定読み取り |
| 3-3 | next-server.ts | `packages/next/src/server/next-server.ts` | 1521行目: サーバー初期化時のマニフェスト参照 |

### プログラム呼び出し階層図

```
next build (packages/next/src/build/index.ts)
    |
    +-- 静的解析フェーズ
    |       |
    |       +-- 各ページの staticInfo 取得
    |       |       +-- runtime / maxDuration / preferredRegion 抽出
    |       |       +-- functionsConfigManifest.functions[page] に追加
    |       |
    |       +-- ミドルウェア解析
    |               +-- functionsConfigManifest.functions['/_middleware'] 追加
    |
    +-- writeFunctionsConfigManifest(distDir, manifest)
            |
            +-- Object.entries().sort() でキーソート
            +-- writeManifest() でJSON出力
```

### データフロー図

```
[入力]                        [処理]                                [出力]

各ページのexport設定        静的解析 + writeFunctions           .next/server/functions-config-manifest.json
  runtime          --->     ConfigManifest()               --->
  maxDuration                (設定収集・ソート・出力)
  preferredRegion

middleware設定       --->    /_middlewareエントリ追加        --->
  runtime
  matchers
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/index.ts` | ソース | FunctionsConfigManifest型定義、マニフェスト生成・書き込み |
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | FUNCTIONS_CONFIG_MANIFEST定数定義 |
| filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | ソース | ルーターでのマニフェスト読み込み |
| next-server.ts | `packages/next/src/server/next-server.ts` | ソース | サーバー初期化時のマニフェスト参照 |
| build-complete.ts | `packages/next/src/build/adapter/build-complete.ts` | ソース | デプロイメントアダプターでの関数設定読み取り |
| index.ts | `packages/next/src/export/index.ts` | ソース | エクスポート処理でのミドルウェア存在判定 |
| utils.ts | `packages/next/src/build/utils.ts` | ソース | ビルドユーティリティでのマニフェスト参照 |
