# 帳票設計書 21-export-marker.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `export-marker.json` の設計仕様を定義する。このファイルはエクスポート設定の情報（exportPathMapの有無・trailingSlash・next/imageの使用状況）を記録するマーカーファイルである。

### 本帳票の処理概要

`export-marker.json` は、Next.jsのプロダクションビルド（`next build`）完了時に生成されるメタ情報ファイルである。静的エクスポート（`next export`）の実行可否を判断するための情報を記録する。

**業務上の目的・背景**：Next.jsアプリケーションを静的HTMLとしてエクスポートする際に、ビルド時点での設定状態を永続化する必要がある。特に `next/image` コンポーネントの使用有無は、静的エクスポート時の画像最適化APIの可用性に直結するため、エクスポート実行前にこの情報を事前チェックする仕組みが必要となる。このマーカーファイルにより、ビルドとエクスポートが分離されたワークフローでも正確な判定が可能になる。

**帳票の利用シーン**：`next export` コマンド実行時、または `output: 'export'` 設定によるビルド時に、画像最適化の互換性チェックとして参照される。デフォルトローダーによる画像最適化が静的エクスポートと互換性がないため、このチェックにより適切なエラーメッセージをユーザーに提供する。

**主要な出力内容**：
1. version - マニフェストのバージョン番号（現在は1）
2. hasExportPathMap - next.config.jsでexportPathMap関数が定義されているかどうか
3. exportTrailingSlash - trailingSlash設定がtrueかどうか
4. isNextImageImported - next/imageコンポーネントがインポートされているかどうか

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの最終段階で、画像マニフェストの書き込み直後に生成される。

**帳票の利用者**：Next.jsビルドシステム内部のエクスポート処理モジュール（`export/index.ts`）

## 帳票種別

ビルドメタ情報（JSONマーカーファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | export-marker.json |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

フラットなJSONオブジェクト構造で、4つのトップレベルプロパティを持つ。

```json
{
  "version": 1,
  "hasExportPathMap": false,
  "exportTrailingSlash": false,
  "isNextImageImported": true
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | ハードコード値（1） | 整数 |
| 2 | hasExportPathMap | exportPathMap関数の定義有無 | next.config.jsのexportPathMap設定 | boolean |
| 3 | exportTrailingSlash | trailingSlash設定の有無 | next.config.jsのtrailingSlash設定 | boolean |
| 4 | isNextImageImported | next/imageの使用有無 | ビルド解析結果（isNextImageImported変数） | boolean |

### 明細部

N/A（フラットなJSONオブジェクトのため明細部なし）

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |

### ソート順

N/A（単一オブジェクト出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースを使用しない。next.config.jsの設定値とビルド解析結果を参照する）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| hasExportPathMap | `typeof config.exportPathMap === 'function'` | N/A | 関数定義の型チェック |
| exportTrailingSlash | `config.trailingSlash === true` | N/A | 厳密等価比較 |
| isNextImageImported | `isNextImageImported === true` | N/A | ビルド時のモジュール解析結果の厳密等価比較 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build実行] --> B[ビルドプロセス完了]
    B --> C[writeImagesManifest完了]
    C --> D[writeManifest呼び出し]
    D --> E[config.exportPathMap判定]
    E --> F[config.trailingSlash判定]
    F --> G[isNextImageImported判定]
    G --> H[JSONオブジェクト生成]
    H --> I[distDir/export-marker.jsonに書き込み]
    I --> J[export-detail.json削除試行]
    J --> K[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | distDirへのファイルシステム書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一JSONオブジェクト） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき1回） |

## セキュリティ考慮事項

特に機密情報は含まれない。next.config.jsの設定状態のサマリのみ記録する。

## 備考

- 定数名: `EXPORT_MARKER`（`packages/next/src/shared/lib/constants.ts` L95で定義）
- 出力先: `.next/export-marker.json`
- `next export` 実行時に `export/index.ts` の `exportAppImpl` 関数内で読み取られ、`isNextImageImported` フラグに基づいて画像最適化の互換性チェックが行われる。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、export-marker.jsonの出力データ構造と定数定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | L95: `EXPORT_MARKER` 定数定義。値は `'export-marker.json'` |

**読解のコツ**: 定数ファイルにはNext.jsのすべてのマニフェスト/メタファイルの名前が集約されている。

#### Step 2: エントリーポイントを理解する

帳票の生成処理は `build/index.ts` のビルドメインフロー内に存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | L4120-4125: `writeManifest` を使用して `EXPORT_MARKER` に書き込む処理 |

**主要処理フロー**:
1. **L4119**: `writeImagesManifest(distDir, config)` - 画像マニフェスト書き込み完了後
2. **L4120-4125**: `writeManifest(path.join(distDir, EXPORT_MARKER), {...})` - export-marker.jsonの生成
3. **L4126-4131**: `fs.unlink(path.join(distDir, EXPORT_DETAIL))` - 古いexport-detail.jsonの削除

#### Step 3: 読み取り処理を理解する

export-marker.jsonがどこで消費されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/export/index.ts` | L409-416: `EXPORT_MARKER` を読み込み `isNextImageImported` を取得する処理 |
| 3-2 | index.ts | `packages/next/src/export/index.ts` | L418-432: 画像最適化の互換性チェック。デフォルトローダー使用時に静的エクスポート不可エラーをスロー |

**主要処理フロー**:
- **L413**: `fs.readFile(join(distDir, EXPORT_MARKER), 'utf8')` - ファイル読み込み
- **L414**: `JSON.parse(text)` - JSONパース
- **L418-432**: `isNextImageImported && loader === 'default' && !unoptimized` の条件チェック

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- build/index.ts (メインビルド処理)
           |
           +-- writeImagesManifest()
           |
           +-- writeManifest(EXPORT_MARKER, {...})  <-- 生成
           |
           +-- fs.unlink(EXPORT_DETAIL)

next export (CLI)
    |
    +-- export/index.ts :: exportAppImpl()
           |
           +-- fs.readFile(EXPORT_MARKER)  <-- 読み取り
           |
           +-- isNextImageImported チェック
```

### データフロー図

```
[入力]                          [処理]                         [出力]

next.config.js
  exportPathMap    ----+
  trailingSlash    ----+----> build/index.ts
                       |      writeManifest()   ------>  .next/export-marker.json
ビルド解析結果         |
  isNextImageImported -+

                              export/index.ts
.next/export-marker.json ---> exportAppImpl()   ------>  互換性チェック結果
                              (読み取り・判定)               (エラーまたは続行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | EXPORT_MARKER定数定義（L95） |
| index.ts | `packages/next/src/build/index.ts` | ソース | export-marker.json生成処理（L4120-4125） |
| index.ts | `packages/next/src/export/index.ts` | ソース | export-marker.json読み取り・判定処理（L409-432） |
