# 帳票設計書 22-export-detail.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `export-detail.json` の設計仕様を定義する。このファイルはエクスポートの詳細情報（出力ディレクトリ・成功/失敗ステータス）を格納するメタ情報ファイルである。

### 本帳票の処理概要

`export-detail.json` は、Next.jsの静的エクスポートプロセス（`next export` または `output: 'export'` 設定時のビルド）において、エクスポート処理の進捗と結果を記録するファイルである。エクスポート開始時に `success: false` で作成され、正常完了時に `success: true` に更新される。

**業務上の目的・背景**：静的エクスポートは長時間かかる可能性があり、途中で失敗した場合にその状態を永続化する必要がある。このファイルにより、エクスポートの完了状態を外部ツールやCI/CDパイプラインから確認でき、失敗時のデバッグにも活用できる。また、ビルド完了時には不要となるため削除される設計になっている。

**帳票の利用シーン**：`next export` 実行中および実行後に、エクスポート処理の状態確認として利用される。ビルド完了後（`next build` のみの場合）は不要なため削除される。

**主要な出力内容**：
1. version - マニフェストのバージョン番号（現在は1）
2. outDirectory - エクスポート先のディレクトリパス
3. success - エクスポート処理の成功/失敗フラグ

**帳票の出力タイミング**：`next export` プロセスの開始時に `success: false` で作成され、正常完了時に `success: true` で上書きされる。`next build` のみの場合はビルド完了時に削除される。

**帳票の利用者**：Next.jsビルドシステム内部、CI/CDパイプライン、デプロイツール

## 帳票種別

ビルドメタ情報（JSONステータスファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next export` / `next build`（output: 'export'時） | エクスポート実行時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | export-detail.json |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

フラットなJSONオブジェクト構造。3つのトップレベルプロパティを持つ。

```json
{
  "version": 1,
  "outDirectory": "/path/to/out",
  "success": true
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | ハードコード値（1） | 整数 |
| 2 | outDirectory | エクスポート出力先ディレクトリ | options.outdirパラメータ | 文字列（ファイルパス） |
| 3 | success | エクスポート処理の成功フラグ | エクスポート処理結果 | boolean |

### 明細部

N/A（フラットなJSONオブジェクトのため明細部なし）

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| エクスポート処理実行 | `next export` またはビルド時のエクスポート処理が実行されていること | Yes |

### ソート順

N/A（単一オブジェクト出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースを使用しない）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| success | エクスポート処理全体の成否 | N/A | 開始時false、正常完了時trueに更新 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next export実行] --> B[出力ディレクトリ初期化]
    B --> C[export-detail.json作成 success:false]
    C --> D[静的ページ生成処理]
    D --> E{全ページ生成成功?}
    E -->|Yes| F[export-detail.json更新 success:true]
    E -->|No| G[エラー発生 success:falseのまま]
    F --> H[終了]
    G --> H
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | distDirへのファイルシステム書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |
| エクスポート失敗 | ページ生成でエラー発生 | Export encountered errors on following paths: ... | success: falseのまま残存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一JSONオブジェクト） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（エクスポートプロセスにつき1回） |

## セキュリティ考慮事項

出力先ディレクトリのフルパスが含まれるため、本番環境のパス情報が露出する可能性がある。ただし通常は `.next` ディレクトリ内に格納され外部公開されない。

## 備考

- 定数名: `EXPORT_DETAIL`（`packages/next/src/shared/lib/constants.ts` L96で定義）
- 出力先: `.next/export-detail.json`
- `next build` のみの実行時（エクスポートなし）はビルド完了時に `fs.unlink` で削除される（`build/index.ts` L4126-4131）
- `formatManifest` 関数を使用してJSON整形出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

export-detail.jsonの出力データ構造と定数定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | L96: `EXPORT_DETAIL` 定数定義。値は `'export-detail.json'` |

**読解のコツ**: EXPORT_DETAILとEXPORT_MARKERは隣接して定義されているが、用途が異なる。MARKERはビルド設定の記録、DETAILはエクスポート結果の記録。

#### Step 2: エントリーポイントを理解する（書き込み処理）

エクスポート処理内でのファイル作成・更新箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/export/index.ts` | L350-358: エクスポート開始時に `success: false` で作成 |
| 2-2 | index.ts | `packages/next/src/export/index.ts` | L1015-1023: エクスポート正常完了時に `success: true` で更新 |

**主要処理フロー**:
1. **L350-358**: `fs.writeFile(join(distDir, EXPORT_DETAIL), formatManifest({version: 1, outDirectory: outDir, success: false}))` - 開始時の作成
2. **L1015-1023**: `fs.writeFile(join(distDir, EXPORT_DETAIL), formatManifest({version: 1, outDirectory: outDir, success: true}))` - 完了時の更新

#### Step 3: 削除処理を理解する

ビルドのみ実行時（エクスポートなし）の削除処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | L4126-4131: `fs.unlink(path.join(distDir, EXPORT_DETAIL))` - ビルド完了時の削除。ENOENTエラーは無視。 |

### プログラム呼び出し階層図

```
next export (CLI)
    |
    +-- export/index.ts :: exportAppImpl()
           |
           +-- fs.writeFile(EXPORT_DETAIL, {success: false})  <-- 開始時作成
           |
           +-- [ページ生成処理...]
           |
           +-- fs.writeFile(EXPORT_DETAIL, {success: true})   <-- 完了時更新

next build (CLI)
    |
    +-- build/index.ts (ビルド最終段階)
           |
           +-- writeManifest(EXPORT_MARKER, {...})
           |
           +-- fs.unlink(EXPORT_DETAIL)  <-- 不要なため削除
```

### データフロー図

```
[入力]                     [処理]                         [出力]

options.outdir ---------> export/index.ts
                          exportAppImpl()
                          (1) 初期作成         ------>  .next/export-detail.json
                              {success: false}            (初期状態)

                          (2) ページ生成処理

                          (3) 完了更新         ------>  .next/export-detail.json
                              {success: true}             (完了状態)

                          build/index.ts
                          (4) 削除             ------>  .next/export-detail.json
                                                          (削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | EXPORT_DETAIL定数定義（L96） |
| index.ts | `packages/next/src/export/index.ts` | ソース | ファイル作成・更新処理（L350-358, L1015-1023） |
| index.ts | `packages/next/src/build/index.ts` | ソース | ファイル削除処理（L4126-4131） |
| format-manifest.ts | `packages/next/src/build/manifests/formatter/format-manifest.ts` | ソース | JSON整形関数 |
