# 帳票設計書 23-required-server-files.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `required-server-files.json` の設計仕様を定義する。このファイルはスタンドアロンデプロイに必要なサーバーファイルリスト・設定情報を含むマニフェストである。

### 本帳票の処理概要

`required-server-files.json` は、Next.jsのプロダクションビルド時に生成されるマニフェストファイルで、アプリケーションをスタンドアロンモード（`output: 'standalone'`）でデプロイする際に必要な全ファイルのリストとランタイム設定情報を格納する。同時に `.js` 形式のファイルも生成される。

**業務上の目的・背景**：Next.jsアプリケーションをDockerコンテナやサーバーレス環境にデプロイする場合、必要最小限のファイルセットを特定する必要がある。このマニフェストにより、`node_modules` の巨大な依存関係を含まず、実行に必要なファイルのみをパッケージ化したスタンドアロンデプロイが可能となる。また、ランタイム設定をビルド時の設定から分離することで、同一ビルドを異なる環境にデプロイ可能にする。

**帳票の利用シーン**：スタンドアロンデプロイ時にサーバー起動処理がこのマニフェストを参照し、必要なファイルの存在確認とランタイム設定の読み込みを行う。Vercelなどのデプロイプラットフォームでも利用される。

**主要な出力内容**：
1. version - マニフェストバージョン（現在は1）
2. config - Next.jsのランタイム設定情報（next.config.jsの内容をフィルタリングしたもの）
3. appDir - アプリケーションのルートディレクトリパス
4. relativeAppDir - outputFileTracingRootからの相対パス
5. files - デプロイに必要なファイルパスのリスト
6. ignore - 無視すべきファイルパスのリスト

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの初期段階で生成される。

**帳票の利用者**：Next.jsサーバーランタイム、デプロイプラットフォーム、CI/CDパイプライン

## 帳票種別

ビルドメタ情報（JSONマニフェストファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON（.json）および JavaScript（.js） |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | required-server-files.json / required-server-files.js |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

ネストされたJSONオブジェクト構造。configプロパティにはNext.jsのランタイム設定情報が含まれ、filesプロパティにはファイルパスの配列が格納される。

```json
{
  "version": 1,
  "config": {
    "compress": false,
    "cacheHandler": "...",
    "cacheHandlers": {},
    "experimental": { "..." }
  },
  "appDir": "/absolute/path/to/app",
  "relativeAppDir": "relative/path",
  "files": [
    ".next/routes-manifest.json",
    ".next/server/pages-manifest.json",
    ".next/build-manifest.json"
  ],
  "ignore": []
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | ハードコード値（1） | 整数 |
| 2 | config | ランタイム設定 | next.config.jsのフィルタリング結果 | オブジェクト |
| 3 | appDir | アプリケーションルートディレクトリ | dir引数 | 文字列（絶対パス） |
| 4 | relativeAppDir | 相対アプリケーションディレクトリ | path.relative(outputFileTracingRoot, dir) | 文字列（相対パス） |
| 5 | files | 必要ファイルリスト | ビルドマニフェスト定数群 | 文字列配列 |
| 6 | ignore | 無視ファイルリスト | 初期値は空配列 | 文字列配列 |

### 明細部（filesリスト）

| No | 項目名 | 説明 | データ取得元 | 条件 |
|----|-------|------|-------------|------|
| 1 | routes-manifest.json | ルーティングマニフェスト | ROUTES_MANIFEST定数 | 常時 |
| 2 | server/pages-manifest.json | ページマニフェスト | pagesManifestPath | 常時 |
| 3 | build-manifest.json | ビルドマニフェスト | BUILD_MANIFEST定数 | 常時 |
| 4 | prerender-manifest.json | プリレンダリングマニフェスト | PRERENDER_MANIFEST定数 | 常時 |
| 5 | server/functions-config-manifest.json | 関数設定マニフェスト | FUNCTIONS_CONFIG_MANIFEST | 常時 |
| 6 | server/middleware-manifest.json | ミドルウェアマニフェスト | MIDDLEWARE_MANIFEST | 常時 |
| 7 | server/middleware-build-manifest.js | ミドルウェアビルドマニフェスト | MIDDLEWARE_BUILD_MANIFEST | 常時 |
| 8 | server/middleware-react-loadable-manifest.js | React Loadableマニフェスト | MIDDLEWARE_REACT_LOADABLE_MANIFEST | Webpack使用時のみ |
| 9 | react-loadable-manifest.json | React Loadableマニフェスト | REACT_LOADABLE_MANIFEST | Webpack使用時のみ |
| 10 | server/app-paths-manifest.json | Appパスマニフェスト | APP_PATHS_MANIFEST | appDir存在時 |
| 11 | app-path-routes-manifest.json | Appパスルートマニフェスト | APP_PATH_ROUTES_MANIFEST | appDir存在時 |
| 12 | server/server-reference-manifest.js/.json | サーバーリファレンスマニフェスト | SERVER_REFERENCE_MANIFEST | appDir存在時 |
| 13 | BUILD_ID | ビルドID | BUILD_ID_FILE | 常時 |
| 14 | server/next-font-manifest.js/.json | フォントマニフェスト | NEXT_FONT_MANIFEST | 常時 |
| 15 | required-server-files.json | 自身のマニフェスト | SERVER_FILES_MANIFEST | 常時 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |

### ソート順

N/A（固定順序でファイルリストが生成される）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースを使用しない）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| relativeAppDir | `path.relative(outputFileTracingRoot, dir)` | N/A | パスの相対化 |
| cacheHandler | `path.relative(distDir, runtimeConfig.cacheHandler)` | N/A | キャッシュハンドラパスの相対化 |
| cacheHandlers | 各エントリの値を `path.relative(distDir, value)` で変換 | N/A | キャッシュハンドラ群のパス相対化 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build実行] --> B[getNextConfigRuntime でランタイム設定取得]
    B --> C[cacheHandlersのパス相対化]
    C --> D[configFileプロパティ削除]
    D --> E[CI環境判定でcompress設定調整]
    E --> F[ファイルリスト構築]
    F --> G[条件に応じたオプショナルファイル追加]
    G --> H[writeRequiredServerFilesManifest呼び出し]
    H --> I[.json形式で書き込み]
    H --> J[.js形式で書き込み]
    I --> K[終了]
    J --> K
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | distDirへのファイルシステム書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一マニフェストオブジェクト。filesリストは15-20エントリ程度） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき1回） |

## セキュリティ考慮事項

- ランタイム設定情報（next.config.jsの内容）が含まれるため、APIキーやシークレットが設定に含まれている場合は注意が必要
- `configFile` プロパティは明示的に削除されている（L2939-2940）
- `.next` ディレクトリ内に格納されるため、通常は外部公開されない

## 備考

- 定数名: `SERVER_FILES_MANIFEST`（`packages/next/src/shared/lib/constants.ts` L100で定義、値は `'required-server-files'`）
- 出力先: `.next/required-server-files.json` および `.next/required-server-files.js`
- .js形式は `self.__SERVER_FILES_MANIFEST=...` の形式で出力される
- TypeScript型定義: `RequiredServerFilesManifest`（`build/index.ts` L631-638）
- CI環境（hasNextSupport）の場合、`compress: false` が設定される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マニフェストの型定義と定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | L100: `SERVER_FILES_MANIFEST` 定数定義。値は `'required-server-files'` |
| 1-2 | index.ts | `packages/next/src/build/index.ts` | L631-638: `RequiredServerFilesManifest` 型定義。version, config, appDir, relativeAppDir, files, ignoreの6フィールド |

**読解のコツ**: RequiredServerFilesManifest型のconfigプロパティは `NextConfigRuntime` 型であり、ビルド時のnext.config.jsからランタイムに必要な情報のみをフィルタリングしたサブセット。

#### Step 2: 書き込み処理を理解する

マニフェストの書き込み関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | L640-652: `writeRequiredServerFilesManifest` 関数。.jsonと.jsの2形式で出力 |

**主要処理フロー**:
1. **L644-646**: `writeManifest(path.join(distDir, SERVER_FILES_MANIFEST + '.json'), requiredServerFiles)` - JSON形式で書き込み
2. **L648-651**: `writeFileUtf8(path.join(distDir, SERVER_FILES_MANIFEST + '.js'), ...)` - JS形式で書き込み。`self.__SERVER_FILES_MANIFEST=` プレフィックス付き

#### Step 3: マニフェスト構築処理を理解する

ビルドメインフロー内でのマニフェスト構築ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | L1922-2020: `generate-required-server-files` トレースセクション。マニフェストオブジェクトの構築 |

**主要処理フロー**:
- **L1926**: `getNextConfigRuntime(config)` - ランタイム設定の取得
- **L1928-1935**: cacheHandlersのパス相対化ループ
- **L1939-1940**: configFileプロパティの削除
- **L1942-2020**: serverFilesManifestオブジェクトの組み立て（条件分岐によるファイルリスト構築）

#### Step 4: 読み取り処理を理解する

サーバーランタイムでのマニフェスト読み取りを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | next.ts | `packages/next/src/server/next.ts` | L20: SERVER_FILES_MANIFESTインポート。サーバー起動時に設定を読み込む |

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- build/index.ts (メインビルドフロー)
           |
           +-- generate-required-server-files (traceChild)
           |      |
           |      +-- getNextConfigRuntime(config)
           |      +-- cacheHandlers パス相対化
           |      +-- serverFilesManifest オブジェクト構築
           |
           +-- writeRequiredServerFilesManifest()
                  |
                  +-- writeManifest() --> .json出力
                  +-- writeFileUtf8() --> .js出力

next start (サーバー起動)
    |
    +-- server/next.ts
           |
           +-- required-server-files.json 読み込み
```

### データフロー図

```
[入力]                              [処理]                              [出力]

next.config.js -------+
  (ランタイム設定)      |
                       +---> build/index.ts
dir (アプリルート) ----+     generate-required-server-files
                       |                                    ----->  .next/required-server-files.json
outputFileTracingRoot -+     writeRequiredServerFilesManifest
                       |                                    ----->  .next/required-server-files.js
ビルドマニフェスト群 ---+
  (定数から導出)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | SERVER_FILES_MANIFEST定数定義（L100） |
| index.ts | `packages/next/src/build/index.ts` | ソース | マニフェスト構築・書き込み処理（L631-652, L1922-2020） |
| next.ts | `packages/next/src/server/next.ts` | ソース | マニフェスト読み取り（サーバー起動時） |
| route-module.ts | `packages/next/src/server/route-modules/route-module.ts` | ソース | SERVER_FILES_MANIFEST参照 |
| middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | ソース | SERVER_FILES_MANIFEST参照 |
| route-loader.ts | `packages/next/src/client/route-loader.ts` | ソース | SERVER_FILES_MANIFEST参照 |
| format-manifest.ts | `packages/next/src/build/manifests/formatter/format-manifest.ts` | ソース | .js形式出力時のJSON整形 |
