# 帳票設計書 24-package.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいてdistDir内に生成される `package.json` の設計仕様を定義する。このファイルはdistDir（通常 `.next`）内でCommonJSモジュール解決を保証するための最小限のpackage.jsonである。

### 本帳票の処理概要

`package.json` は、Next.jsのプロダクションビルド開始時にdistDir直下に生成される、`{"type": "commonjs"}` のみを含む最小限のpackage.jsonファイルである。

**業務上の目的・背景**：Node.jsのモジュール解決において、`package.json` の `type` フィールドが `.mjs` / `.cjs` 以外のファイルの解釈方法を決定する。プロジェクトルートの `package.json` が `"type": "module"` を指定していると、`.next` ディレクトリ内のファイルもESモジュールとして扱われてしまう。Next.jsのビルド出力はCommonJS形式であるため、distDir内に `"type": "commonjs"` を指定したpackage.jsonを配置することで、ビルド出力ファイルが正しくCommonJSモジュールとして解決されることを保証する。

**帳票の利用シーン**：Node.jsランタイムが `.next` ディレクトリ内のJavaScriptファイルをrequire()する際に、モジュールタイプの判定に使用される。特に `"type": "module"` プロジェクトで重要。

**主要な出力内容**：
1. type - モジュールタイプの指定（固定値 `"commonjs"`）

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの最初期段階で、distDirのクリーニング直後に生成される。

**帳票の利用者**：Node.jsランタイム（モジュール解決システム）

## 帳票種別

ビルドメタ情報（モジュール設定ファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | package.json |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

単一プロパティのみを持つ最小限のJSONオブジェクト。

```json
{"type": "commonjs"}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | type | モジュールタイプ指定 | ハードコード値（"commonjs"） | 文字列 |

### 明細部

N/A

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |

### ソート順

N/A

### 改ページ条件

N/A

## データベース参照仕様

N/A（データベースを使用しない。固定値のみ出力する）

## 計算仕様

### 計算項目一覧

N/A（全て固定値）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build実行] --> B[distDirクリーニング]
    B --> C[writeFileUtf8呼び出し]
    C --> D[distDir/package.jsonに書き込み]
    D --> E[recordFrameworkVersion呼び出し]
    E --> F[updateBuildDiagnostics呼び出し]
    F --> G[ビルド本体処理に進む]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | distDirへのファイルシステム書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（固定文字列20バイト程度） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき1回） |

## セキュリティ考慮事項

固定値のみ含むため、セキュリティ上のリスクはない。

## 備考

- 固有の定数名は定義されていない（直接 `path.join(distDir, 'package.json')` として参照される）
- 出力先: `.next/package.json`
- `writeFileUtf8` 関数を使用して書き込まれる
- distDirのクリーニング直後、他の診断情報やマニフェストの前に書き込まれる最初のファイルの一つ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力データは固定文字列 `'{"type": "commonjs"}'` のみであり、型定義は存在しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | N/A | N/A | 出力は固定文字列のため、専用の型定義やインターフェースは存在しない |

#### Step 2: エントリーポイントを理解する

ビルドメインフロー内での書き込み箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | L1688-1693: distDirクリーニング後にpackage.jsonを書き込む処理 |

**主要処理フロー**:
1. **L1688**: コメント「Ensure commonjs handling is used for files in the distDir (generally .next)」
2. **L1689**: コメント「Files outside of the distDir can be "type": "module"」
3. **L1690-1693**: `writeFileUtf8(path.join(distDir, 'package.json'), '{"type": "commonjs"}')` - 固定文字列の書き込み
4. **L1696**: 直後に `recordFrameworkVersion` が呼び出される
5. **L1697**: 直後に `updateBuildDiagnostics` が呼び出される

**読解のコツ**: この処理はビルドの非常に早い段階で実行される。distDirのクリーニング後、他のマニフェスト生成前に書き込まれる。これは後続のビルド処理で生成されるファイルが正しくCommonJSとして扱われるために必須。

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- build/index.ts (メインビルドフロー)
           |
           +-- distDirクリーニング
           |
           +-- writeFileUtf8(distDir/package.json)  <-- 生成
           |
           +-- recordFrameworkVersion()
           +-- updateBuildDiagnostics()
           +-- [以降のビルド処理...]
```

### データフロー図

```
[入力]               [処理]                         [出力]

固定文字列           build/index.ts
'{"type":    ------> writeFileUtf8()   -------->  .next/package.json
 "commonjs"}'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/index.ts` | ソース | package.json書き込み処理（L1688-1693） |
