# 帳票設計書 26-build-diagnostics.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `build-diagnostics.json` の設計仕様を定義する。このファイルはビルドプロセスの診断情報（ビルドステージ・ビルドオプション等）を記録するJSONレポートである。

### 本帳票の処理概要

`build-diagnostics.json` は、Next.jsのプロダクションビルド中に段階的に更新される診断情報ファイルである。ビルドの各フェーズ（コンパイル、タイプチェック、静的生成等）でステージ情報が更新され、ビルドオプションも追記される。

**業務上の目的・背景**：ビルドが途中で失敗した場合に、どのステージで失敗したかを特定するためのデバッグ情報を提供する。ビルドプロセスは複数の長時間ステージ（Webpackコンパイル、TypeScriptチェック、静的生成等）で構成されるため、失敗箇所の迅速な特定がビルドトラブルシューティングの効率化に直結する。

**帳票の利用シーン**：ビルド失敗時のデバッグ、CI/CDパイプラインでのビルドモニタリング、ビルドパフォーマンス分析。

**主要な出力内容**：
1. buildStage - 現在のビルドステージ名（例：start, compile, compile-server, type-checking, static-generation等）
2. buildOptions - ビルドオプションのキーバリューペア（例：useBuildWorker, experimentalBuildMode等）

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの各フェーズ遷移時にインクリメンタルに更新される。

**帳票の利用者**：開発者（デバッグ時）、CI/CDシステム、ビルドモニタリングツール

## 帳票種別

診断レポート（JSONファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド各フェーズで自動更新 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON（整形出力、インデント2スペース） |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | build-diagnostics.json |
| 出力方法 | ファイルシステムへの書き込み（インクリメンタル更新） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

フラットなJSONオブジェクト構造。buildStageは最新のステージで上書きされ、buildOptionsはマージされる。

```json
{
  "buildStage": "static-generation",
  "buildOptions": {
    "useBuildWorker": "true",
    "experimentalBuildMode": "compile"
  }
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | buildStage | 現在のビルドステージ名 | updateBuildDiagnostics呼び出し時の引数 | 文字列 |
| 2 | buildOptions | ビルドオプション群 | updateBuildDiagnostics呼び出し時の引数 | オブジェクト（key: value） |

### 明細部

buildStageの取りうる値：

| ステージ名 | 説明 | 呼び出し箇所 |
|-----------|------|-------------|
| start | ビルド開始 | build/index.ts L1698 |
| compile | コンパイル開始 | build/index.ts L1746 |
| compile-server | サーバーコンパイル | build/index.ts L1786 |
| webpack-compile-edge-server | Edgeサーバーコンパイル | build/index.ts L1842, L1858 |
| webpack-compile-client | クライアントコンパイル | build/index.ts L1864 |
| type-checking | TypeScriptタイプチェック | build/index.ts L1916 |
| static-generation | 静的ページ生成 | build/index.ts L2911 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |

### ソート順

N/A（インクリメンタル更新のため順序は呼び出し順）

### 改ページ条件

N/A

## データベース参照仕様

N/A（データベースを使用しない）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| buildOptions（マージ） | `{...既存buildOptions, ...新規buildOptions}` | N/A | 既存のbuildOptionsに新規分をスプレッドマージ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build開始] --> B[updateBuildDiagnostics buildStage:start]
    B --> C[コンパイルフェーズ]
    C --> D[updateBuildDiagnostics buildStage:compile]
    D --> E[サーバーコンパイル]
    E --> F[updateBuildDiagnostics buildStage:compile-server]
    F --> G[Edgeサーバーコンパイル]
    G --> H[updateBuildDiagnostics buildStage:webpack-compile-edge-server]
    H --> I[クライアントコンパイル]
    I --> J[updateBuildDiagnostics buildStage:webpack-compile-client]
    J --> K[タイプチェック]
    K --> L[updateBuildDiagnostics buildStage:type-checking]
    L --> M[静的生成]
    M --> N[updateBuildDiagnostics buildStage:static-generation]
    N --> O[ビルド完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 既存ファイル読み込み失敗 | 既存のbuild-diagnostics.jsonが不正なJSON | readFileのcatchで空オブジェクト'{}' にフォールバック | 自動復旧（空オブジェクトから再構築） |
| 書き込み失敗 | diagnosticsディレクトリへの書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一JSONオブジェクト） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき複数回更新されるが、逐次実行） |

## セキュリティ考慮事項

ビルドオプション情報が含まれるが、機密性の高い情報は通常含まれない。

## 備考

- 出力先: `.next/diagnostics/build-diagnostics.json`
- `diagnostics` ディレクトリはgetDiagnosticsDir関数内で `mkdir({ recursive: true })` により自動作成される
- インクリメンタル更新方式：既存ファイルを読み込み、新規情報をマージして上書き
- buildOptionsのマージはシャローマージ（スプレッド演算子）
- JSON.stringify(updatedDiagnostics, null, 2) で整形出力

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

診断情報のインターフェース定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L13-20: `BuildDiagnostics` インターフェース。buildStage（オプショナルstring）とbuildOptions（オプショナルRecord<string, string>） |
| 1-2 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L7-8: 定数定義。DIAGNOSTICS_DIR='diagnostics', DIAGNOSTICS_FILE='build-diagnostics.json' |

**読解のコツ**: BuildDiagnosticsインターフェースの両フィールドはオプショナル。updateBuildDiagnostics関数は部分更新をサポートするため、呼び出し時にbuildStageのみ、またはbuildOptionsのみを指定できる。

#### Step 2: 書き込み処理を理解する

updateBuildDiagnostics関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L22-27: `getDiagnosticsDir` ヘルパー関数。distDirからdiagnosticsディレクトリパスを生成し、mkdir -p で作成 |
| 2-2 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L48-67: `updateBuildDiagnostics` 関数。既存ファイル読み込み→マージ→書き込みの3ステップ |

**主要処理フロー**:
1. **L51**: `getDiagnosticsDir()` - diagnosticsディレクトリのパス取得・作成
2. **L52**: diagnosticsFileパス生成
3. **L54-56**: 既存ファイルの読み込み（失敗時は`{}`にフォールバック）
4. **L57-60**: buildOptionsのシャローマージ
5. **L61-65**: 全体のスプレッドマージ
6. **L66**: `writeFile(diagnosticsFile, JSON.stringify(updatedDiagnostics, null, 2))` - 整形出力で書き込み

#### Step 3: 呼び出し箇所を理解する

ビルドメインフローからの各呼び出し箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | L187-188: updateBuildDiagnosticsインポート |
| 3-2 | index.ts | `packages/next/src/build/index.ts` | L1697-1699: buildStage:'start' |
| 3-3 | index.ts | `packages/next/src/build/index.ts` | L1745-1748: buildStage:'compile' + buildOptions |
| 3-4 | index.ts | `packages/next/src/build/index.ts` | L1785-1787: buildStage:'compile-server' |
| 3-5 | index.ts | `packages/next/src/build/index.ts` | L2910-2912: buildStage:'static-generation' |

#### Step 4: テストを理解する

ユニットテストでの検証内容を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | build-diagnostics.test.ts | `packages/next/src/diagnostics/build-diagnostics.test.ts` | L29-66: updateBuildDiagnosticsのテスト。buildStageの上書き、buildOptionsのマージ、既存オプションの保持を検証 |

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- build/index.ts (メインビルドフロー)
           |
           +-- updateBuildDiagnostics({buildStage: 'start'})
           |
           +-- updateBuildDiagnostics({buildStage: 'compile', buildOptions: {...}})
           |
           +-- updateBuildDiagnostics({buildStage: 'compile-server'})
           |
           +-- updateBuildDiagnostics({buildStage: 'webpack-compile-edge-server'})
           |
           +-- updateBuildDiagnostics({buildStage: 'webpack-compile-client'})
           |
           +-- updateBuildDiagnostics({buildStage: 'type-checking'})
           |
           +-- updateBuildDiagnostics({buildStage: 'static-generation'})

           各呼び出しで:
           diagnostics/build-diagnostics.ts :: updateBuildDiagnostics()
               |
               +-- getDiagnosticsDir()
               +-- readFile(既存ファイル)
               +-- マージ処理
               +-- writeFile(更新済みファイル)
```

### データフロー図

```
[入力]                          [処理]                                   [出力]

build/index.ts                 diagnostics/build-diagnostics.ts
  各フェーズの
  buildStage文字列 ----+
                       +---->  updateBuildDiagnostics()
  buildOptions        -+       (1) 既存ファイル読み込み
  Record<string,string>        (2) シャローマージ         -------->  .next/diagnostics/
                               (3) JSON.stringify(null,2)              build-diagnostics.json
                               (4) writeFile
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | ソース | updateBuildDiagnostics関数定義、BuildDiagnosticsインターフェース |
| build-diagnostics.test.ts | `packages/next/src/diagnostics/build-diagnostics.test.ts` | テスト | updateBuildDiagnosticsのユニットテスト |
| index.ts | `packages/next/src/build/index.ts` | ソース | updateBuildDiagnosticsの呼び出し元（複数箇所） |
