# 帳票設計書 27-framework.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `framework.json` の設計仕様を定義する。このファイルはビルドに使用されたNext.jsフレームワークのバージョン情報を記録するJSONファイルである。

### 本帳票の処理概要

`framework.json` は、Next.jsのプロダクションビルド開始時に生成される診断情報ファイルで、ビルドに使用されたNext.jsの名前とバージョン番号を記録する。

**業務上の目的・背景**：ビルド成果物からどのバージョンのNext.jsでビルドされたかを追跡可能にするための情報を提供する。デプロイ環境でのトラブルシューティング時に、使用されたフレームワークバージョンの特定が迅速に行える。異なるビルド間でのバージョン差異の検出にも利用できる。

**帳票の利用シーン**：ビルド成果物の検証時、デプロイ環境でのバージョン確認時、ビルド再現性の検証時。

**主要な出力内容**：
1. name - フレームワーク名（固定値 "Next.js"）
2. version - Next.jsのバージョン番号

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの最初期段階で、distDirのpackage.json生成直後に生成される。

**帳票の利用者**：開発者、デプロイプラットフォーム、CI/CDシステム

## 帳票種別

診断レポート（JSONファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行時に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | framework.json |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

2プロパティのみの最小限なJSONオブジェクト。

```json
{"name":"Next.js","version":"14.2.3"}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | name | フレームワーク名 | ハードコード値（"Next.js"） | 文字列 |
| 2 | version | フレームワークバージョン | `process.env.__NEXT_VERSION` | 文字列（セマンティックバージョニング） |

### 明細部

N/A

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |

### ソート順

N/A

### 改ページ条件

N/A

## データベース参照仕様

N/A（データベースを使用しない）

## 計算仕様

N/A（環境変数とハードコード値のみ使用）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build開始] --> B[distDirクリーニング]
    B --> C[package.json生成]
    C --> D[recordFrameworkVersion呼び出し]
    D --> E[getDiagnosticsDir でディレクトリ作成]
    E --> F[JSON.stringify で version情報シリアライズ]
    F --> G[diagnostics/framework.json に書き込み]
    G --> H[updateBuildDiagnostics呼び出し]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | diagnosticsディレクトリへの書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一JSONオブジェクト、約50バイト程度） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき1回） |

## セキュリティ考慮事項

フレームワークの名前とバージョンのみ含むため、セキュリティ上のリスクは限定的。ただし、使用バージョンの特定により既知の脆弱性への攻撃の手がかりとなる可能性がある。

## 備考

- 出力先: `.next/diagnostics/framework.json`
- `diagnostics` ディレクトリは `getDiagnosticsDir` 関数内で自動作成される
- バージョン情報は `process.env.__NEXT_VERSION` から取得される
- JSON.stringify でシリアライズ（整形なし、1行出力）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力データは `{ name: 'Next.js', version: string }` の単純なオブジェクト。専用のインターフェース定義はない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L11: `FRAMEWORK_VERSION_FILE = 'framework.json'` 定数定義 |

#### Step 2: 生成処理を理解する

recordFrameworkVersion関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L32-38: `recordFrameworkVersion` 関数。version引数を受け取り、{name: 'Next.js', version}をJSONシリアライズして書き込む |

**主要処理フロー**:
1. **L33**: `getDiagnosticsDir()` - diagnosticsディレクトリのパス取得・作成
2. **L34**: `join(diagnosticsDir, FRAMEWORK_VERSION_FILE)` - ファイルパス生成
3. **L35-38**: `writeFile(frameworkVersionFile, JSON.stringify({ name: 'Next.js', version }))` - 書き込み

#### Step 3: 呼び出し箇所を理解する

ビルドメインフローからの呼び出しを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | L186: `recordFrameworkVersion` インポート |
| 3-2 | index.ts | `packages/next/src/build/index.ts` | L1696: `recordFrameworkVersion(process.env.__NEXT_VERSION as string)` 呼び出し |

#### Step 4: テストを理解する

ユニットテストでの検証内容を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | build-diagnostics.test.ts | `packages/next/src/diagnostics/build-diagnostics.test.ts` | L17-27: recordFrameworkVersionのテスト。バージョン'14.2.3'を記録し、ファイルから読み取って検証 |

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- build/index.ts (メインビルドフロー)
           |
           +-- writeFileUtf8(distDir/package.json)
           |
           +-- recordFrameworkVersion(process.env.__NEXT_VERSION)  <-- 呼び出し
           |      |
           |      +-- getDiagnosticsDir()
           |      |      +-- traceGlobals.get('distDir')
           |      |      +-- mkdir(diagnosticsDir, {recursive: true})
           |      |
           |      +-- writeFile(framework.json)
           |
           +-- updateBuildDiagnostics({buildStage: 'start'})
```

### データフロー図

```
[入力]                          [処理]                                [出力]

process.env.__NEXT_VERSION     diagnostics/build-diagnostics.ts
  (例: "14.2.3")        ----->  recordFrameworkVersion()
                                JSON.stringify({               -----> .next/diagnostics/
                                  name: 'Next.js',                     framework.json
                                  version: version
                                })
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | ソース | recordFrameworkVersion関数定義（L32-38） |
| build-diagnostics.test.ts | `packages/next/src/diagnostics/build-diagnostics.test.ts` | テスト | recordFrameworkVersionのユニットテスト（L17-27） |
| index.ts | `packages/next/src/build/index.ts` | ソース | recordFrameworkVersionの呼び出し元（L1696） |
