# 帳票設計書 29-incremental-build-diagnostics.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `incremental-build-diagnostics.json` の設計仕様を定義する。このファイルはインクリメンタルビルドの診断情報（変更/未変更パス・依存関係変更・Git SHA等）を記録するJSONレポートである。

### 本帳票の処理概要

`incremental-build-diagnostics.json` は、Next.jsのインクリメンタルビルド（実験的機能）時に生成される診断情報ファイルで、前回ビルドからの変更/未変更パスの分類、依存関係の変更状況、Git SHAの記録などを行う。

**業務上の目的・背景**：大規模なNext.jsアプリケーションでは、全ページの再ビルドに長時間かかるため、変更されたページのみを再ビルドするインクリメンタルビルド機能が提供されている。この診断ファイルにより、インクリメンタルビルドの判定結果（どのパスが変更扱いか、どの依存関係が変更されたか）を追跡でき、ビルドの正確性と効率性の検証に活用できる。

**帳票の利用シーン**：インクリメンタルビルドのデバッグ時、ビルドキャッシュの有効性検証時、CI/CDパイプラインでのビルド最適化分析時。

**主要な出力内容**：
1. changedAppPaths - 変更されたApp Routerパスのリスト
2. unchangedAppPaths - 未変更のApp Routerパスのリスト
3. changedPagePaths - 変更されたPages Routerパスのリスト
4. unchangedPagePaths - 未変更のPages Routerパスのリスト
5. changedDependencies - 変更された依存関係のレコード（パッケージ名: バージョン）
6. shuttleGitSha - 前回ビルドのGit SHA（shuttle機能使用時）
7. currentGitSha - 現在のGit SHA

**帳票の出力タイミング**：`next build` コマンドのインクリメンタルビルドフェーズで、変更検出後にインクリメンタルに更新される。

**帳票の利用者**：開発者（インクリメンタルビルドのデバッグ時）、CI/CDシステム

## 帳票種別

診断レポート（JSONファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build`（インクリメンタルビルドモード時） | 変更検出後に自動生成・更新 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON（整形出力、インデント2スペース） |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | incremental-build-diagnostics.json |
| 出力方法 | ファイルシステムへの書き込み（インクリメンタル更新） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

フラットなJSONオブジェクト構造。全フィールドがオプショナル。

```json
{
  "changedAppPaths": ["/app/page1", "/app/page2"],
  "unchangedAppPaths": ["/app/page3"],
  "changedPagePaths": ["/pages/about"],
  "unchangedPagePaths": ["/pages/index"],
  "changedDependencies": {
    "react": "18.3.0",
    "next": "14.2.3"
  },
  "shuttleGitSha": "abc123",
  "currentGitSha": "def456"
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | changedAppPaths | 変更されたApp Routerパス | インクリメンタルビルド変更検出 | 文字列配列 |
| 2 | unchangedAppPaths | 未変更のApp Routerパス | インクリメンタルビルド変更検出 | 文字列配列 |
| 3 | changedPagePaths | 変更されたPages Routerパス | インクリメンタルビルド変更検出 | 文字列配列 |
| 4 | unchangedPagePaths | 未変更のPages Routerパス | インクリメンタルビルド変更検出 | 文字列配列 |
| 5 | changedDependencies | 変更された依存関係 | 依存関係比較結果 | Record<string, string> |
| 6 | shuttleGitSha | 前回ビルドのGit SHA | shuttle機能からの取得 | 文字列 |
| 7 | currentGitSha | 現在のGit SHA | git rev-parseの結果 | 文字列 |

### 明細部

N/A

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | `next build` コマンドが実行されていること | Yes |
| インクリメンタルビルドモード | インクリメンタルビルド機能が有効化されていること | Yes |

### ソート順

N/A

### 改ページ条件

N/A

## データベース参照仕様

N/A（データベースを使用しない）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| マージ処理 | `{...既存diagnostics, ...新規diagnostics}` | N/A | 既存ファイルにスプレッドマージ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[インクリメンタルビルド開始] --> B[前回ビルド結果読み込み]
    B --> C[変更検出処理]
    C --> D[updateIncrementalBuildMetrics呼び出し]
    D --> E[getDiagnosticsDir でディレクトリ作成]
    E --> F[既存ファイル読み込み]
    F --> G[スプレッドマージ]
    G --> H[JSON.stringify null,2 で整形]
    H --> I[diagnostics/incremental-build-diagnostics.jsonに書き込み]
    I --> J[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 既存ファイル読み込み失敗 | 既存ファイルが存在しないまたは不正なJSON | readFileのcatchで空オブジェクト'{}' にフォールバック | 自動復旧 |
| 書き込み失敗 | diagnosticsディレクトリへの書き込み権限なし | ファイルシステムエラー | distDirのパーミッション確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（パスリストのサイズはアプリケーション規模に依存） |
| 目標出力時間 | ミリ秒オーダー |
| 同時出力数上限 | 1（ビルドプロセスにつき複数回更新されるが、逐次実行） |

## セキュリティ考慮事項

- アプリケーションのルーティング構造（ページパス一覧）が含まれる
- Git SHA情報が含まれる（リポジトリ構造の手がかりとなる可能性）
- 依存関係のバージョン情報が含まれる（脆弱性ターゲティングの手がかりとなる可能性）

## 備考

- 出力先: `.next/diagnostics/incremental-build-diagnostics.json`
- インクリメンタル更新方式：build-diagnostics.jsonと同様に、既存ファイルを読み込んでスプレッドマージする
- IncrementalBuildDiagnosticsインターフェースの全フィールドはオプショナル
- shuttle機能はNext.jsの実験的機能で、ビルド成果物の再利用を可能にする

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IncrementalBuildDiagnosticsインターフェースの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L10: `INCREMENTAL_BUILDS_FILE = 'incremental-build-diagnostics.json'` 定数定義 |
| 1-2 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L88-96: `IncrementalBuildDiagnostics` インターフェース。7つのオプショナルフィールド |

**読解のコツ**: IncrementalBuildDiagnosticsの全フィールドはオプショナル（`?` 付き）。updateIncrementalBuildMetrics関数は部分更新をサポートするため、呼び出し時に必要なフィールドのみを指定する。

#### Step 2: 書き込み処理を理解する

updateIncrementalBuildMetrics関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | L101-116: `updateIncrementalBuildMetrics` 関数。既存ファイル読み込み→スプレッドマージ→書き込みの3ステップ |

**主要処理フロー**:
1. **L104**: `getDiagnosticsDir()` - diagnosticsディレクトリのパス取得・作成
2. **L105**: diagnosticsFileパス生成
3. **L107-109**: 既存ファイルの読み込み（失敗時は`{}`にフォールバック）
4. **L111-114**: スプレッドマージ `{...existingDiagnostics, ...diagnostics}`
5. **L115**: `writeFile(diagnosticsFile, JSON.stringify(updatedDiagnostics, null, 2))` - 整形出力で書き込み

#### Step 3: 呼び出し箇所を理解する

ビルドメインフローからの呼び出しを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/index.ts` | updateIncrementalBuildMetricsの呼び出し箇所（インクリメンタルビルド処理内） |

### プログラム呼び出し階層図

```
next build (CLI) [インクリメンタルモード]
    |
    +-- build/index.ts (メインビルドフロー)
           |
           +-- インクリメンタルビルド変更検出
           |
           +-- updateIncrementalBuildMetrics({
           |      changedAppPaths: [...],
           |      unchangedAppPaths: [...],
           |      changedDependencies: {...},
           |      currentGitSha: "..."
           |   })
           |      |
           |      +-- getDiagnosticsDir()
           |      +-- readFile(既存ファイル)
           |      +-- スプレッドマージ
           |      +-- writeFile(更新済みファイル)
```

### データフロー図

```
[入力]                              [処理]                                [出力]

インクリメンタルビルド
  変更検出結果:
    changedAppPaths -----+
    unchangedAppPaths ---+
    changedPagePaths ----+
    unchangedPagePaths --+---->  updateIncrementalBuildMetrics()
    changedDependencies -+       (1) 既存ファイル読み込み
    shuttleGitSha -------+       (2) スプレッドマージ      -------->  .next/diagnostics/
    currentGitSha -------+       (3) JSON.stringify(null,2)            incremental-build-
                                 (4) writeFile                         diagnostics.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build-diagnostics.ts | `packages/next/src/diagnostics/build-diagnostics.ts` | ソース | updateIncrementalBuildMetrics関数定義（L101-116）、IncrementalBuildDiagnosticsインターフェース（L88-96） |
| index.ts | `packages/next/src/build/index.ts` | ソース | updateIncrementalBuildMetricsの呼び出し元 |
