# 帳票設計書 30-trace-build

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `trace-build` の設計仕様を定義する。このファイルはビルド時のトレースイベント（各フェーズの開始・終了・所要時間）をJSON Lines形式で記録するファイルである。

### 本帳票の処理概要

`trace-build` は、Next.jsのプロダクションビルド時に生成されるトレースファイルで、ビルドの各フェーズ（Webpackコンパイル、TypeScriptチェック、静的生成等）のパフォーマンスイベントをJSON Lines形式で記録する。許可リスト（allowlist）に含まれる特定のイベントのみが記録対象となる。

**業務上の目的・背景**：ビルドパフォーマンスの分析と最適化のために、各ビルドフェーズの所要時間を正確に計測・記録する必要がある。このトレースファイルにより、ビルドのボトルネック特定、ビルド時間の推移分析、CI/CDパイプラインでのビルドパフォーマンスモニタリングが可能となる。

**帳票の利用シーン**：ビルドパフォーマンス分析時、ビルド最適化のためのボトルネック特定時、CI/CDでのビルド時間モニタリング時。

**主要な出力内容**：
1. トレースイベントの配列（各行がJSONシリアライズされたイベント配列）
2. 各イベントにはイベント名、ID、タイムスタンプ、所要時間、traceId等が含まれる

**帳票の出力タイミング**：`next build` コマンドによるプロダクションビルドの各フェーズでイベントが発生するたびにバッチ処理で書き込まれる。ビルド完了時にflushAllで残りのイベントが書き出される。

**帳票の利用者**：開発者（パフォーマンス分析時）、CI/CDシステム、ビルドモニタリングツール、trace-uploaderモジュール

## 帳票種別

トレース（JSON Linesファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド中に自動的にイベント記録 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON Lines（各行がJSON配列） |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | trace-build |
| 出力方法 | RotatingWriteStreamによるストリーミング書き込み |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

JSON Lines形式。各行はTraceEventの配列をJSONシリアライズしたもの。

```
[{"traceId":"abc123","name":"next-build","id":1,"timestamp":1706000000,"duration":5000}]
[{"traceId":"abc123","name":"run-webpack","id":2,"timestamp":1706000001,"duration":3000,"parentId":1}]
```

### 明細部（TraceEvent型の各項目）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | traceId | トレースセッションの識別子 | traceId（trace/shared.tsから取得） | 文字列 |
| 2 | parentId | 親イベントのID（オプショナル） | TraceEvent.parentId | 整数 |
| 3 | name | イベント名 | TraceEvent.name | 文字列 |
| 4 | id | イベントの一意識別子 | TraceEvent.id | 整数 |
| 5 | timestamp | イベント発生タイムスタンプ | TraceEvent.timestamp | 整数（ミリ秒） |
| 6 | duration | イベント所要時間 | TraceEvent.duration | 整数（ミリ秒） |
| 7 | tags | イベントに付与されたタグ情報（オプショナル） | TraceEvent.tags | オブジェクト |
| 8 | startTime | イベント開始時刻（オプショナル） | TraceEvent.startTime | 整数 |

### 記録対象イベント一覧（allowlistedEvents）

| No | イベント名 | 説明 |
|----|-----------|------|
| 1 | next-build | ビルド全体のイベント |
| 2 | run-turbopack | Turbopackビルド実行 |
| 3 | run-webpack | Webpackビルド実行 |
| 4 | run-typescript | TypeScriptコンパイル |
| 5 | run-eslint | ESLint実行 |
| 6 | static-check | 静的チェック |
| 7 | collect-build-traces | ビルドトレース収集 |
| 8 | static-generation | 静的ページ生成 |
| 9 | output-export-full-static-export | 完全静的エクスポート出力 |
| 10 | adapter-handle-build-complete | アダプタービルド完了ハンドリング |
| 11 | output-standalone | スタンドアロン出力 |
| 12 | telemetry-flush | テレメトリフラッシュ |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロダクションビルド | phase === PHASE_PRODUCTION_BUILD であること | Yes |
| 許可リスト | イベント名がallowlistedEventsに含まれること | Yes |
| distDir/phase設定 | traceGlobals に distDir と phase が設定されていること | Yes |

### ソート順

N/A（イベント発生順に追記）

### 改ページ条件

N/A

## データベース参照仕様

N/A（データベースを使用しない）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| サイズ制限 | 開発モード: 52428800（50MB）、本番ビルド: Infinity（無制限） | N/A | RotatingWriteStreamのsizeLimit |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[トレースイベント発生] --> B{イベント名がallowlistに含まれる?}
    B -->|No| C[スキップ]
    B -->|Yes| D{distDir/phase設定済み?}
    D -->|No| C
    D -->|Yes| E{phase === PHASE_PRODUCTION_BUILD?}
    E -->|No| C
    E -->|Yes| F{batch初期化済み?}
    F -->|No| G[batch/RotatingWriteStream初期化]
    G --> H[イベントをバッチに追加]
    F -->|Yes| H
    H --> I{バッチサイズ > 100?}
    I -->|Yes| J[バッチフラッシュ: JSON.stringify + writeStream.write]
    I -->|No| K[バッチに蓄積]
    J --> L[ビルド完了時にflushAll]
    K --> L
    L --> M[writeStream.end]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込み失敗 | ファイルシステムエラー | `console.log(err)` でエラー出力 | ログ確認後にdistDirのパーミッション確認 |
| ファイルローテーション | ファイルサイズが制限を超過 | N/A（自動ローテーション） | 開発モードでは50MB超過時に自動ローテーション |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ビルドフェーズ数に依存（12種類のイベント x 複数回） |
| 目標出力時間 | 非同期ストリーミング書き込みのため、ビルドをブロックしない |
| 同時出力数上限 | 1（シングルWriteStream） |
| サイズ制限 | 開発モード: 50MB、本番ビルド: 無制限 |

## セキュリティ考慮事項

- ビルドフェーズの所要時間情報が含まれるが、機密情報は通常含まれない
- tagsプロパティにビルド設定情報が含まれる可能性がある

## 備考

- 出力先: `.next/trace-build`
- ファイル拡張子なし
- RotatingWriteStreamクラスによるサイズ制限付きストリーミング書き込み
- バッチ処理: イベントは100件ごとにフラッシュ、残りはflushAll時に書き出し
- `to-json-build.ts` は `to-json.ts` のbatcher関数を再利用している
- 開発サーバー用の通常トレース（`trace`ファイル）とは別に、ビルド専用のイベントフィルタリングが行われる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TraceEvent型の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.ts | `packages/next/src/trace/types.ts` | L1-18: `TraceEvent` 型定義。traceId, parentId, name, id, timestamp, duration, tags, startTimeの8フィールド |

**読解のコツ**: TraceEvent型のフィールドの多くはオプショナル。traceIdはreportToJsonBuild関数内でスプレッド演算子で追加される。

#### Step 2: バッチ処理の仕組みを理解する

共通のbatcher関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | to-json.ts | `packages/next/src/trace/report/to-json.ts` | L8-32: `batcher` 関数。events配列にイベントを蓄積し、100件超でフラッシュ。flushAll()で残りを書き出す |

**主要処理フロー**:
1. **L9**: `events` 配列でイベントをバッファ
2. **L10-11**: `queue` Setでフラッシュ中のPromiseを管理
3. **L20-29**: `report` メソッド。イベント追加後、100件超でフラッシュ
4. **L13-18**: `flushAll` メソッド。queue内の全Promiseを待ち、残りイベントを書き出す

#### Step 3: RotatingWriteStreamを理解する

ファイルサイズ制限付きの書き込みストリームを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | to-json-build.ts | `packages/next/src/trace/report/to-json-build.ts` | L18-75: `RotatingWriteStream` クラス。ファイルサイズがsizeLimitを超えるとファイルを再作成（ローテーション） |

**主要処理フロー**:
- **L25-30**: コンストラクタ。file, size(0), sizeLimitを初期化
- **L35-48**: `rotate()` メソッド。end→unlink→再作成
- **L49-68**: `write()` メソッド。サイズ超過時にrotate、backpressure時にdrainを待つ

#### Step 4: イベントフィルタリングとレポート処理を理解する

reportToJsonBuild関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | to-json-build.ts | `packages/next/src/trace/report/to-json-build.ts` | L77-90: `allowlistedEvents` Set。12個の許可されたイベント名 |
| 4-2 | to-json-build.ts | `packages/next/src/trace/report/to-json-build.ts` | L92-132: `reportToJsonBuild` 関数。イベントフィルタリング→batch初期化→レポート |

**主要処理フロー**:
1. **L93**: `allowlistedEvents.has(event.name)` - イベント名チェック
2. **L97-101**: `traceGlobals.get('distDir')` / `traceGlobals.get('phase')` - グローバル設定確認
3. **L104**: `phase !== PHASE_PRODUCTION_BUILD` - 本番ビルドのみ記録
4. **L108-126**: batch未初期化時の初期化処理。RotatingWriteStream作成（本番はInfinity、開発は50MB制限）
5. **L128-131**: `batch.report({...event, traceId})` - traceId付与してバッチに追加

#### Step 5: フラッシュ処理を理解する

ビルド完了時のフラッシュ処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | to-json-build.ts | `packages/next/src/trace/report/to-json-build.ts` | L134-146: エクスポートされるflushAllとreport。flushAll()はbatch.flushAll()後にwriteStream.end()を呼ぶ |

### プログラム呼び出し階層図

```
next build (CLI)
    |
    +-- trace/report/to-json-build.ts :: reportToJsonBuild()
    |      |
    |      +-- allowlistedEvents.has(event.name)  <-- フィルタ
    |      +-- traceGlobals チェック
    |      +-- PHASE_PRODUCTION_BUILD チェック
    |      |
    |      +-- batcher (from to-json.ts)
    |      |      +-- events[] バッファ
    |      |      +-- 100件超でフラッシュ
    |      |
    |      +-- RotatingWriteStream
    |             +-- fs.createWriteStream
    |             +-- サイズ制限チェック
    |             +-- ローテーション (開発モード)
    |
    +-- flushAll() [ビルド完了時]
           +-- batch.flushAll()
           +-- writeStream.end()
```

### データフロー図

```
[入力]                           [処理]                              [出力]

ビルドフェーズの
  TraceEvent ----+
    name         |
    id           +---> reportToJsonBuild()
    timestamp    |     (1) allowlist フィルタ
    duration     |     (2) phase チェック
    parentId     |     (3) traceId 付与
    tags         |     (4) batch.report()        -------->  .next/trace-build
                 |                                          (JSON Lines形式)
                 |     batcher()
                 |     (5) 100件バッファ
                 |     (6) フラッシュ時にJSON.stringify
                 |
                 |     RotatingWriteStream
                 +     (7) ストリーミング書き込み
                       (8) サイズ制限付きローテーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.ts | `packages/next/src/trace/types.ts` | ソース | TraceEvent型定義 |
| to-json-build.ts | `packages/next/src/trace/report/to-json-build.ts` | ソース | reportToJsonBuild関数、RotatingWriteStream、allowlistedEvents定義 |
| to-json.ts | `packages/next/src/trace/report/to-json.ts` | ソース | batcher関数（共通バッチ処理）、通常トレース用のReportToJson |
| trace-uploader.ts | `packages/next/src/trace/trace-uploader.ts` | ソース | トレースファイルのアップロード処理 |
| collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | ソース | ビルドトレース収集処理（trace-buildファイルを参照） |
| shared.ts | `packages/next/src/trace/shared.ts` | ソース | traceGlobals, traceIdの管理 |
