# 帳票設計書 31-*.nft.json

## 概要

本ドキュメントは、Next.jsビルド時に各サーバーサイドエントリポイントごとに生成されるNode File Trace（NFT）情報ファイル `*.nft.json` の設計仕様を定義する。

### 本帳票の処理概要

本帳票は、Next.jsのビルドプロセスにおいて、各サーバーサイドエントリポイント（ページ・APIルート・App Routerルートなど）が実行時に依存するファイルの一覧をJSON形式で記録するものである。

**業務上の目的・背景**：Next.jsのスタンドアロンデプロイ（`output: 'standalone'`）や各種ホスティングプラットフォームへのデプロイでは、各ルートが実行時に必要とするファイルを正確に把握する必要がある。NFTファイルは `@vercel/nft`（Node File Trace）ライブラリを使用して静的解析を行い、各エントリポイントの依存ファイルツリーを構築することで、デプロイ時に不要なファイルを除外し、最小限のファイルセットのみを含むデプロイパッケージを作成可能にする。

**帳票の利用シーン**：本帳票は以下の場面で利用される。(1) スタンドアロンデプロイ時にコピーすべきファイルの特定、(2) サーバーレス関数のデプロイ時に各関数に含めるべきファイルの特定、(3) ビルドの最適化やデバッグ時の依存関係調査。

**主要な出力内容**：
1. バージョン情報（`version`フィールド、現在は`1`固定）
2. 依存ファイルパスの配列（`files`フィールド、出力ファイルからの相対パス）
3. ファイルハッシュ情報（`fileHashes`フィールド、webpackプラグイン段階で付与）

**帳票の出力タイミング**：`next build` コマンド実行時のビルドプロセス中、webpackのPROCESS_ASSETS_STAGE_SUMMARIZEステージでTraceEntryPointsPluginにより初期出力され、その後collectBuildTraces関数によりnodeFileTraceの結果がマージされる。

**帳票の利用者**：デプロイシステム（Vercelプラットフォーム等）、DevOpsエンジニア、Next.jsフレームワーク内部のデプロイ関連処理。

## 帳票種別

データマニフェスト（JSON形式のビルドアーティファクト）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（ファイル出力） |
| 向き | N/A |
| ファイル名 | `{entryName}.js.nft.json`（例: `pages/index.js.nft.json`, `app/page.js.nft.json`） |
| 出力方法 | ファイルシステムへの書き込み |
| 文字コード | UTF-8 |

### PDF固有設定

N/A（JSON形式のため該当なし）

### Excel固有設定

N/A（JSON形式のため該当なし）

## 帳票レイアウト

### レイアウト概要

JSONオブジェクトとして以下の構造を持つ。

```json
{
  "version": 1,
  "files": [
    "../../node_modules/react/index.js",
    "../../node_modules/react-dom/server.js",
    "../chunks/123.js"
  ]
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | NFTフォーマットのバージョン番号 | TRACE_OUTPUT_VERSION定数 | 整数（現在は`1`固定） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | files | 依存ファイルパスの配列 | nodeFileTrace結果 + webpack entryFilesMap | 相対パス文字列の配列 | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | - | フッター部は存在しない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| エントリポイントの種別 | pages/ または app/ で始まるサーバーサイドエントリポイント | Yes |
| 静的ページの除外 | 自動的に静的最適化されたページは対象外（サーバーバンドル不要のため） | Yes |
| エッジランタイムの除外 | エッジランタイムを使用するルートはトレースファイル不要 | Yes |
| トレース対象外ファイルの除外 | .wasm, .png, .jpg等のバイナリファイルはトレース対象外 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ファイルパス | 昇順（アルファベット順） |

### 改ページ条件

N/A（JSON出力のため改ページは存在しない）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースは使用しない。ファイルシステムのみを参照する）

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 依存ファイルパス | path.relative(traceOutputDir, filePath).replace(/\\\\/g, '/') | N/A | 出力ファイルからの相対パスに変換 |
| 無視判定 | shouldIgnore(file, ignoreFn, reasons, cachedIgnore) | N/A | 親ファイルがすべて無視対象の場合、子ファイルも無視 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build 実行] --> B[webpack コンパイル開始]
    B --> C[TraceEntryPointsPlugin: finishModules]
    C --> D[nodeFileTrace でエントリの依存解析]
    D --> E[entryTraces にエントリ別依存を記録]
    E --> F[TraceEntryPointsPlugin: createTraceAssets]
    F --> G[各エントリの *.nft.json を webpack アセットとして出力]
    G --> H[collectBuildTraces 関数呼び出し]
    H --> I[サーバーチャンクの追加 nodeFileTrace 実行]
    I --> J[既存の *.nft.json を読み込みマージ]
    J --> K[outputFileTracingIncludes/Excludes 適用]
    K --> L[最終 *.nft.json をファイルシステムに書き込み]
    L --> M[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイル読み取りエラー | トレース中にファイルが削除された場合（ENOENT） | エラーを抑制し空文字列を返す | 静的生成と並列実行のため許容 |
| readlinkエラー | シンボリックリンクの解決に失敗（EINVAL/ENOENT） | エラーを抑制しnullを返す | 通常ファイルとして処理 |
| statエラー | ファイルメタデータの取得に失敗（ENOENT/ENOTDIR） | エラーを抑制しnullを返す | ファイルが存在しないものとして扱う |
| モジュール解決エラー | 外部モジュールの解決に失敗 | `failed to resolve {request} from {parent}` | 依存関係の確認が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数千ファイル/エントリポイント |
| 目標出力時間 | ビルドプロセス全体の一部として数秒〜数十秒 |
| 同時出力数上限 | エントリポイント数に依存（Promise.allで並列処理） |

## セキュリティ考慮事項

NFTファイルはファイルパス情報のみを含み、ファイル内容は含まない。ただし、ファイルパスからプロジェクト構造が推測可能なため、本番環境でのNFTファイルの公開は避けるべきである。NFTファイルはビルド成果物ディレクトリ（`.next/server/`）内に格納され、通常のリクエストではアクセスできない。

## 備考

- `TRACE_OUTPUT_VERSION`定数は現在`1`で定義されている（`packages/next/src/shared/lib/constants.ts` 行171）
- `outputFileTracingIncludes`/`outputFileTracingExcludes`設定により、ユーザーがトレース対象をカスタマイズ可能
- CI環境（`hasNextSupport`）では一部のトレース対象が変更される（例: sharp, image-optimizer等の除外）
- スタンドアロンモード（`output: 'standalone'`）ではjest-workerのプロセス・スレッド子ファイルも含まれる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、NFTファイルの構造と関連する定数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | TRACE_OUTPUT_VERSION（行171）の値が`1`であること |
| 1-2 | next-trace-entrypoints-plugin.ts | `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` | BuildTraceContext型（行112-126）でエントリ間データの受け渡し構造を把握 |

**読解のコツ**: NFTファイルの基本構造は `{ version: number, files: string[] }` というシンプルなJSON。`files`は出力ファイルからの相対パスの配列。

#### Step 2: エントリーポイントを理解する

webpackプラグインとしての初期トレース処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-trace-entrypoints-plugin.ts | `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` | TraceEntryPointsPluginクラス（行128-797）がwebpackプラグインとして動作 |

**主要処理フロー**:
1. **行577-795**: `apply()`メソッドでwebpackコンパイラにフックを登録
2. **行300-298**: `tapfinishModules()`でモジュール依存解析を実行し、`nodeFileTrace`で全エントリのファイル依存を収集
3. **行173-298**: `createTraceAssets()`で各エントリポイントの`*.nft.json`をwebpackアセットとして出力

#### Step 3: ビルドトレース収集処理を理解する

webpack出力後の追加トレース処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | collectBuildTraces関数（行93-674）がメイン処理 |

**主要処理フロー**:
- **行93-112**: 関数パラメータで設定情報を受け取る
- **行295-300**: `nodeFileTrace`でサーバーチャンクの依存を追加解析
- **行412-487**: 既存の`*.nft.json`に新しいトレース結果をマージして書き戻し
- **行548-671**: `outputFileTracingIncludes`/`outputFileTracingExcludes`設定を適用

#### Step 4: 無視ルールの仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | makeIgnoreFn（行28-42）とshouldIgnore（行44-91）による階層的な無視判定ロジック |

**主要処理フロー**:
- **行28-42**: `makeIgnoreFn`でpicomatchパターンから無視判定関数を生成
- **行44-91**: `shouldIgnore`で親ファイルの無視状態を再帰的にチェック。全親が無視対象なら子も無視。

### プログラム呼び出し階層図

```
next build (packages/next/src/build/index.ts)
    │
    ├─ webpack コンパイル
    │      └─ TraceEntryPointsPlugin (next-trace-entrypoints-plugin.ts)
    │             ├─ tapfinishModules() → nodeFileTrace() でエントリ依存解析
    │             └─ createTraceAssets() → *.nft.json をアセット出力
    │
    └─ collectBuildTraces() (collect-build-traces.ts)
           ├─ nodeFileTrace() でサーバーチャンク追加解析
           ├─ 既存 *.nft.json の読み込み・マージ・書き戻し
           ├─ next-server.js.nft.json の出力
           ├─ next-minimal-server.js.nft.json の出力
           └─ outputFileTracingIncludes/Excludes の適用
```

### データフロー図

```
[入力]                          [処理]                              [出力]

webpackエントリポイント ──────▶ TraceEntryPointsPlugin          ──▶ *.nft.json (初期版)
                               nodeFileTrace()                       ↓
サーバーチャンクファイル ──────▶ collectBuildTraces()            ──▶ *.nft.json (マージ版)
                               nodeFileTrace()                       ↓
next.config.js                  outputFileTracing                ──▶ *.nft.json (最終版)
(includes/excludes設定) ──────▶ Includes/Excludes適用

                                                                ──▶ next-server.js.nft.json
                                                                ──▶ next-minimal-server.js.nft.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next-trace-entrypoints-plugin.ts | `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` | ソース | webpackプラグインとしてのトレース処理・初期NFT出力 |
| collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | ソース | ビルド後のトレース収集・NFTマージ処理 |
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | TRACE_OUTPUT_VERSION定数の定義 |
| index.ts | `packages/next/src/build/index.ts` | ソース | ビルドメイン処理からcollectBuildTracesを呼び出し |
| build-complete.ts | `packages/next/src/build/adapter/build-complete.ts` | ソース | ビルド完了アダプタ処理 |
| utils.ts | `packages/next/src/build/utils.ts` | ソース | RoutesUsingEdgeRuntime型等のユーティリティ |
