# 帳票設計書 4-app-path-routes-manifest.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `app-path-routes-manifest.json` の設計を記述する。このマニフェストは、App Routerのアプリケーションパス（内部パス）とルートパス（正規化されたURLパス）の対応関係を定義する。

### 本帳票の処理概要

app-path-routes-manifest.json は、ビルドプロセスの後半で `app-paths-manifest.json` を読み込み、各キー（アプリケーションパス）を `normalizeAppPath` 関数で正規化したルートパスに変換して生成されるJSONファイルである。

**業務上の目的・背景**：App Routerの内部パスは、グループルート `(group)`、パラレルルート `@slot`、インターセプトルート `(.)`等の特殊構文を含む。これらの内部パスは、実際のURLルーティングでは正規化される必要がある。本マニフェストは、内部パスからURL上のルートパスへの変換テーブルを提供し、サーバーのルーティング処理を支援する。

**帳票の利用シーン**：サーバーサイドでのApp Routerルーティング解決時、ビルドプロセスにおけるページ分析・静的生成対象の決定時、デプロイメントプラットフォームでのルーティング設定時に使用される。

**主要な出力内容**：
1. App Router内部パス（キー）とURL上のルートパス（値）の対応関係
2. グループルート・パラレルルート・インターセプトルート等の正規化結果

**帳票の出力タイミング**：`next build` コマンド実行時、Webpackコンパイル完了後のビルド後処理フェーズで `app-paths-manifest.json` を読み込み、変換して出力される。

**帳票の利用者**：Next.jsサーバーランタイム、ビルドプロセス内の静的解析フェーズ、デプロイメントプラットフォーム。

## 帳票種別

ビルドマニフェスト（JSON形式のルート変換マッピングファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルドコマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `app-path-routes-manifest.json` |
| 出力方法 | ファイルシステムへの書き出し（`.next/app-path-routes-manifest.json`） |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

フラットなJSONオブジェクトで、App Router内部パスをキーとし、正規化されたルートパスを値とする。

```
{
  "/page": "/",
  "/about/page": "/about",
  "/(marketing)/blog/page": "/blog",
  "/dashboard/@analytics/page": "/dashboard",
  "/api/hello/route": "/api/hello"
}
```

### ヘッダー部

N/A

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 内部パス（キー） | App Routerの内部パス | `app-paths-manifest.json` のキー | 文字列 | N/A |
| 2 | ルートパス（値） | 正規化されたURLパス | `normalizeAppPath(key)` の返却値 | 文字列 | N/A |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| App Router有効 | `appDir` が存在する場合のみ生成 | Yes |
| app-paths-manifest存在 | 事前にapp-paths-manifest.jsonが生成されていること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | ソート指定なし | app-paths-manifestのキー順 |

### 改ページ条件

N/A

## データベース参照仕様

N/A

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ルートパス | `normalizeAppPath(appPathKey)` | N/A | グループルート除去、スロット除去、page/route接尾辞除去等の正規化 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Webpackコンパイル完了] --> B[app-paths-manifest.json読み込み]
    B --> C[appPathRoutesオブジェクト初期化]
    C --> D[各キーをイテレート]
    D --> E[normalizeAppPathで正規化]
    E --> F[appPathRoutes に追加]
    F --> G[writeManifestで出力]
    G --> H[.next/app-path-routes-manifest.json]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| マニフェスト読み込み失敗 | app-paths-manifest.jsonが存在しない場合 | JSON parseエラー | ビルドプロセスの再実行 |
| appDir未定義 | App Routerが無効な場合 | N/A（生成スキップ） | 設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | App Routerのルート数に依存 |
| 目標出力時間 | マニフェスト読み込み・変換のため数ミリ秒 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

ルーティング構造が公開されるため、`.next/` ディレクトリの外部非公開が必要。ただし、URLパス自体は公開情報であるため、リスクは低い。

## 備考

- `normalizeAppPath` はグループルート `(group)` の除去、パラレルルート `@slot` の除去、`page`/`route` 接尾辞の除去を行う
- 本マニフェストは `.next/` ディレクトリ直下（`server/` ではなく）に出力される
- build/index.ts の 2133〜2147行目で生成される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.ts | `packages/next/src/shared/lib/constants.ts` | `APP_PATH_ROUTES_MANIFEST`定数（90行目） |

**読解のコツ**: 型は`Record<string, string>`で、キーがApp Router内部パス、値が正規化されたルートパス。

#### Step 2: 生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | 2133〜2147行目。app-paths-manifest.jsonを読み込み、normalizeAppPathで変換し、writeManifestで出力 |

**主要処理フロー**:
1. **2133行目**: `appPathRoutes: Record<string, string> = {}` 初期化
2. **2136行目**: `readManifest` で `app-paths-manifest.json` を読み込み
3. **2140〜2141行目**: 各キーについて `normalizeAppPath(key)` で変換
4. **2144〜2146行目**: `writeManifest` で `.next/app-path-routes-manifest.json` に出力

#### Step 3: normalizeAppPath関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app-paths.ts | `packages/next/src/shared/lib/router/utils/app-paths.ts` | normalizeAppPath関数の実装。グループ・スロット・page/route接尾辞の正規化ロジック |

### プログラム呼び出し階層図

```
next build (build/index.ts)
    |
    +-- readManifest(app-paths-manifest.json) [2136行目]
    |
    +-- normalizeAppPath(key) [2141行目]
    |       (packages/next/src/shared/lib/router/utils/app-paths.ts)
    |
    +-- writeManifest(app-path-routes-manifest.json) [2144行目]
```

### データフロー図

```
[入力]                            [処理]                              [出力]

.next/server/                    build/index.ts
  app-paths-manifest.json -----> normalizeAppPath変換 -------------> .next/app-path-routes-manifest.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/index.ts` | ソース | 本マニフェストの生成処理（2133〜2147行目） |
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | APP_PATH_ROUTES_MANIFEST定数定義 |
| app-paths.ts | `packages/next/src/shared/lib/router/utils/app-paths.ts` | ソース | normalizeAppPath関数の実装 |
| pages-manifest-plugin.ts | `packages/next/src/build/webpack/plugins/pages-manifest-plugin.ts` | ソース | 入力となるapp-paths-manifest.jsonの生成元 |
