# 帳票設計書 7-middleware-manifest.json

## 概要

本ドキュメントは、Next.jsビルドプロセスにおいて生成される `middleware-manifest.json` の設計を記述する。このマニフェストは、ミドルウェアの定義・マッチャー・リージョン情報、およびEdgeランタイムで実行されるEdge Functions（Edge API Routes/Edge SSR）の情報を管理する。

### 本帳票の処理概要

middleware-manifest.json は、`MiddlewarePlugin`（Webpackプラグイン）によって生成されるJSONファイルである。ミドルウェア（`middleware.ts`）とEdge Functions（Edge APIルート、Edge SSRページ）の定義情報を収集し、サーバーがリクエスト処理時にどのミドルウェア/Edge Functionを実行すべきかを判定するための情報を提供する。

**業務上の目的・背景**：Next.jsのミドルウェアは、リクエストがページに到達する前にEdgeランタイムで実行される処理を定義する。各ミドルウェアにはURLマッチャーが設定されており、どのリクエストに対してミドルウェアが適用されるかを決定する必要がある。本マニフェストはこのマッチング情報を提供し、サーバーが効率的にミドルウェアを適用できるようにする。

**帳票の利用シーン**：本番サーバー起動時のミドルウェアルーティング構築、リクエスト処理時のミドルウェア適用判定、Edge Functionのデプロイメント設定、Edgeランタイム用のファイル依存関係の管理に使用される。

**主要な出力内容**：
1. `middleware` - ミドルウェア定義（ファイルリスト・マッチャー・環境変数等）
2. `functions` - Edge Function定義（Edge API/Edge SSR）
3. `sortedMiddleware` - ミドルウェアのソート済みパスリスト
4. `version` - マニフェストバージョン（現在3）

**帳票の出力タイミング**：`next build` コマンド実行時のWebpackコンパイルプロセス中、`PROCESS_ASSETS_STAGE_ADDITIONS` ステージでMiddlewarePluginの`getCreateAssets`が実行された際に出力される。

**帳票の利用者**：Next.jsサーバーランタイム（ミドルウェアルーティング）、Edgeランタイム（Edge Function実行）、デプロイメントプラットフォーム（エッジデプロイ設定）。

## 帳票種別

ビルドマニフェスト（JSON形式のミドルウェア/Edge Function設定ファイル）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルドコマンド実行 |
| N/A | 開発サーバー | `next dev` | 開発サーバー起動・ファイル変更時 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `middleware-manifest.json` |
| 出力方法 | `compilation.emitAsset` 経由（`.next/server/middleware-manifest.json`） |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

```
{
  "version": 3,
  "sortedMiddleware": ["/"],
  "middleware": {
    "/": {
      "files": ["server/middleware.js"],
      "name": "middleware",
      "page": "/",
      "matchers": [{ "regexp": "...", "originalSource": "/:path*" }],
      "wasm": [],
      "assets": [],
      "env": {},
      "regions": ["iad1"]
    }
  },
  "functions": {
    "/api/edge": {
      "files": ["server/app/api/edge/route.js"],
      "name": "app/api/edge/route",
      "page": "/api/edge",
      "matchers": [{ "regexp": "...", "originalSource": "/api/edge" }],
      "wasm": [],
      "assets": [],
      "env": {}
    }
  }
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | マニフェストバージョン | 固定値 `3`（`MANIFEST_VERSION`定数） | 数値 |
| 2 | sortedMiddleware | ミドルウェアのソート済みパスリスト | `getSortedRoutes(Object.keys(middleware))` | 文字列配列 |

### 明細部（EdgeFunctionDefinition）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | files | 必要なファイルリスト | `getEntryFiles(entrypoint.getFiles(), metadata, ...)` | 文字列配列 | N/A |
| 2 | name | エントリポイント名 | `entrypoint.name` | 文字列 | N/A |
| 3 | page | ページパス | `metadata.edgeMiddleware.page` 等 | 文字列 | N/A |
| 4 | matchers | URLマッチャー配列 | `metadata.edgeMiddleware.matchers` またはデフォルト正規表現 | オブジェクト配列 | N/A |
| 5 | wasm | WebAssemblyバインディング | `metadata.wasmBindings` | オブジェクト配列 | N/A |
| 6 | assets | アセットバインディング | `metadata.assetBindings` | オブジェクト配列 | N/A |
| 7 | env | 環境変数 | `opts.edgeEnvironments` | オブジェクト | N/A |
| 8 | regions | デプロイリージョン | `metadata.regions` | 文字列配列/文字列 | N/A |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Edgeランタイムエントリ | edgeMiddleware/edgeSSR/edgeApiFunction メタデータを持つエントリ | Yes |
| ページ情報 | metadataからpage情報が取得できること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | sortedMiddleware（getSortedRoutes使用） | Next.js独自のルートソート順 |

### 改ページ条件

N/A

## データベース参照仕様

N/A

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| matchers正規表現 | `getNamedMiddlewareRegex(matcherSource, { catchAll })` | N/A | マッチャーが未定義時のデフォルト |
| isEdgeFunction | `!!(metadata.edgeApiFunction \|\| metadata.edgeSSR)` | N/A | Edge Functionはfunctionsに、それ以外はmiddlewareに分類 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Webpackコンパイル開始] --> B[MiddlewarePlugin.apply]
    B --> C[エントリポイントのメタデータ収集]
    C --> D[getCreateAssets関数実行]
    D --> E[middlewareManifest初期化]
    E --> F[各エントリポイントをイテレート]
    F --> G{Edge Function判定}
    G -->|isEdgeFunction| H[functions に追加]
    G -->|Middleware| I[middleware に追加]
    H --> J[sortedMiddleware構築]
    I --> J
    J --> K[compilation.emitAsset]
    K --> L[.next/server/middleware-manifest.json]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| Node.js API使用 | Edgeランタイム内でサポートされないNode.js APIが使用された場合 | `A Node.js API is used ({apiName}) which is not supported in the Edge Runtime` | Edge対応APIへの変更 |
| 動的コード評価 | `eval()`等の使用がallowDynamic設定に合致しない場合 | 動的コード評価エラー | unstable_allowDynamic設定の追加 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ミドルウェア数 + Edge Function数（通常は少数） |
| 目標出力時間 | Webpackコンパイル時間内 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

middleware-manifest.jsonの`env`フィールドにはEdge環境変数が含まれる可能性がある。ミドルウェアのマッチャーパターンはアプリケーションのURL構造を露出する。`.next/server/` ディレクトリの外部非公開が必要。

## 備考

- version 3 が現在のマニフェストバージョン
- ミドルウェアは `middleware` フィールドに、Edge API/Edge SSRは `functions` フィールドに分類される
- `getEntryFiles` 関数がEdge SSRの場合、`SERVER_REFERENCE_MANIFEST.js`、`CLIENT_REFERENCE_MANIFEST`、`MIDDLEWARE_BUILD_MANIFEST.js`等の追加ファイルを含める
- `interception-route-rewrite-manifest.js` も同時に出力される（Edgeランタイム用）
- instrumentationHookが存在する場合、`edge-instrumentation.js`がfilesに追加される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | `MiddlewareManifest`型（55〜60行目）、`EdgeFunctionDefinition`型（44〜53行目） |
| 1-2 | constants.ts | `packages/next/src/shared/lib/constants.ts` | `MIDDLEWARE_MANIFEST`定数（102行目） |

**読解のコツ**: MiddlewareManifestはmiddlewareとfunctionsの2フィールドでEdge実行物を分類する。両方ともEdgeFunctionDefinition型を使用。

#### Step 2: プラグインのライフサイクルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | `getCreateAssets`関数（156〜260行目）。マニフェスト初期化、エントリポイントのイテレーション、Edge Function判定・分類 |

**主要処理フロー**:
- **163〜168行目**: middlewareManifest初期化
- **188〜247行目**: エントリポイントループ。メタデータからpage取得、マッチャー構築、EdgeFunctionDefinition構築
- **242〜246行目**: isEdgeFunction判定でfunctions/middlewareに振り分け
- **249〜251行目**: sortedMiddleware構築
- **253〜258行目**: compilation.emitAssetで出力

#### Step 3: ファイル依存関係の構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | `getEntryFiles`関数（101〜154行目）。Edge SSR時の追加ファイル（CLIENT_REFERENCE_MANIFEST等）の組み込み |

### プログラム呼び出し階層図

```
next build
    |
    +-- Webpack compilation (edge-server compiler)
            |
            +-- MiddlewarePlugin.apply()
                    |
                    +-- compilation.hooks.finishModules (メタデータ収集)
                    |
                    +-- compilation.hooks.processAssets
                            |
                            +-- getCreateAssets() [156行目]
                                    |
                                    +-- getEntryFiles() [101行目]
                                    |
                                    +-- getNamedMiddlewareRegex()
                                    |       (packages/next/src/shared/lib/router/utils/route-regex.ts)
                                    |
                                    +-- getSortedRoutes()
                                    |
                                    +-- compilation.emitAsset()
                                            → .next/server/middleware-manifest.json
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Webpack entrypoints            MiddlewarePlugin
  (edge runtime entries) ----> メタデータ収集・分類
  module build info ----------> EdgeFunctionDefinition構築
  middleware.ts config -------> マッチャー・リージョン設定
                                    |
                                    +-- compilation.emitAsset -----> .next/server/middleware-manifest.json
                                    |
                                    +-- interception rewrites -----> .next/server/interception-route-rewrite-manifest.js
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | ソース | MiddlewarePlugin実装（マニフェスト生成） |
| constants.ts | `packages/next/src/shared/lib/constants.ts` | ソース | MIDDLEWARE_MANIFEST定数 |
| route-regex.ts | `packages/next/src/shared/lib/router/utils/route-regex.ts` | ソース | getNamedMiddlewareRegex関数 |
| get-module-build-info.ts | `packages/next/src/build/webpack/loaders/get-module-build-info.ts` | ソース | EdgeMiddlewareMeta/EdgeSSRMeta型定義 |
| manifest-loader.ts | `packages/next/src/shared/lib/turbopack/manifest-loader.ts` | ソース | Turbopack用のマニフェストローダー |
| index.ts | `packages/next/src/build/index.ts` | ソース | ビルドプロセスでのmiddleware-manifest読み込み（2870行目） |
