---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：1-build-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **rootMainFilesTreeの用途詳細**：flying shuttle関連の実装詳細が不明確
  2. **パフォーマンス要件の想定データ件数**：具体的なベンチマークデータなし
  3. **CDNキャッシュ設定への言及**：利用者としての記載だが具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/build/webpack/plugins/build-manifest-plugin.ts` - BuildManifestPluginクラス全体（1〜304行目）
- E-02: `packages/next/src/build/webpack/plugins/build-manifest-plugin-utils.ts` - ユーティリティ関数群（1〜59行目）
- E-03: `packages/next/src/server/get-page-files.ts` - BuildManifest型定義（1〜35行目）
- E-04: `packages/next/src/shared/lib/constants.ts` - 定数定義（87〜153行目）
- E-05: `packages/next/src/build/index.ts` - ビルドプロセスでのマニフェスト読み込み
- E-06: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - Turbopackマニフェストローダー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-manifest.jsonはBuildManifestPluginにより生成される | E-01 (114行目クラス定義) | ○ |
| C-02 | 出力先は.next/build-manifest.json | E-04 (91行目 BUILD_MANIFEST定数) | ○ |
| C-03 | polyfillFilesフィールドが存在する | E-03 (5行目型定義), E-01 (162行目) | ○ |
| C-04 | devFilesフィールドが存在する | E-03 (4行目型定義), E-01 (163行目) | ○ |
| C-05 | lowPriorityFilesフィールドが存在する | E-03 (6行目型定義), E-01 (164行目) | ○ |
| C-06 | rootMainFilesフィールドが存在する | E-03 (8行目型定義), E-01 (165行目) | ○ |
| C-07 | rootMainFilesTreeフィールドが存在する | E-03 (12行目型定義), E-01 (166行目) | ○ |
| C-08 | pagesフィールドは/_appをキーとして含む | E-03 (13〜16行目型定義), E-01 (167行目) | ○ |
| C-09 | SYSTEM_ENTRYPOINTSに含まれるエントリはスキップされる | E-01 (208行目), E-04 (203〜207行目) | ○ |
| C-10 | .hot-update.jsファイルは除外される | E-01 (106行目 getEntrypointFiles関数) | ○ |
| C-11 | pagesのキーはソートされる | E-01 (243〜249行目) | ○ |
| C-12 | isDevFallback時はfallback-build-manifest.jsonとなる | E-01 (253〜255行目) | ○ |
| C-13 | クライアント向け_buildManifest.jsはself.__BUILD_MANIFESTに設定される | E-01 (277行目) | ○ |
| C-14 | エッジ向けmanifestはglobalThis.__BUILD_MANIFESTに設定される | E-02 (57行目) | ○ |
| C-15 | deploymentId設定時はskew protectionでbuildIdを省略 | E-01 (38〜43行目 buildNodejsLowPriorityPath関数) | ○ |
| C-16 | generateClientManifestは_appのアセットを除外する | E-01 (74〜85行目) | ○ |
| C-17 | clientRouterFiltersにBloomFilter情報が含まれる | E-01 (71〜72行目) | ○ |
| C-18 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行される | E-01 (295行目) | ○ |
| C-19 | _ssgManifest.jsはsrcEmptySsgManifestの内容で出力される | E-01 (239行目), E-02 (11行目) | ○ |
| C-20 | rootMainFilesTreeはflying shuttle用の一時的フィールド | E-03 (9〜11行目コメント) | △ |

## 4) 不足情報（Unknown / Missing）
- rootMainFilesTreeの「flying shuttle」機能の実装詳細・ステータスが不明確
  - 候補：Next.js RFCドキュメント / Vercel社内ドキュメント / GitHubのPR・Issue

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 定数定義・型定義に基づく記述はすべてソースコードで確認済み
- 0: 低リスク - プラグインの処理フローはソースコードの行番号で追跡可能
- 1: 中リスク - rootMainFilesTreeのflying shuttle関連の記述は将来変更の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] BuildManifest型定義（get-page-files.ts）の最新状態と一致しているか確認
- [ ] rootMainFilesTreeフィールドの現在のステータスを確認（experimental/stable）
- [ ] Turbopack使用時のbuild-manifest生成パス（manifest-loader.ts）との差異を確認
