---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-server-reference-manifest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ActionManifest型の完全な定義場所**：型定義のimport元の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/flight-client-entry-plugin.ts` - FlightClientEntryPlugin（createActionAssets: 1097〜1181行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - SERVER_REFERENCE_MANIFEST定数（128行目）
- E-03: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - Edge Function定義でのserver-reference-manifest参照（110行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FlightClientEntryPluginのcreateActionAssetsで生成される | E-01 (1097行目) | ○ |
| C-02 | 出力先は.next/server/server-reference-manifest.{json,js} | E-02 (128行目), E-01 (1171〜1178行目) | ○ |
| C-03 | JSONとJavaScriptの2形式で出力される | E-01 (1171行目 .js, 1177行目 .json) | ○ |
| C-04 | node/edge/encryptionKeyの3フィールドを持つ | E-01 (1154〜1158行目) | ○ |
| C-05 | Edge版のencryptionKeyは環境変数参照文字列 | E-01 (1161行目) | ○ |
| C-06 | JSON版のencryptionKeyはthis.encryptionKey | E-01 (1157行目) | ○ |
| C-07 | JS版はself.__RSC_SERVER_MANIFESTに設定される | E-01 (1174行目) | ○ |
| C-08 | traverseModulesでモジュールグラフを走査 | E-01 (1101行目) | ○ |
| C-09 | flight-action-entry-loaderでアクションモジュールを判定 | E-01 (1107行目) | ○ |
| C-10 | __client_imported__=trueでクライアントインポート判定 | E-01 (1109行目) | ○ |
| C-11 | actionBrowserレイヤーはclient、それ以外はserverでワーカー選択 | E-01 (1131〜1133行目) | ○ |
| C-12 | pluginState.serverActionsにアクション情報が蓄積される | E-01 (1126行目) | ○ |
| C-13 | pluginState.edgeServerActionsにEdgeアクション情報が蓄積される | E-01 (1140行目) | ○ |
| C-14 | assetPrefixがファイルパスのプレフィックスとして使用される | E-01 (1172行目, 1178行目) | ○ |
| C-15 | 開発時はJSON pretty print（indent 2）で出力される | E-01 (1164行目) | ○ |
| C-16 | ActionManifest型定義の完全な構造 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ActionManifest型の完全な定義（node/edge内の各ActionEntryの詳細フィールド）
  - 候補：flight-client-entry-plugin.tsの型定義部分（ファイル冒頭のimport/export型定義）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 生成処理は行番号レベルで追跡可能
- 2: 高リスク - encryptionKeyは秘密情報。JSONファイルに直接含まれるためファイルアクセス制御が必須
- 1: 中リスク - Edge版のencryptionKey環境変数参照が正しく機能するか実行時検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ActionManifest型定義の全フィールドを確認
- [ ] encryptionKeyの秘密情報管理が適切か確認
- [ ] Edge版のprocess.env参照が実行時に正しく解決されるか確認
- [ ] assetPrefix指定時のファイルパスが正しいか確認
