---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-next-font-manifest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Google Auroraチームの統計収集目的**：コード内コメントのみで公式ドキュメント確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/webpack/plugins/next-font-manifest-plugin.ts` - NextFontManifestPlugin実装
- E-02: `packages/next/src/shared/lib/constants.ts` - NEXT_FONT_MANIFEST定数定義（94行目）
- E-03: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - TurbopackManifestLoaderクラス
- E-04: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - エッジランタイムでのフォントマニフェスト参照
- E-05: `packages/next/src/client/route-loader.ts` - クライアントサイドのグローバル変数宣言
- E-06: `packages/next/src/build/index.ts` - ビルドプロセスのエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextFontManifestPluginによりマニフェストが生成される | E-01 (55-178行目) | ○ |
| C-02 | 型定義はpages, app, appUsingSizeAdjust, pagesUsingSizeAdjustの4フィールド | E-01 (7-16行目) | ○ |
| C-03 | 定数名はNEXT_FONT_MANIFEST、値は'next-font-manifest' | E-02 (94行目) | ○ |
| C-04 | 出力先は .next/server/next-font-manifest.json と .js | E-01 (159-172行目) | ○ |
| C-05 | プリロード対象フォントは .p. を含むファイル名で判定 | E-01 (26-30行目) | ○ |
| C-06 | size-adjust判定はファイル名に -s を含むかで判定 | E-01 (37-39行目) | ○ |
| C-07 | App Router向けにはtraverseModulesでnext-font-loaderモジュールを走査 | E-01 (82-123行目) | ○ |
| C-08 | Pages Router向けにはentrypointsのauxiliaryFilesからフォント収集 | E-01 (127-155行目) | ○ |
| C-09 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行 | E-01 (68行目) | ○ |
| C-10 | JS形式はself.__NEXT_FONT_MANIFEST=で始まるグローバル変数代入 | E-01 (162行目) | ○ |
| C-11 | フォント拡張子は.woff, .woff2, .eot, .ttf, .otf | E-01 (28行目, 95行目, 138行目) | ○ |
| C-12 | Turbopack時はTurbopackManifestLoaderでマージ処理 | E-03 (640-697行目) | ○ |
| C-13 | エッジランタイムでserver/next-font-manifest.jsが参照される | E-04 (134行目) | ○ |
| C-14 | クライアントサイドでwindow.__NEXT_FONT_MANIFEST参照 | E-05 (22行目) | ○ |
| C-15 | app/で始まるchunkGroupのみApp Router対象 | E-01 (121行目) | ○ |
| C-16 | compiler.hooks.make.tapでフック登録 | E-01 (63行目) | ○ |
| C-17 | Google Auroraチームのsize-adjust統計収集目的 | E-01 (35-36行目コメント) | △ |
| C-18 | Turbopack時はsortObjectByKeyでキーソート | E-03 (668-669行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- Google Auroraチームの統計収集に関する公式ドキュメント・仕様が未確認
  - 候補：Next.js公式ドキュメント / Google Auroraチームの公開仕様 / PRコメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - マニフェストの基本構造とフィールド定義はソースコードから明確
- 0: 低リスク - 出力パスと出力形式はソースコードから直接確認可能
- 1: 中リスク - Google Auroraチーム関連のコメントはコード内コメントのみが根拠

## 6) レビュアーチェックリスト（最小）
- [ ] NextFontManifest型定義の4フィールドが正確に記載されているか
- [ ] プリロード判定ロジック（.p.拡張子フィルタ）が正確か
- [ ] Turbopackでのマージ処理の記載が最新のコードと一致するか
- [ ] エッジランタイム向けJS形式の出力フォーマットが正確か
