---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-subresource-integrity-manifest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。特に優先レビューが必要な項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/subresource-integrity-plugin.ts` - SubresourceIntegrityPlugin実装全体
- E-02: `packages/next/src/shared/lib/constants.ts` - SUBRESOURCE_INTEGRITY_MANIFEST定数（93行目）
- E-03: `packages/next/src/server/load-components.ts` - サーバーサイドでのマニフェスト読み込み
- E-04: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - エッジランタイムでのSRI参照（111-113行目）
- E-05: `packages/next/src/client/route-loader.ts` - クライアントグローバル変数宣言（23行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubresourceIntegrityPluginにより生成される | E-01 (9-70行目) | ○ |
| C-02 | 対応アルゴリズムはsha256, sha384, sha512 | E-01 (7行目: SubresourceIntegrityAlgorithm型) | ○ |
| C-03 | 定数名はSUBRESOURCE_INTEGRITY_MANIFEST | E-02 (93行目) | ○ |
| C-04 | 出力先はserver/subresource-integrity-manifest.json と .js | E-01 (49-65行目) | ○ |
| C-05 | afterProcessAssetsフックで実行 | E-01 (14行目) | ○ |
| C-06 | PROCESS_ASSETS_STAGE_ADDITIONSステージ | E-01 (17行目) | ○ |
| C-07 | 全アセットをSetで重複排除 | E-01 (21-24行目) | ○ |
| C-08 | crypto.createHashでハッシュ計算 | E-01 (39-43行目) | ○ |
| C-09 | Base64エンコードでハッシュ出力 | E-01 (43行目: .toString('base64')) | ○ |
| C-10 | ハッシュ文字列はalgorithm-hash形式 | E-01 (45行目) | ○ |
| C-11 | JS形式はself.__SUBRESOURCE_INTEGRITY_MANIFESTで代入 | E-01 (53行目) | ○ |
| C-12 | アセット取得失敗時にエラーthrow | E-01 (32-33行目) | ○ |
| C-13 | SRI有効時のみエッジファイルリストに追加 | E-04 (111-113行目) | ○ |
| C-14 | loadComponentsでマニフェスト読み込み | E-03 (24行目, 78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコードの根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグインのロジックは単純でソースコードから完全に追跡可能
- 0: 低リスク - セキュリティ用途のマニフェストだが、仕様はW3C SRI標準に準拠

## 6) レビュアーチェックリスト（最小）
- [ ] ハッシュ計算ロジック（crypto.createHash）の記載が正確か
- [ ] 対応アルゴリズム3種類が正しく記載されているか
- [ ] エッジランタイム向けJS形式の出力が正確か
- [ ] SRI有効条件（experimental.sri.algorithm）が正しく記載されているか
