---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：13-images-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **画像最適化APIでの参照箇所**：マニフェスト読み込み側のコードを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/index.ts` - writeImagesManifest関数（654-685行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - IMAGES_MANIFEST定数（99行目）
- E-03: `packages/next/src/build/index.ts` - 呼び出し箇所（4119行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | writeImagesManifest関数により生成される | E-01 (654行目) | ○ |
| C-02 | 定数名はIMAGES_MANIFEST、値は'images-manifest.json' | E-02 (99行目) | ○ |
| C-03 | 出力先は.next/images-manifest.json | E-01 (681行目) | ○ |
| C-04 | version固定値1 | E-01 (682行目) | ○ |
| C-05 | sizes = deviceSizes + imageSizes の結合 | E-01 (659-660行目) | ○ |
| C-06 | remotePatterns.protocolから末尾コロン除去 | E-01 (665行目) | ○ |
| C-07 | remotePatterns.hostnameをmakeReで正規表現変換 | E-01 (666行目) | ○ |
| C-08 | remotePatterns.pathnameのデフォルトは'**' | E-01 (668行目) | ○ |
| C-09 | localPatternsは設定時のみ変換 | E-01 (673-679行目) | ○ |
| C-10 | remotePatterns未設定時はデフォルト空配列 | E-01 (663行目) | ○ |
| C-11 | ビルドプロセス後半で呼び出される | E-03 (4119行目) | ○ |
| C-12 | 画像最適化APIがリクエスト処理時に参照する | **根拠なし**（読み込み側コード未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- 画像最適化API側でのマニフェスト読み込み・利用箇所の詳細確認
  - 候補：`packages/next/src/server/image-optimizer.ts` / `packages/next/src/server/next-server.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - マニフェスト生成ロジックはソースコードから明確
- 1: 中リスク - マニフェスト利用側（画像最適化API）の詳細確認が未実施

## 6) レビュアーチェックリスト（最小）
- [ ] writeImagesManifest関数の処理内容が正確に記載されているか
- [ ] remotePatterns/localPatternsの正規表現変換ロジックが正確か
- [ ] マニフェストのJSON構造例が実際の出力と一致するか
- [ ] 画像最適化API側でのマニフェスト利用方法の記載を追加検討
