---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-functions-config-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。特に優先レビューが必要な項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/index.ts` - FunctionsConfigManifest型定義（597-613行目）
- E-02: `packages/next/src/build/index.ts` - writeFunctionsConfigManifest関数（615-629行目）
- E-03: `packages/next/src/build/index.ts` - マニフェスト初期化（2160-2163行目）
- E-04: `packages/next/src/build/index.ts` - ページ設定追加（2363-2378行目）
- E-05: `packages/next/src/build/index.ts` - ミドルウェア設定追加（2720-2755行目）
- E-06: `packages/next/src/shared/lib/constants.ts` - FUNCTIONS_CONFIG_MANIFEST定数（92行目）
- E-07: `packages/next/src/server/lib/router-utils/filesystem.ts` - ルーターでの読み込み（224-318行目）
- E-08: `packages/next/src/build/adapter/build-complete.ts` - デプロイアダプターでの利用（876行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FunctionsConfigManifestインターフェースが定義されている | E-01 | ○ |
| C-02 | version: 1の固定値 | E-03 (2161行目) | ○ |
| C-03 | functionsはRecord型でmaxDuration, runtime, regions, matchersフィールド | E-01 (598-612行目) | ○ |
| C-04 | 定数名はFUNCTIONS_CONFIG_MANIFEST | E-06 (92行目) | ○ |
| C-05 | 出力先は.next/server/functions-config-manifest.json | E-02 (626行目) | ○ |
| C-06 | writeFunctionsConfigManifestでキーのlocaleCompareソート | E-02 (622行目) | ○ |
| C-07 | runtime, maxDuration, preferredRegionのいずれかが存在時にエントリ追加 | E-04 (2363-2367行目) | ○ |
| C-08 | preferredRegionが文字列の場合は配列に変換 | E-04 (2369-2372行目) | ○ |
| C-09 | Node.jsランタイムのミドルウェアで/_middlewareエントリ追加 | E-05 (2720-2722行目) | ○ |
| C-10 | ミドルウェアmatchersが設定される | E-05 (2724-2729行目) | ○ |
| C-11 | ルーターでミドルウェアmatchers判定に使用 | E-07 (316-318行目) | ○ |
| C-12 | デプロイアダプターで関数設定読み取り | E-08 (876行目) | ○ |
| C-13 | ビルドプロセス内で2758行目でwriteが呼ばれる | E-02, E-05 (2758行目) | ○ |
| C-14 | runtimeフィールドは'nodejs'のみ | E-01 (603行目) | ○ |
| C-15 | エクスポート処理でミドルウェア存在判定に使用 | E-07相当（export/index.ts 623-629行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FunctionsConfigManifest型の全フィールドが正確に記載されているか
- [ ] ミドルウェアのNode.jsランタイム設定ロジックが正確か
- [ ] writeFunctionsConfigManifestのソートロジックが正確か
- [ ] 利用箇所（router-utils, build-complete, export）が網羅されているか
