---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-middleware-build-manifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/build-manifest-plugin.ts` - BuildManifestPlugin（262-264行目）
- E-02: `packages/next/src/build/webpack/plugins/build-manifest-plugin-utils.ts` - createEdgeRuntimeManifest関数（52-58行目）
- E-03: `packages/next/src/shared/lib/constants.ts` - MIDDLEWARE_BUILD_MANIFEST定数（130行目）
- E-04: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - TurbopackManifestLoader.writeBuildManifest（534-546行目）
- E-05: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - getEntryFiles（132行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildManifestPluginにより生成される | E-01 (262-264行目) | ○ |
| C-02 | 定数名はMIDDLEWARE_BUILD_MANIFEST | E-03 (130行目) | ○ |
| C-03 | 出力先はserver/middleware-build-manifest.js | E-01 (263行目) | ○ |
| C-04 | createEdgeRuntimeManifestでJS変換 | E-02 (52-58行目) | ○ |
| C-05 | globalThis.__BUILD_MANIFEST形式 | E-02 (57行目) | ○ |
| C-06 | selfではなくglobalThisを使用 | E-02 (55-57行目、コメント参照) | ○ |
| C-07 | Turbopack時はwriteBuildManifestで生成 | E-04 (534-546行目) | ○ |
| C-08 | エッジSSRファイルリストに本マニフェスト含む | E-05 (132行目) | ○ |
| C-09 | PROCESS_ASSETS_STAGE_ADDITIONSステージ | E-01 (コンテキストから確認) | ○ |
| C-10 | build-manifest.jsonと同一構造の内容 | E-02 (53行目: assetMap引数) | ○ |
| C-11 | JSON.stringifyで変換 | E-02 (57行目) | ○ |
| C-12 | TurbopackではwriteFileAtomicで書き込み | E-04 (543-546行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純な変換処理でソースコードから完全に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] createEdgeRuntimeManifest関数の出力形式が正確か
- [ ] globalThis使用の理由（Node.jsミドルウェア対応）が正しいか
- [ ] WebpackとTurbopackの両方の生成パスが記載されているか
