---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-middleware-react-loadable-manifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/react-loadable-plugin.ts` - ReactLoadablePlugin（207-216行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - MIDDLEWARE_REACT_LOADABLE_MANIFEST定数（132-133行目）
- E-03: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - getEntryFiles（133行目）
- E-04: `packages/next/src/server/load-components.ts` - ReactLoadableManifest型（43行目）
- E-05: `packages/next/src/client/route-loader.ts` - グローバル変数宣言（18行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReactLoadablePluginにより生成される | E-01 (207-216行目) | ○ |
| C-02 | 定数名はMIDDLEWARE_REACT_LOADABLE_MANIFEST | E-02 (132-133行目) | ○ |
| C-03 | self.__REACT_LOADABLE_MANIFEST形式で出力 | E-01 (211行目) | ○ |
| C-04 | 二重JSON.stringifyで変換 | E-01 (211-212行目) | ○ |
| C-05 | runtimeAssetオプション設定時のみ出力 | E-01 (207行目) | ○ |
| C-06 | エッジSSRファイルリストに含まれる | E-03 (133行目) | ○ |
| C-07 | ReactLoadableManifest型はmoduleIdからid,filesのマップ | E-04 (43行目) | ○ |
| C-08 | ManifestItem型はid: string\|number, files: string[] | E-04 (38-41行目) | ○ |
| C-09 | クライアントでwindow.__REACT_LOADABLE_MANIFESTとして参照 | E-05 (18行目) | ○ |
| C-10 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行 | E-01 (コンテキストのapplyメソッド内) | ○ |
| C-11 | 出力先はserver/middleware-react-loadable-manifest.js | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純な変換処理でソースコードから完全追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] 二重JSON.stringifyの理由と動作が正確に記載されているか
- [ ] runtimeAssetオプションの設定箇所（webpack-config.ts）が確認可能か
- [ ] エッジランタイムでの参照パスが正確か
