---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：17-interception-route-rewrite-manifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **isInterceptionRouteRewrite関数の判定ロジック**：関数の実装を直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - MiddlewarePlugin（176-186行目）
- E-02: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - writeInterceptionRouteRewriteManifest（489-522行目）
- E-03: `packages/next/src/shared/lib/constants.ts` - INTERCEPTION_ROUTE_REWRITE_MANIFEST定数（135-136行目）
- E-04: `packages/next/src/client/route-loader.ts` - グローバル変数宣言（24行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MiddlewarePluginのgetCreateAssets内で生成 | E-01 (176-186行目) | ○ |
| C-02 | 定数名はINTERCEPTION_ROUTE_REWRITE_MANIFEST | E-03 (135-136行目) | ○ |
| C-03 | beforeFilesリライトからフィルタリング | E-01 (177行目) | ○ |
| C-04 | isInterceptionRouteRewriteでフィルタ | E-01 (178行目) | ○ |
| C-05 | self.__INTERCEPTION_ROUTE_REWRITE_MANIFEST形式で出力 | E-01 (182行目) | ○ |
| C-06 | Turbopack版はキャッシュ付き書き込み | E-02 (504-507行目) | ○ |
| C-07 | Turbopack版はserver/ディレクトリに出力 | E-02 (509-512行目) | ○ |
| C-08 | Turbopack版はwriteFileAtomicで書き込み | E-02 (516行目) | ○ |
| C-09 | Turbopack版は末尾セミコロン付き | E-02 (518-520行目) | ○ |
| C-10 | クライアントでwindow.__INTERCEPTION_ROUTE_REWRITE_MANIFESTとして参照 | E-04 (24行目) | ○ |
| C-11 | エッジSSRファイルリストに含まれる | E-01 (135行目) | ○ |
| C-12 | Webpack版はルートディレクトリに出力 | E-01 (180行目) | ○ |
| C-13 | isInterceptionRouteRewrite関数はリライトがインターセプトルート用かを判定 | **根拠なし**（関数実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- `isInterceptionRouteRewrite` 関数の実装詳細
  - 候補：`packages/next/src/lib/generate-interception-routes-rewrites.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 生成処理のロジックはソースコードから明確
- 1: 中リスク - フィルタ関数の判定ロジック詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] WebpackとTurbopackの出力パスの違いが正確か
- [ ] isInterceptionRouteRewrite関数の判定ロジックを確認
- [ ] キャッシュ機構の記載が正確か
- [ ] JSON.stringify形式（二重vs単一）がWebpack/Turbopackで正しく記載されているか
