---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-dynamic-css-manifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/react-loadable-plugin.ts` - ReactLoadablePlugin（221-236行目）
- E-02: `packages/next/src/server/load-components.ts` - DynamicCssManifest型（44-49行目）、LoadComponentsReturnType（80行目）
- E-03: `packages/next/src/shared/lib/constants.ts` - DYNAMIC_CSS_MANIFEST定数（138行目）
- E-04: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - エッジファイルリスト（127-129行目）
- E-05: `packages/next/src/client/route-loader.ts` - グローバル変数（19行目）
- E-06: `packages/next/src/build/index.ts` - ビルドパス設定（2008-2009行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReactLoadablePluginにより生成される | E-01 (221-236行目) | ○ |
| C-02 | DynamicCssManifest型はstring[] | E-02 (49行目) | ○ |
| C-03 | Pages dir && Production && Webpack限定 | E-02 (44-48行目コメント) | ○ |
| C-04 | 定数名はDYNAMIC_CSS_MANIFEST | E-03 (138行目) | ○ |
| C-05 | JSON形式とJS形式の2種類出力 | E-01 (222-235行目) | ○ |
| C-06 | JS形式はself.__DYNAMIC_CSS_MANIFEST形式 | E-01 (231行目) | ○ |
| C-07 | 二重JSON.stringify | E-01 (231-232行目) | ○ |
| C-08 | shouldCreateDynamicCssManifest条件チェック | E-01 (221行目) | ○ |
| C-09 | エッジSSRで本番かつ非AppDir時に追加 | E-04 (127-129行目) | ○ |
| C-10 | loadComponentsでdynamicCssManifest読み込み | E-02 (80行目) | ○ |
| C-11 | クライアントでwindow.__DYNAMIC_CSS_MANIFEST参照 | E-05 (19行目) | ○ |
| C-12 | PR #72959で導入 | E-02 (47行目: @see コメント) | ○ |
| C-13 | JSON出力先はdynamic-css-manifest.json | E-01 (223行目) | ○ |
| C-14 | JS出力先はserver/dynamic-css-manifest.js | E-01 (229行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Pages Router + Production + Webpack限定の条件が正確か
- [ ] DynamicCssManifest型（string[]）が正しいか
- [ ] エッジSSRでの追加条件（!dev && !isAppDir）が正確か
- [ ] PR #72959の修正内容との整合性
