---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：19-webpack-stats.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **バンドル解析ツールとの互換性**：外部ツール互換性は推測に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` - TurbopackManifestLoader（351-448行目、383-388行目、912-914行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - WEBPACK_STATS定数（88行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TurbopackManifestLoaderにより生成 | E-01 (351-359行目) | ○ |
| C-02 | 定数名はWEBPACK_STATS、値はwebpack-stats.json | E-02 (88行目) | ○ |
| C-03 | 出力先は.next/server/webpack-stats.json | E-01 (356行目) | ○ |
| C-04 | TURBOPACK_STATS環境変数が必要 | E-01 (912行目) | ○ |
| C-05 | versionフィールドは'Turbopack' | E-01 (442行目) | ○ |
| C-06 | entrypointsは先勝ちマージ | E-01 (397-403行目) | ○ |
| C-07 | assetsは名前で重複排除 | E-01 (405-411行目) | ○ |
| C-08 | chunksはIDで重複排除 | E-01 (413-419行目) | ○ |
| C-09 | modulesはIDで重複排除＋チャンクリスト統合 | E-01 (421-438行目) | ○ |
| C-10 | WebpackStats型はwebpackパッケージからインポート | E-01 (10行目) | ○ |
| C-11 | loadWebpackStatsでページごとに読み込み | E-01 (383-388行目) | ○ |
| C-12 | 変更検知でスキップ最適化あり | E-01 (352行目) | ○ |
| C-13 | webpack-bundle-analyzer等との互換性あり | **根拠なし**（外部ツール互換性は推測） | △ |

## 4) 不足情報（Unknown / Missing）
- 外部バンドル解析ツールとの互換性確認
  - 候補：webpack-bundle-analyzerドキュメント / Turbopack公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 生成ロジックはソースコードから明確
- 1: 中リスク - 外部ツールとの互換性は未検証

## 6) レビュアーチェックリスト（最小）
- [ ] TURBOPACK_STATS環境変数の条件が正確か
- [ ] mergeWebpackStatsのマージロジック（特にmodules）が正確か
- [ ] version='Turbopack'の記載が正しいか
- [ ] 出力パスが正確か（server/webpack-stats.json）
