---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-pages-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり
  2. ただし、distDir指定時のマージ動作の網羅的テストは推奨
  3. Edge/Nodeマージ時の競合条件についてレビュー推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/pages-manifest-plugin.ts` - PagesManifestPluginクラス全体（1〜192行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - PAGES_MANIFEST, APP_PATHS_MANIFEST定数（87〜89行目）
- E-03: `packages/next/src/server/require.ts` - サーバー側でのマニフェスト読み込み
- E-04: `packages/next/src/server/next-server.ts` - サーバーランタイムでのマニフェスト利用
- E-05: `packages/next/src/build/index.ts` - ビルドプロセスでのマニフェスト読み込み（2130行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pages-manifest.jsonはPagesManifestPluginにより生成される | E-01 (21行目クラス定義) | ○ |
| C-02 | 出力先は.next/server/pages-manifest.json | E-02 (87行目定数), E-01 (128行目) | ○ |
| C-03 | PagesManifest型は{ [page: string]: string }である | E-01 (11行目型定義) | ○ |
| C-04 | webpack-runtimeファイルは除外される | E-01 (65行目) | ○ |
| C-05 | webpack-api-runtimeファイルは除外される | E-01 (66行目) | ○ |
| C-06 | .jsファイルのみが対象 | E-01 (67行目) | ○ |
| C-07 | 空エントリはスキップされる | E-01 (71〜73行目) | ○ |
| C-08 | 本番ビルド・Nodeランタイム時にfile.slice(3)が適用される | E-01 (77〜81行目) | ○ |
| C-09 | パス区切り文字がnormalizePathSepで正規化される | E-01 (82行目) | ○ |
| C-10 | app/で始まるエントリはappPathsに振り分けられる | E-01 (84〜85行目) | ○ |
| C-11 | EdgeランタイムのページはedgeServerPagesに保存される | E-01 (93〜95行目) | ○ |
| C-12 | NodeランタイムのページはnodeServerPagesに保存される | E-01 (97〜98行目) | ○ |
| C-13 | distDir指定時はfs.writeFileで書き出される | E-01 (108行目, 124〜133行目) | ○ |
| C-14 | distDir未指定時はcompilation.emitAssetで出力される | E-01 (137〜149行目) | ○ |
| C-15 | 既存マニフェストとマージされる（並列コンパイラ対応） | E-01 (103〜122行目 writeMergedManifest) | ○ |
| C-16 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行される | E-01 (185行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義・定数定義に基づく記述はすべてソースコードで確認済み
- 0: 低リスク - プラグインの処理フローは行番号レベルで追跡可能
- 1: 中リスク - 並列コンパイラからの書き込み競合（writeMergedManifestで対処されているが要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] PagesManifest型定義が最新のソースコードと一致しているか確認
- [ ] writeMergedManifestの並列書き込み安全性を確認
- [ ] file.slice(3)の意図（`../`除去）が現在のディレクトリ構造で正しいか確認
