---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-BUILD_ID

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/generate-build-id.ts` - generateBuildId関数（1-22行目）
- E-02: `packages/next/src/build/write-build-id.ts` - writeBuildId関数（1-11行目）
- E-03: `packages/next/src/shared/lib/constants.ts` - BUILD_ID_FILE定数（117行目）
- E-04: `packages/next/src/build/index.ts` - getBuildId関数（897-909行目）、writeBuildId呼び出し（2822行目）、nanoidインポート（22行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | generateBuildId関数でビルドID生成 | E-01 (1-22行目) | ○ |
| C-02 | writeBuildId関数でファイル書き込み | E-02 (1-11行目) | ○ |
| C-03 | 定数名はBUILD_ID_FILE、値は'BUILD_ID' | E-03 (117行目) | ○ |
| C-04 | nanoidでランダム文字列生成（デフォルト） | E-04 (22行目: import, 908行目: nanoid引数) | ○ |
| C-05 | config.generateBuildIdでカスタム生成可能 | E-01 (5行目), E-04 (908行目) | ○ |
| C-06 | カスタム関数がnull返却時はnanoidフォールバック | E-01 (7行目) | ○ |
| C-07 | /ad/iパターンでフィルタ（広告ブロッカー対策） | E-01 (8-12行目) | ○ |
| C-08 | 文字列型チェックでエラーthrow | E-01 (15-18行目) | ○ |
| C-09 | エラーメッセージにドキュメントURL含む | E-01 (17行目) | ○ |
| C-10 | trim()で前後空白除去 | E-01 (21行目) | ○ |
| C-11 | fs.promises.writeFileでUTF-8書き込み | E-02 (10行目) | ○ |
| C-12 | generateモードでは既存ファイルから読み込み | E-04 (903-904行目) | ○ |
| C-13 | getBuildIdがgenerateモード判定を行う | E-04 (897-909行目) | ○ |
| C-14 | ビルド後半でwriteBuildIdが呼ばれる | E-04 (2822行目) | ○ |
| C-15 | nanoidはnext/dist/compiledからインポート | E-04 (22行目) | ○ |
| C-16 | 出力先は.next/BUILD_ID | E-02 (9行目: join(distDir, BUILD_ID_FILE)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコード根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠確認済み
- 0: 低リスク - 単純な文字列生成・書き込み処理

## 6) レビュアーチェックリスト（最小）
- [ ] generateBuildId関数のフロー（カスタム -> nanoid -> adフィルタ -> trim）が正確か
- [ ] writeBuildId関数のファイル書き込みロジックが正確か
- [ ] generateモード時の既存ファイル読み込みが正確か
- [ ] 'ad'フィルタの理由（広告ブロッカー対策）が正しいか
