---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-export-marker.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` L95 - EXPORT_MARKER定数定義
- E-02: `packages/next/src/build/index.ts` L4120-4125 - writeManifest呼び出し
- E-03: `packages/next/src/build/index.ts` L60 - EXPORT_MARKERインポート
- E-04: `packages/next/src/export/index.ts` L35 - EXPORT_MARKERインポート
- E-05: `packages/next/src/export/index.ts` L409-416 - ファイル読み込み処理
- E-06: `packages/next/src/export/index.ts` L418-432 - 画像最適化互換性チェック
- E-07: `packages/next/src/build/index.ts` L4126-4131 - EXPORT_DETAIL削除処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はEXPORT_MARKERで値は'export-marker.json' | E-01 | ○ |
| C-02 | ビルド完了時にwriteManifestで生成される | E-02 | ○ |
| C-03 | version: 1がハードコードされている | E-02 | ○ |
| C-04 | hasExportPathMapはconfig.exportPathMapのtypeofで判定 | E-02 | ○ |
| C-05 | exportTrailingSlashはconfig.trailingSlashの厳密等価比較 | E-02 | ○ |
| C-06 | isNextImageImportedはビルド解析結果の厳密等価比較 | E-02 | ○ |
| C-07 | export/index.tsで読み取られる | E-04, E-05 | ○ |
| C-08 | isNextImageImportedフラグで画像最適化互換性チェック | E-06 | ○ |
| C-09 | デフォルトローダー使用時に静的エクスポート不可エラー | E-06 | ○ |
| C-10 | writeImagesManifest完了後に書き込まれる | E-02 | ○ |
| C-11 | 書き込み後にEXPORT_DETAILの削除を試行する | E-07 | ○ |
| C-12 | build/index.tsとexport/index.tsの両方でインポートされている | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] JSONスキーマの4プロパティ（version, hasExportPathMap, exportTrailingSlash, isNextImageImported）が正確か確認
- [ ] export/index.tsでの読み取り処理が正しく記載されているか確認
