---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-export-detail.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` L96 - EXPORT_DETAIL定数定義
- E-02: `packages/next/src/export/index.ts` L34 - EXPORT_DETAILインポート
- E-03: `packages/next/src/export/index.ts` L350-358 - 初期作成処理（success: false）
- E-04: `packages/next/src/export/index.ts` L1015-1023 - 完了更新処理（success: true）
- E-05: `packages/next/src/build/index.ts` L59 - EXPORT_DETAILインポート
- E-06: `packages/next/src/build/index.ts` L4126-4131 - 削除処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はEXPORT_DETAILで値は'export-detail.json' | E-01 | ○ |
| C-02 | エクスポート開始時にsuccess:falseで作成される | E-03 | ○ |
| C-03 | エクスポート正常完了時にsuccess:trueで更新される | E-04 | ○ |
| C-04 | version: 1がハードコードされている | E-03, E-04 | ○ |
| C-05 | outDirectoryにエクスポート先ディレクトリパスが格納される | E-03, E-04 | ○ |
| C-06 | formatManifestを使用してJSON整形出力される | E-03, E-04 | ○ |
| C-07 | next buildのみの場合はビルド完了時に削除される | E-06 | ○ |
| C-08 | 削除時のENOENTエラーは無視される | E-06 | ○ |
| C-09 | export/index.tsとbuild/index.tsの両方でインポートされている | E-02, E-05 | ○ |
| C-10 | 3つのプロパティ（version, outDirectory, success）で構成される | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] JSONスキーマの3プロパティが正確に記載されているか確認
- [ ] 開始時（success:false）と完了時（success:true）の2段階書き込みが正しく記述されているか確認
- [ ] ビルド完了時の削除処理が正確に記述されているか確認
