---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-required-server-files.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` L100 - SERVER_FILES_MANIFEST定数定義
- E-02: `packages/next/src/build/index.ts` L631-638 - RequiredServerFilesManifest型定義
- E-03: `packages/next/src/build/index.ts` L640-652 - writeRequiredServerFilesManifest関数
- E-04: `packages/next/src/build/index.ts` L1922-2020 - マニフェスト構築処理
- E-05: `packages/next/src/build/index.ts` L1942-1960 - config構築部分（compress, cacheHandler等）
- E-06: `packages/next/src/build/index.ts` L1963-2016 - filesリスト構築部分
- E-07: `packages/next/src/server/next.ts` L20 - SERVER_FILES_MANIFESTインポート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はSERVER_FILES_MANIFESTで値は'required-server-files' | E-01 | ○ |
| C-02 | RequiredServerFilesManifest型は6フィールド（version, config, appDir, relativeAppDir, files, ignore） | E-02 | ○ |
| C-03 | .jsonと.jsの2形式で出力される | E-03 | ○ |
| C-04 | .js形式はself.__SERVER_FILES_MANIFEST=プレフィックス付き | E-03 | ○ |
| C-05 | version: 1がハードコードされている | E-04 | ○ |
| C-06 | CI環境でcompress: falseが設定される | E-05 | ○ |
| C-07 | cacheHandlerはpath.relativeで相対パス化される | E-05 | ○ |
| C-08 | configFileプロパティが明示的に削除される | E-04 | ○ |
| C-09 | filesリストにはROUTES_MANIFEST等の定数からファイルパスが構築される | E-06 | ○ |
| C-10 | appDir存在時にAPP_PATHS_MANIFEST等が追加される | E-06 | ○ |
| C-11 | Webpack使用時にMIDDLEWARE_REACT_LOADABLE_MANIFEST等が追加される | E-06 | ○ |
| C-12 | relativeAppDirはpath.relative(outputFileTracingRoot, dir)で計算される | E-04 | ○ |
| C-13 | サーバー起動時にserver/next.tsで参照される | E-07 | ○ |
| C-14 | ビルド初期段階のgenerate-required-server-filesトレースセクション内で生成される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] RequiredServerFilesManifest型定義の6フィールドが正確に記載されているか確認
- [ ] filesリストの条件分岐（appDir有無、Webpack/Turbopack差異）が正確か確認
- [ ] config構築時のフィルタリング（configFile削除、compress設定等）が正確か確認
