---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-_ssgManifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/index.ts` L557-595 - writeClientSsgManifest関数全体
- E-02: `packages/next/src/build/index.ts` L571-578 - ssgPagesセット構築
- E-03: `packages/next/src/build/index.ts` L581-583 - clientSsgManifestContent生成
- E-04: `packages/next/src/build/index.ts` L587-589 - 出力パス決定（deploymentId分岐）
- E-05: `packages/next/src/build/index.ts` L591-594 - writeFileUtf8呼び出し
- E-06: `packages/next/src/build/index.ts` L4101-4106 - 呼び出し元

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SSG対象ページのSetをdevalueでシリアライズする | E-02, E-03 | ○ |
| C-02 | prerenderManifest.routesからsrcRoute==nullでフィルタする | E-02 | ○ |
| C-03 | normalizeLocalePathでロケール正規化される | E-02 | ○ |
| C-04 | prerenderManifest.dynamicRoutesのキーが追加される | E-02 | ○ |
| C-05 | ページパスはソートされる | E-02 | ○ |
| C-06 | __SSG_MANIFESTにSetをアサインする | E-03 | ○ |
| C-07 | __SSG_MANIFEST_CBコールバックを条件付きで呼び出す | E-03 | ○ |
| C-08 | deploymentId存在時はstaticディレクトリ直下に配置 | E-04 | ○ |
| C-09 | deploymentId非存在時はstatic/buildIdディレクトリ下に配置 | E-04 | ○ |
| C-10 | writeFileUtf8で書き込まれる | E-05 | ○ |
| C-11 | writePrerenderManifest後に呼び出される | E-06 | ○ |
| C-12 | buildId, distDir, locales, deploymentIdを引数として受け取る | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] SSGページフィルタリングロジック（srcRoute==null）が正確に記載されているか確認
- [ ] deploymentIdによる出力パス分岐が正確か確認
- [ ] devalueによるSetシリアライズが正確に説明されているか確認
