---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-build-diagnostics.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/diagnostics/build-diagnostics.ts` L7-8 - 定数定義
- E-02: `packages/next/src/diagnostics/build-diagnostics.ts` L13-20 - BuildDiagnosticsインターフェース
- E-03: `packages/next/src/diagnostics/build-diagnostics.ts` L22-27 - getDiagnosticsDir関数
- E-04: `packages/next/src/diagnostics/build-diagnostics.ts` L48-67 - updateBuildDiagnostics関数
- E-05: `packages/next/src/build/index.ts` L1697-1699 - buildStage:'start'呼び出し
- E-06: `packages/next/src/build/index.ts` L1745-1748 - buildStage:'compile'呼び出し
- E-07: `packages/next/src/build/index.ts` L1785-1787 - buildStage:'compile-server'呼び出し
- E-08: `packages/next/src/build/index.ts` L2910-2912 - buildStage:'static-generation'呼び出し
- E-09: `packages/next/src/diagnostics/build-diagnostics.test.ts` L29-66 - ユニットテスト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力先は.next/diagnostics/build-diagnostics.json | E-01 | ○ |
| C-02 | BuildDiagnosticsはbuildStageとbuildOptionsの2フィールド | E-02 | ○ |
| C-03 | diagnosticsディレクトリはmkdir recursiveで自動作成 | E-03 | ○ |
| C-04 | 既存ファイルを読み込んでマージする方式 | E-04 | ○ |
| C-05 | 読み込み失敗時は空オブジェクトにフォールバック | E-04 | ○ |
| C-06 | buildOptionsはシャローマージされる | E-04 | ○ |
| C-07 | JSON.stringify(null, 2)で整形出力 | E-04 | ○ |
| C-08 | ビルド開始時にbuildStage:'start'で呼ばれる | E-05 | ○ |
| C-09 | コンパイルフェーズでbuildStage:'compile'とbuildOptionsが設定される | E-06 | ○ |
| C-10 | サーバーコンパイルでbuildStage:'compile-server'が設定される | E-07 | ○ |
| C-11 | 静的生成フェーズでbuildStage:'static-generation'が設定される | E-08 | ○ |
| C-12 | テストでbuildStageの上書きとbuildOptionsのマージ保持が検証されている | E-09 | ○ |
| C-13 | getDiagnosticsDirはtraceGlobals.get('distDir')からパスを取得 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] buildStageの取りうる値一覧が網羅的か確認
- [ ] buildOptionsのマージ方式（シャローマージ）が正確に記載されているか確認
- [ ] テストケースとの整合性を確認
