---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-incremental-build-diagnostics.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/diagnostics/build-diagnostics.ts` L10 - INCREMENTAL_BUILDS_FILE定数
- E-02: `packages/next/src/diagnostics/build-diagnostics.ts` L88-96 - IncrementalBuildDiagnosticsインターフェース
- E-03: `packages/next/src/diagnostics/build-diagnostics.ts` L101-116 - updateIncrementalBuildMetrics関数
- E-04: `packages/next/src/diagnostics/build-diagnostics.ts` L22-27 - getDiagnosticsDir関数

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル名は'incremental-build-diagnostics.json' | E-01 | ○ |
| C-02 | 出力先は.next/diagnostics/incremental-build-diagnostics.json | E-01, E-04 | ○ |
| C-03 | IncrementalBuildDiagnosticsは7つのオプショナルフィールドを持つ | E-02 | ○ |
| C-04 | changedAppPaths/unchangedAppPathsフィールドがstring[]型 | E-02 | ○ |
| C-05 | changedDependenciesはRecord<string, string>型 | E-02 | ○ |
| C-06 | shuttleGitSha/currentGitShaはstring型 | E-02 | ○ |
| C-07 | 既存ファイルを読み込んでスプレッドマージする | E-03 | ○ |
| C-08 | 読み込み失敗時は空オブジェクトにフォールバック | E-03 | ○ |
| C-09 | JSON.stringify(null, 2)で整形出力 | E-03 | ○ |
| C-10 | diagnosticsディレクトリはmkdir recursiveで自動作成 | E-04 | ○ |
| C-11 | updateIncrementalBuildMetrics関数で更新される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] IncrementalBuildDiagnosticsの7フィールドが正確に記載されているか確認
- [ ] スプレッドマージ方式が正確に説明されているか確認
- [ ] 実際のbuild/index.tsでの呼び出し箇所と引数を確認
