---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-app-paths-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/pages-manifest-plugin.ts` - PagesManifestPlugin（1〜192行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - APP_PATHS_MANIFEST定数（89行目）
- E-03: `packages/next/src/build/index.ts` - ビルド後処理でのマニフェスト読み込み（2133〜2147行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | app-paths-manifest.jsonはPagesManifestPluginにより生成される | E-01 (21行目, 152〜178行目) | ○ |
| C-02 | 出力先は.next/server/app-paths-manifest.json | E-02 (89行目), E-01 (154行目) | ○ |
| C-03 | PagesManifest型を使用する | E-01 (11行目, 49行目) | ○ |
| C-04 | app/プレフィックスのエントリのみが対象 | E-01 (84行目) | ○ |
| C-05 | appDirEnabledがtrueの場合のみ生成される | E-01 (152行目) | ○ |
| C-06 | EdgeランタイムのエントリはedgeServerAppPathsに保存 | E-01 (95行目) | ○ |
| C-07 | NodeランタイムのエントリはnodeServerAppPathsに保存 | E-01 (98行目) | ○ |
| C-08 | distDir指定時はwriteMergedManifestで出力 | E-01 (153〜161行目) | ○ |
| C-09 | distDir未指定時はcompilation.emitAssetで出力 | E-01 (163〜177行目) | ○ |
| C-10 | Edge/Nodeのマニフェストがマージされる | E-01 (159〜160行目, 168〜169行目) | ○ |
| C-11 | ビルド後処理でapp-path-routes-manifest生成の入力データとなる | E-03 (2136〜2147行目) | ○ |
| C-12 | normalizeAppPathで変換される | E-03 (2141行目) | ○ |
| C-13 | webpack-runtimeファイルは除外される | E-01 (65行目) | ○ |
| C-14 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行される | E-01 (185行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PagesManifestPluginのソースコードで全て裏付け可能
- 0: 低リスク - build/index.tsのビルド後処理で利用パスも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] App Routerが無効な場合にファイルが生成されないことを確認
- [ ] Edge/Nodeマージ時の優先順位が意図通りか確認
