---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-trace-build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/trace/types.ts` L1-18 - TraceEvent型定義
- E-02: `packages/next/src/trace/report/to-json-build.ts` L77-90 - allowlistedEvents
- E-03: `packages/next/src/trace/report/to-json-build.ts` L92-132 - reportToJsonBuild関数
- E-04: `packages/next/src/trace/report/to-json-build.ts` L18-75 - RotatingWriteStreamクラス
- E-05: `packages/next/src/trace/report/to-json-build.ts` L134-146 - flushAllエクスポート
- E-06: `packages/next/src/trace/report/to-json.ts` L8-32 - batcher関数
- E-07: `packages/next/src/trace/report/to-json-build.ts` L112-117 - ファイル作成とサイズ制限
- E-08: `packages/next/src/trace/report/to-json-build.ts` L104 - PHASE_PRODUCTION_BUILDチェック

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力先は.next/trace-build | E-03 | ○ |
| C-02 | JSON Lines形式で出力される | E-03 | ○ |
| C-03 | TraceEvent型は8フィールド | E-01 | ○ |
| C-04 | 12個のイベント名が許可リストに含まれる | E-02 | ○ |
| C-05 | PHASE_PRODUCTION_BUILDの場合のみ記録される | E-08 | ○ |
| C-06 | RotatingWriteStreamでサイズ制限付き書き込み | E-04 | ○ |
| C-07 | 本番ビルドではサイズ制限がInfinity（無制限） | E-07 | ○ |
| C-08 | 開発モードでは50MB（52428800バイト）制限 | E-07 | ○ |
| C-09 | batcher関数で100件ごとにフラッシュ | E-06 | ○ |
| C-10 | flushAllでbatch.flushAll後にwriteStream.endを呼ぶ | E-05 | ○ |
| C-11 | traceIdがイベントにスプレッド追加される | E-03 | ○ |
| C-12 | distDirとphaseのtraceGlobalsチェックが行われる | E-03 | ○ |
| C-13 | 書き込みエラーはconsole.logで出力される | E-03 | ○ |
| C-14 | RotatingWriteStreamのrotateはファイル削除→再作成 | E-04 | ○ |
| C-15 | batcher関数はto-json.tsから再利用されている | E-06, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] allowlistedEventsの12イベント名が正確に列挙されているか確認
- [ ] RotatingWriteStreamのサイズ制限（開発50MB/本番無制限）が正確か確認
- [ ] TraceEvent型のフィールド一覧が正確か確認
- [ ] バッチ処理のフラッシュ閾値（100件）が正確か確認
