---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-*.nft.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の目標出力時間**：具体値はソースコードから推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/build/collect-build-traces.ts` 行93-674
- E-02: `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` 行128-797
- E-03: `packages/next/src/shared/lib/constants.ts` 行171
- E-04: `packages/next/src/build/collect-build-traces.ts` 行28-42（makeIgnoreFn）
- E-05: `packages/next/src/build/collect-build-traces.ts` 行44-91（shouldIgnore）
- E-06: `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` 行30-41（NOT_TRACEABLE）
- E-07: `packages/next/src/build/webpack/plugins/next-trace-entrypoints-plugin.ts` 行287-295（createTraceAssets出力部）
- E-08: `packages/next/src/build/collect-build-traces.ts` 行479-485（マージ書き戻し処理）
- E-09: `packages/next/src/build/collect-build-traces.ts` 行138（output === 'standalone' 判定）
- E-10: `packages/next/src/build/collect-build-traces.ts` 行300-362（nodeFileTrace呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFTファイルの構造は { version, files } | E-07 | ○ |
| C-02 | TRACE_OUTPUT_VERSIONは1 | E-03 | ○ |
| C-03 | TraceEntryPointsPluginがwebpackプラグインとして動作 | E-02 | ○ |
| C-04 | collectBuildTracesがビルド後にマージ処理を行う | E-01, E-08 | ○ |
| C-05 | .wasm, .png等のバイナリはトレース対象外 | E-06 | ○ |
| C-06 | ファイルパスは出力ファイルからの相対パス | E-07 | ○ |
| C-07 | 静的ページはトレース対象外 | E-01（行432-434） | ○ |
| C-08 | エッジランタイムルートはトレース不要 | E-01（行587-589） | ○ |
| C-09 | outputFileTracingIncludes/Excludesでカスタマイズ可能 | E-01（行548-671） | ○ |
| C-10 | スタンドアロンモードでjest-workerファイルが含まれる | E-09, E-01（行281-292） | ○ |
| C-11 | ENOENT時にエラーを抑制し空文字列を返す | E-10（行306-313） | ○ |
| C-12 | shouldIgnoreは親の無視状態を再帰チェック | E-05 | ○ |
| C-13 | makeIgnoreFnはpicomatchでパターンマッチ | E-04 | ○ |
| C-14 | filesは昇順ソートされる | E-08（行483: sort()） | ○ |
| C-15 | CI環境でsharp等が除外される | E-01（行247-249） | ○ |
| C-16 | nodeFileTraceはWebpack PROCESS_ASSETS_STAGE_SUMMARIZEで実行 | E-02（行626-629） | ○ |
| C-17 | BuildTraceContext型でデータ受け渡し | E-02（行112-126） | ○ |
| C-18 | パフォーマンス要件の目標出力時間は数秒〜数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のパフォーマンス目標値はソースコードには明示されておらず、実測値からの推測
  - 候補：ベンチマーク結果 / パフォーマンステスト / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NFTファイルの基本構造と生成プロセスは確実にソースコードで確認済み
- 0: 低リスク - webpackプラグインの動作フローはコード上で明確
- 1: 中リスク - パフォーマンス要件は推測値のため、実環境での検証が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NFTファイルの出力パス `.next/server/{page}.nft.json` が正しいことを確認
- [ ] TRACE_OUTPUT_VERSIONの値が最新のソースコードと一致しているか確認
- [ ] outputFileTracingIncludes/Excludes設定の影響範囲が正確に記載されているか確認
- [ ] エラーハンドリングの記述がソースコードと一致しているか確認
