---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-_clientMiddlewareManifest.js

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` 行103-104（TURBOPACK_CLIENT_MIDDLEWARE_MANIFEST定数）
- E-02: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行797-863（writeMiddlewareManifest）
- E-03: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行846-852（JS文字列生成）
- E-04: `packages/next/src/client/page-loader.ts` 行92-152（getMiddleware）
- E-05: `packages/next/src/client/page-loader.ts` 行104-126（Turbopack本番読み込み）
- E-06: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1271-1272（開発サーバーパス登録）
- E-07: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行800-807（出力パス決定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はTURBOPACK_CLIENT_MIDDLEWARE_MANIFEST | E-01 | ○ |
| C-02 | ファイル名は_clientMiddlewareManifest.js | E-01 | ○ |
| C-03 | writeMiddlewareManifestで出力 | E-02 | ○ |
| C-04 | self.__MIDDLEWARE_MATCHERS = ... の形式 | E-03 | ○ |
| C-05 | __MIDDLEWARE_MATCHERS_CBコールバック呼び出し | E-03 | ○ |
| C-06 | middleware['/'].matchersからマッチャー取得 | E-02（行846） | ○ |
| C-07 | 空配列がデフォルト | E-02（行846: `\|\| []`） | ○ |
| C-08 | deploymentIdで出力パスが分岐 | E-07 | ○ |
| C-09 | クライアント側はPageLoader.getMiddlewareで読み込み | E-04 | ○ |
| C-10 | Turbopack本番時はコールバックパターンで非同期ロード | E-05 | ○ |
| C-11 | webpack本番時はprocess.env.__NEXT_MIDDLEWARE_MATCHERS | E-04（行94-101） | ○ |
| C-12 | 開発サーバーでdevVirtualFsItemsに登録 | E-06 | ○ |
| C-13 | サーバーサイドmiddleware-manifest.jsonも同時出力 | E-02（行833-841） | ○ |
| C-14 | writeFileAtomicで書き込み | E-02（行855-858） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 出力パスの分岐条件（deploymentId有無）が正確か確認
- [ ] マッチャー情報の取得元（middleware['/'].matchers）が正しいか確認
- [ ] クライアント側の読み込み方式（webpack vs Turbopack vs dev）の整理が正確か確認
