---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：38-client-build-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **部分マニフェストの詳細構造**：Turbopack側の出力形式は推測

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` 行105（TURBOPACK_CLIENT_BUILD_MANIFEST定数）
- E-02: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行368-381（loadClientBuildManifest）
- E-03: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行474-487（mergeClientBuildManifests）
- E-04: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行567-638（writeClientBuildManifest）
- E-05: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行623-627（JS文字列生成）
- E-06: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行611-616（takeChanged変更検知）
- E-07: `packages/next/src/shared/lib/turbopack/manifest-loader.ts` 行635（_ssgManifest.js出力）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はTURBOPACK_CLIENT_BUILD_MANIFEST | E-01 | ○ |
| C-02 | ファイル名はclient-build-manifest.json | E-01 | ○ |
| C-03 | loadClientBuildManifestで読み込み | E-02 | ○ |
| C-04 | mergeClientBuildManifestsでマージ | E-03 | ○ |
| C-05 | __rewritesとsortedPagesが含まれる | E-03（行479-481） | ○ |
| C-06 | self.__BUILD_MANIFEST = ... の形式で出力 | E-05 | ○ |
| C-07 | __BUILD_MANIFEST_CBコールバック呼び出し | E-05 | ○ |
| C-08 | _ssgManifest.jsも同時に空プレースホルダーで出力 | E-07 | ○ |
| C-09 | deploymentIdで出力パスが分岐 | E-04（行591-609） | ○ |
| C-10 | 開発モードではtakeChangedで変更時のみ書き出し | E-06 | ○ |
| C-11 | getSortedRoutesでページキーをソート | E-04（行589） | ○ |
| C-12 | normalizeRewritesForBuildManifestでリライト正規化 | E-04（行572） | ○ |
| C-13 | Turbopackが出力する部分マニフェストの詳細構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: Turbopack（Rust側）が出力する部分マニフェストの内部構造はRustコード側を調査していない
  - 候補：`turbopack/` ディレクトリ内のRustソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - マージ・書き出しロジックはTypeScript側で確認済み
- 1: 中リスク - 部分マニフェストの生成元（Turbopack Rust）は未調査

## 6) レビュアーチェックリスト（最小）
- [ ] 出力パスの分岐条件が正確か確認
- [ ] mergeClientBuildManifestsのマージロジックが正確か確認
- [ ] _ssgManifest.jsの役割と最終的な上書きタイミングの確認
