---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-_devPagesManifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` 行101（DEV_CLIENT_PAGES_MANIFEST定数）
- E-02: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1265-1266（パス定義・登録）
- E-03: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1278-1288（requestHandler）
- E-04: `packages/next/src/client/page-loader.ts` 行64-90（getPageList）
- E-05: `packages/next/src/client/page-loader.ts` 行68-69（__DEV_PAGES_MANIFESTチェック）
- E-06: `packages/next/src/client/page-loader.ts` 行71-87（fetch処理）
- E-07: `packages/next/src/client/page-bootstrap.ts` 行42-53（HMR更新ハンドラ）
- E-08: `packages/next/src/client/page-loader.ts` 行25（__DEV_PAGES_MANIFEST型定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はDEV_CLIENT_PAGES_MANIFEST | E-01 | ○ |
| C-02 | 値は_devPagesManifest.json | E-01 | ○ |
| C-03 | devVirtualFsItemsに登録（仮想ファイル） | E-02 | ○ |
| C-04 | requestHandlerでHTTPレスポンスとして提供 | E-03 | ○ |
| C-05 | prevSortedRoutesからApp Routerルートを除外 | E-03（行1283-1285） | ○ |
| C-06 | { pages: [...] } 形式で返却 | E-03（行1282-1286） | ○ |
| C-07 | 本番モードではgetClientBuildManifest使用 | E-04（行65-66） | ○ |
| C-08 | __DEV_PAGES_MANIFESTキャッシュ | E-05 | ○ |
| C-09 | fetchで取得しwindow.__DEV_PAGES_MANIFESTに設定 | E-06 | ○ |
| C-10 | fetch失敗時のエラーメッセージ | E-06（行82-85） | ○ |
| C-11 | credentials: 'same-origin' | E-06（行73） | ○ |
| C-12 | HMR DEV_PAGES_MANIFEST_UPDATE時に再取得 | E-07 | ○ |
| C-13 | __DEV_PAGES_MANIFEST型は{ pages: string[] } | E-08 | ○ |
| C-14 | HTTP 200ステータスとContent-Type: application/json | E-03（行1279-1280） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] App Routerルートの除外ロジックが正確か確認
- [ ] HMR更新時の再取得フローが正しいか確認
- [ ] 本番モードとの切り替えが正確か確認
