---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-app-path-routes-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/index.ts` - ビルドプロセス（2133〜2147行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - APP_PATH_ROUTES_MANIFEST定数（90行目）
- E-03: `packages/next/src/shared/lib/router/utils/app-paths.ts` - normalizeAppPath関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build/index.tsのビルド後処理で生成される | E-01 (2133〜2147行目) | ○ |
| C-02 | 出力先は.next/app-path-routes-manifest.json | E-02 (90行目), E-01 (2145行目) | ○ |
| C-03 | app-paths-manifest.jsonを入力として使用する | E-01 (2136行目) | ○ |
| C-04 | normalizeAppPathで変換される | E-01 (2141行目) | ○ |
| C-05 | appDirが存在する場合のみ生成される | E-01 (2135行目 `if (appDir)`) | ○ |
| C-06 | Record<string, string>型である | E-01 (2133行目) | ○ |
| C-07 | キーがApp Router内部パス | E-01 (2140行目 `for (const key in appPathsManifest)`) | ○ |
| C-08 | 値がnormalizeAppPathの返却値 | E-01 (2141行目) | ○ |
| C-09 | .nextディレクトリ直下に出力される（server/ではなく） | E-01 (2145行目 `path.join(distDir, APP_PATH_ROUTES_MANIFEST)`) | ○ |
| C-10 | writeManifest関数で出力される | E-01 (2144行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 生成ロジックが単純で、ソースコードで完全に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] normalizeAppPath関数の変換ロジックが期待通りか確認（グループ・スロット・page/route除去）
- [ ] 出力先がdistDir直下（server/ではなく）であることを確認
